/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public class CMYKToYCbCrConverter
extends ColorConverter {
    private static final int a = 16;
    private static final int b = 1280;
    private static final int c = 1792;
    private static final int d = 512;
    private static final int e = 0x800000;
    private static final int f = 1024;
    private static final int g = 1536;
    private static final int h = 256;
    private static final int i = 32768;
    private static final int j = 768;
    private static final int k = 1280;
    private static final int l = 0;
    private static final int m = 2048;
    private final int[] n = new int[2048];

    public CMYKToYCbCrConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
        for (int i2 = 0; i2 <= 255; ++i2) {
            this.n[i2 + 0] = CMYKToYCbCrConverter.a(0.299) * i2;
            this.n[i2 + 256] = CMYKToYCbCrConverter.a(0.587) * i2;
            this.n[i2 + 512] = CMYKToYCbCrConverter.a(0.114) * i2 + 32768;
            this.n[i2 + 768] = -CMYKToYCbCrConverter.a(0.16874) * i2;
            this.n[i2 + 1024] = -CMYKToYCbCrConverter.a(0.33126) * i2;
            this.n[i2 + 1280] = CMYKToYCbCrConverter.a(0.5) * i2 + 0x800000 + 32768 - 1;
            this.n[i2 + 1536] = -CMYKToYCbCrConverter.a(0.41869) * i2;
            this.n[i2 + 1792] = -CMYKToYCbCrConverter.a(0.08131) * i2;
        }
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destinationBytesPerLine + outputOffset;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n4 = i3 * this.SourceFormat.getChannelsCount() + n2;
                double d2 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d3 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d4 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d5 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                byte by2 = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d2) * (1.0 - d5)));
                byte by3 = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d3) * (1.0 - d5)));
                byte by4 = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d4) * (1.0 - d5)));
                outputData[n3++] = (byte)(this.n[(by2 & 0xFF) + 0] + this.n[(by3 & 0xFF) + 256] + this.n[(by4 & 0xFF) + 512] >> 16);
                outputData[n3++] = (byte)(this.n[(by2 & 0xFF) + 768] + this.n[(by3 & 0xFF) + 1024] + this.n[(by4 & 0xFF) + 1280] >> 16);
                outputData[n3++] = (byte)(this.n[(by2 & 0xFF) + 1280] + this.n[(by3 & 0xFF) + 1536] + this.n[(by4 & 0xFF) + 1792] >> 16);
            }
        }
    }

    private static int a(double d2) {
        return (int)(d2 * 65536.0 + 0.5);
    }
}

