/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;

public class StreamContainer
extends DisposableObject {
    public static final int READ_WRITE_BYTES_COUNT = 4096;
    private final Stream a;
    private final boolean b;
    private final long c;

    public StreamContainer(Stream stream) {
        this(stream, false);
    }

    public StreamContainer(Stream stream, boolean disposeStream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a = stream;
        this.b = disposeStream;
        this.c = this.a.getPosition();
    }

    public long getPosition() {
        this.verifyNotDisposed();
        return this.a.getPosition() - this.c;
    }

    public void setPosition(long value) {
        this.verifyNotDisposed();
        this.a.setPosition(value + this.c);
    }

    public Stream getStream() {
        this.verifyNotDisposed();
        return this.a;
    }

    public boolean isStreamDisposedOnClose() {
        this.verifyNotDisposed();
        return this.b;
    }

    public long getLength() {
        this.verifyNotDisposed();
        return this.a.getLength() - this.c;
    }

    public void setLength(long value) {
        this.verifyNotDisposed();
        this.a.setLength(value + this.c);
    }

    public boolean canRead() {
        this.verifyNotDisposed();
        return this.a.canRead();
    }

    public boolean canSeek() {
        this.verifyNotDisposed();
        return this.a.canSeek();
    }

    public boolean canWrite() {
        this.verifyNotDisposed();
        return this.a.canWrite();
    }

    public static Stream to_Stream(StreamContainer streamContainer) {
        Stream stream = null;
        if (streamContainer != null) {
            stream = streamContainer.a;
        }
        return stream;
    }

    public void flush() {
        this.verifyNotDisposed();
        this.a.flush();
    }

    public void write(byte[] bytes) {
        this.verifyNotDisposed();
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.a.write(bytes, 0, bytes.length);
    }

    public void writeByte(byte value) {
        this.verifyNotDisposed();
        this.a.writeByte(value);
    }

    public int read(byte[] bytes) {
        this.verifyNotDisposed();
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        return this.a.read(bytes, 0, bytes.length);
    }

    public byte[] toBytes() {
        this.verifyNotDisposed();
        return this.toBytes(0L, this.getLength());
    }

    public void shift(long shift) {
        if (this.getPosition() >= this.getLength() || this.getPosition() < 0L) {
            throw new IllegalStateException("FrameworkException: Cannot perform shift as position is out of stream bounds.");
        }
        if (shift != 0L) {
            long l2 = this.getLength();
            if (shift > 0L) {
                this.setLength(l2 + shift);
            }
            if (this.getPosition() + shift < 0L) {
                throw new ArgumentOutOfRangeException("shift", "The backward shift causes data to pass stream beginning. Cannot proceed.");
            }
            byte[] byArray = new byte[4096];
            long l3 = this.getPosition();
            int n2 = (int)msMath.min((long)byArray.length, l2 - l3);
            long l4 = shift > 0L ? l2 - (long)n2 : l3;
            while (n2 > 0) {
                this.setPosition(l4);
                if (this.a.read(byArray, 0, n2) != n2) {
                    throw new IllegalStateException("FrameworkException: Shift error occured. Cannot proceed. The data may be corrupted.");
                }
                this.setPosition(l4 + shift);
                this.a.write(byArray, 0, n2);
                if (shift < 0L) {
                    n2 = (int)msMath.min((long)byArray.length, l2 - (l4 += (long)n2));
                    continue;
                }
                n2 = (int)msMath.min((long)byArray.length, l4 - l3);
                l4 -= (long)n2;
            }
            if (shift < 0L) {
                this.setLength(this.getLength() + shift);
            }
        }
    }

    public byte[] toBytes(long position, long bytesCount) {
        this.verifyNotDisposed();
        if (position >= this.getLength() || position < 0L) {
            throw new ArgumentOutOfRangeException("position", "The starting position is out of stream bounds.");
        }
        if (bytesCount > this.getLength()) {
            throw new ArgumentOutOfRangeException("bytesCount", "The stream does not contain so many bytes.");
        }
        if (bytesCount + position > this.getLength() && bytesCount > 0L) {
            throw new ArgumentException("Reading so many bytes will cause passing the stream end.");
        }
        if (this.a.canSeek()) {
            this.setPosition(position);
        } else if (this.getPosition() != position) {
            throw new IllegalStateException("Cannot seek to the desired position. The stream does not support seeking.");
        }
        byte[] byArray = new byte[(int)bytesCount];
        long l2 = 0L;
        byte[] byArray2 = new byte[4096];
        while (bytesCount > 0L) {
            int n2 = (int)msMath.min((long)byArray2.length, bytesCount);
            if (this.a.read(byArray2, 0, n2) != n2) {
                throw new IllegalStateException(StringExtensions.concat("Copy operation cannot complete. Cannot read ", Int32Extensions.toString(n2), " bytes."));
            }
            Array.copy(Array.boxing(byArray2), 0L, Array.boxing(byArray), l2, (long)n2);
            l2 += (long)n2;
            bytesCount -= (long)n2;
        }
        return byArray;
    }

    public int read(byte[] buffer, int offset, int count) {
        this.verifyNotDisposed();
        return this.a.read(buffer, offset, count);
    }

    public int readByte() {
        this.verifyNotDisposed();
        return this.a.readByte();
    }

    public long seek(long offset, int origin) {
        this.verifyNotDisposed();
        if (origin == 0) {
            this.a.seek(offset + this.c, origin);
        } else {
            this.a.seek(offset, origin);
        }
        return this.getPosition();
    }

    public void seekBegin() {
        this.verifyNotDisposed();
        this.a.seek(this.c, 0);
    }

    public void write(byte[] buffer, int offset, int count) {
        this.verifyNotDisposed();
        this.a.write(buffer, offset, count);
    }

    public void save(Stream destinationStream) {
        this.saveInternal(destinationStream, 4096, this.getLength());
    }

    void save(Stream destinationStream, int bufferSize) {
        this.saveInternal(destinationStream, bufferSize, this.getLength());
    }

    public void saveInternal(Stream destinationStream, int bufferSize, long length) {
        int n2;
        this.verifyNotDisposed();
        if (destinationStream == null) {
            throw new ArgumentNullException("destinationStream");
        }
        if (destinationStream == this.a) {
            throw new IllegalStateException("Saving to the same stream is not allowed.");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The buffer must be positive.");
        }
        this.beforeSave(destinationStream);
        byte[] byArray = new byte[(int)msMath.min((long)bufferSize, length)];
        while (length > 0L && (n2 = this.a.read(byArray, 0, (int)msMath.min((long)byArray.length, length))) > 0) {
            destinationStream.write(byArray, 0, n2);
            length -= (long)n2;
        }
    }

    public void save(String filePath) {
        this.save(filePath, 4096, this.getLength());
    }

    public void save(String filePath, int bufferSize) {
        this.save(filePath, bufferSize, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath, int bufferSize, long length) {
        this.verifyNotDisposed();
        if (filePath == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a.setPosition(0L);
        FileStream fileStream = File.create(filePath);
        try {
            this.saveInternal(fileStream, bufferSize, length);
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public void writeTo(StreamContainer streamContainer) {
        long l2 = this.getLength() - this.getPosition();
        this.writeTo(streamContainer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(StreamContainer streamContainer, long length) {
        MemoryStream memoryStream = new MemoryStream(this.toBytes());
        try {
            byte[] byArray = new byte[4096];
            while (length > 0L) {
                int n2 = (int)msMath.min((long)byArray.length, length);
                if (((Stream)memoryStream).read(byArray, 0, n2) != n2) {
                    throw new IllegalStateException(StringExtensions.concat("Copy operation cannot complete. Cannot read ", Int32Extensions.toString(n2), " bytes."));
                }
                length -= (long)n2;
                streamContainer.write(byArray, 0, n2);
            }
        }
        finally {
            if (memoryStream != null) {
                memoryStream.dispose();
            }
        }
    }

    protected void afterStreamDisposed() {
    }

    protected void beforeStreamDisposed() {
    }

    public void beforeSave(Stream destinationStream) {
    }

    @Override
    protected void releaseManagedResources() {
        try {
            this.a();
        }
        finally {
            super.releaseManagedResources();
        }
    }

    private void a() {
        if (this.b) {
            this.beforeStreamDisposed();
            try {
                this.a.dispose();
            }
            finally {
                this.afterStreamDisposed();
            }
        }
    }
}

