/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.Printing.Loaders;

import com.aspose.html.internal.ms.System.Drawing.Printing.PageSettings;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSize;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSource;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterResolution;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterSettings;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.Converters.MediaSizePaperSizeConverter;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.Converters.MediaTrayPaperSourceConverter;
import java.io.File;
import java.net.URI;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;

public class PrintAttributesLoader {
    private PrinterSettings a;
    private PageSettings b;
    private PrintService c;
    private PrintRequestAttributeSet d;
    private Class[] e;

    public PrintAttributesLoader(PrinterSettings printerSettings) {
        this.a = printerSettings;
        this.b = printerSettings.getDefaultPageSettings();
        this.c = this.a.getPrintService();
        this.e = this.c.getSupportedAttributeCategories();
        this.d = new HashPrintRequestAttributeSet();
    }

    public PrintAttributesLoader convert() {
        this.c();
        this.b();
        this.f();
        this.d();
        this.e();
        this.a();
        this.d.add(PrintQuality.NORMAL);
        this.d.add(PrintQuality.DRAFT);
        this.d.add(PrintQuality.HIGH);
        return this;
    }

    private void a() {
        if (this.a.getPrintToFile()) {
            File file = new File(this.a.getPrintFileName());
            URI uRI = file.toURI();
            this.d.add(new Destination(uRI));
        }
    }

    void assignMediaTray() {
        if (!this.a(Media.class)) {
            return;
        }
        PaperSource paperSource = this.b.getPaperSource();
        int n2 = paperSource.getKind();
        MediaTray mediaTray = MediaTrayPaperSourceConverter.convertToMediaTray(n2);
        if (mediaTray == null) {
            return;
        }
        this.d.add(mediaTray);
    }

    private void b() {
        if (!this.a(Media.class)) {
            return;
        }
        PaperSize paperSize = this.b.getPaperSize();
        String string = paperSize.getPaperName();
        MediaSize mediaSize = MediaSizePaperSizeConverter.convertToMediaSize(string);
        MediaSizeName mediaSizeName = mediaSize.getMediaSizeName();
        this.d.add(mediaSizeName);
    }

    private void c() {
        if (!this.a(Chromaticity.class)) {
            return;
        }
        boolean bl2 = this.b.getColor();
        if (bl2) {
            this.d.add(Chromaticity.COLOR);
        } else {
            this.d.add(Chromaticity.MONOCHROME);
        }
    }

    public void assignPageLandscape(PageSettings pageSettings) {
        if (!this.a(OrientationRequested.class)) {
            return;
        }
        boolean bl2 = pageSettings.getLandscape();
        if (bl2) {
            this.d.add(OrientationRequested.LANDSCAPE);
        } else {
            this.d.add(OrientationRequested.PORTRAIT);
        }
    }

    private void d() {
        int n2;
        if (!this.a(Copies.class)) {
            return;
        }
        int n3 = this.a.getCopies();
        if (n3 > (n2 = this.a.getMaximumCopies())) {
            n3 = n2;
        }
        this.d.add(new Copies(n3));
    }

    public void assignResolution(PageSettings pageSettings) {
        if (!this.a(javax.print.attribute.standard.PrinterResolution.class)) {
            return;
        }
        PrinterResolution printerResolution = pageSettings.getPrinterResolution();
        this.d.add(new javax.print.attribute.standard.PrinterResolution(printerResolution.getX(), printerResolution.getY(), 100));
    }

    private void e() {
        if (!this.a(Sides.class)) {
            return;
        }
        if (this.a.getDuplex() != -1) {
            this.d.add(Sides.DUPLEX);
        } else {
            this.d.add(Sides.ONE_SIDED);
        }
    }

    private boolean a(Class clazz) {
        for (Class clazz2 : this.e) {
            if (!clazz.equals(clazz2)) continue;
            return true;
        }
        return false;
    }

    private void f() {
        if (!this.a(MediaPrintableArea.class)) {
            return;
        }
        this.d.add(new MediaPrintableArea(0, 0, this.b.getBounds().getWidth() / 100, this.b.getBounds().getHeight() / 100, 25400));
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.d;
    }
}

