/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Comparer;
import com.aspose.html.internal.ms.System.Comparison;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.InvalidCastException;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.RankException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.ValueType;
import com.aspose.html.internal.ms.lang.Struct;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;

@Deprecated
public final class msArray {
    private msArray() {
    }

    public static int indexOf(int[] array, int value, int startIndex, int count) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        if (startIndex < 0 || startIndex > array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        int n2 = startIndex + count;
        if (count < 0 || n2 > array.length) {
            throw new ArgumentOutOfRangeException("count");
        }
        for (int i2 = startIndex; i2 < n2; ++i2) {
            if (value != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (startIndex < 0 || startIndex > array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        int n2 = startIndex + count;
        if (count < 0 || n2 > array.length) {
            throw new ArgumentOutOfRangeException("count");
        }
        for (int i2 = startIndex; i2 < n2; ++i2) {
            if (value != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        return msArray.indexOf(array, value, 0, array.length);
    }

    public static int indexOf(Object[] array, Object value) {
        return msArray.indexOf(array, value, 0, array.length);
    }

    public static int indexOf(Object[] array, Object value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (startIndex < 0 || startIndex > array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        int n2 = startIndex + count;
        if (count < 0 || n2 > array.length) {
            throw new ArgumentOutOfRangeException("count");
        }
        if (value == null) {
            for (int i2 = startIndex; i2 < n2; ++i2) {
                if (array[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = startIndex; i3 < n2; ++i3) {
                if (!value.equals(array[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.length == 0) {
            return -1;
        }
        if (startIndex < 0 || startIndex >= array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || count > startIndex + 1) {
            throw new ArgumentOutOfRangeException("count");
        }
        int n2 = startIndex - count + 1;
        for (int i2 = startIndex; i2 >= n2; --i2) {
            if (value != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.length == 0) {
            return -1;
        }
        if (startIndex < 0 || startIndex >= array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || count > startIndex + 1) {
            throw new ArgumentOutOfRangeException("count");
        }
        int n2 = startIndex - count + 1;
        for (int i2 = startIndex; i2 >= n2; --i2) {
            if (!ObjectExtensions.equals(value, array[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static void reverse(float[] array) {
        msArray.reverse(array, 0, array.length);
    }

    public static void reverse(float[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length");
        }
        if (array.length - index < length) {
            throw new ArgumentOutOfRangeException("length");
        }
        int n2 = index;
        for (int i2 = index + length - 1; n2 < i2; ++n2, --i2) {
            float f2 = array[n2];
            array[n2] = array[i2];
            array[i2] = f2;
        }
    }

    public static void reverse(Object[] array) {
        msArray.reverse(array, 0, array.length);
    }

    public static void reverse(Object[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length");
        }
        if (array.length - index < length) {
            throw new ArgumentOutOfRangeException("length");
        }
        int n2 = index;
        for (int i2 = index + length - 1; n2 < i2; ++n2, --i2) {
            Object object = array[n2];
            array[n2] = array[i2];
            array[i2] = object;
        }
    }

    public static void reverse(int[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length");
        }
        if (array.length - index < length) {
            throw new ArgumentOutOfRangeException("length");
        }
        int n2 = index;
        for (int i2 = index + length - 1; n2 < i2; ++n2, --i2) {
            int n3 = array[n2];
            array[n2] = array[i2];
            array[i2] = n3;
        }
    }

    public static void reverse(byte[] array) {
        msArray.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length");
        }
        if (array.length - index < length) {
            throw new ArgumentOutOfRangeException("length");
        }
        int n2 = index;
        for (int i2 = index + length - 1; n2 < i2; ++n2, --i2) {
            byte by2 = array[n2];
            array[n2] = array[i2];
            array[i2] = by2;
        }
    }

    public static void reverse(boolean[] array) {
        msArray.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length");
        }
        if (array.length - index < length) {
            throw new ArgumentOutOfRangeException("length");
        }
        int n2 = index;
        for (int i2 = index + length - 1; n2 < i2; ++n2, --i2) {
            boolean bl2 = array[n2];
            array[n2] = array[i2];
            array[i2] = bl2;
        }
    }

    public static void reverse(char[] array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length");
        }
        if (array.length - index < length) {
            throw new ArgumentOutOfRangeException("length");
        }
        int n2 = index;
        for (int i2 = index + length - 1; n2 < i2; ++n2, --i2) {
            char c2 = array[n2];
            array[n2] = array[i2];
            array[i2] = c2;
        }
    }

    public static void reverse(char[] array) {
        msArray.reverse(array, 0, array.length);
    }

    public static void clear(byte[] array, int index, int length) {
        Arrays.fill(array, index, index + length, (byte)0);
    }

    public static void clear(int[] array, int index, int length) {
        Arrays.fill(array, index, index + length, 0);
    }

    public static void clear(char[] array, int index, int length) {
        Arrays.fill(array, index, index + length, '\u0000');
    }

    public static void clear(short[] array, int index, int length) {
        Arrays.fill(array, index, index + length, (short)0);
    }

    public static void clear(long[] array, int index, int length) {
        Arrays.fill(array, index, index + length, 0L);
    }

    public static void clear(boolean[] array, int index, int length) {
        Arrays.fill(array, index, index + length, false);
    }

    public static void clear(Object[] array, int index, int length) {
        Arrays.fill(array, index, index + length, null);
    }

    public static void fill(byte[] buffer, int offset, int count, byte value) {
        Arrays.fill(buffer, offset, offset + count, value);
    }

    public static void sort(int[] array, int index, int length) {
        Arrays.sort(array, index, index + length);
    }

    public static void sort(byte[] array, int index, int length) {
        Arrays.sort(array, index, index + length);
    }

    public static void sort(int[] array) {
        Arrays.sort(array);
    }

    public static void sort(String[] array) {
        Arrays.sort(array);
    }

    public static void sort(String[] array, Comparator comparator) {
        Arrays.sort(array, comparator);
    }

    public static void sort(Object[] array, Comparator comparator) {
        Arrays.sort(array, comparator);
    }

    public static Object clone(Object array) {
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof Object[]) {
            return ((Object[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        return null;
    }

    public static short[] toShortArray(byte[] byteArray) {
        short[] sArray = new short[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            sArray[i2] = (short)(byteArray[i2] & 0xFF);
        }
        return sArray;
    }

    public static byte[] toByteArray(short[] shortArray) {
        byte[] byArray = new byte[shortArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(shortArray[i2] & 0xFF);
        }
        return byArray;
    }

    public static boolean contains(byte[] source, byte[] target) {
        if (source == null || target == null) {
            return false;
        }
        byte by2 = target[0];
        int n2 = target.length;
        int n3 = source.length;
        if (n2 > n3) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (source[i2] != by2) continue;
            int n4 = i2 + 1;
            int n5 = n4 + n2 - 1;
            if (n5 > n3) {
                return false;
            }
            int n6 = 1;
            while (n4 < n5) {
                if (source[n4] != target[n6]) {
                    return false;
                }
                ++n4;
                ++n6;
            }
            return true;
        }
        return false;
    }

    public static void checkBounds(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset");
        }
        if (offset > bytes.length - length) {
            throw new ArgumentOutOfRangeException("offset + length");
        }
    }

    public static void checkBounds(int[] array, int offset, int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset");
        }
        if (offset > array.length - length) {
            throw new ArgumentOutOfRangeException("offset + length");
        }
    }

    public static String arrayToString(byte[] data, int start, int count) {
        StringBuilder stringBuilder = new StringBuilder();
        while (count > 0) {
            char c2 = (char)data[start];
            if (Character.isISOControl(c2)) {
                c2 = '.';
            } else if (c2 > '\u007f') {
                c2 = (char)(c2 + 1168);
            }
            stringBuilder.append(c2);
            ++start;
            --count;
        }
        return stringBuilder.toString();
    }

    public static String printToString(float[] data, int start, int count) {
        StringBuilder stringBuilder = new StringBuilder("[");
        while (count > 0) {
            stringBuilder.append(data[start] + "; ");
            ++start;
            --count;
        }
        return stringBuilder.append("]").toString();
    }

    public static String printToString(double[] data, int start, int count) {
        StringBuilder stringBuilder = new StringBuilder("[");
        while (count > 0) {
            stringBuilder.append(data[start] + "; ");
            ++start;
            --count;
        }
        return stringBuilder.append("]").toString();
    }

    public static String arrayToStringCombined(byte[] data, int start, int count) {
        StringBuilder stringBuilder = new StringBuilder();
        count -= start;
        int n2 = 16;
        for (int i2 = start; i2 < count; i2 += 16) {
            if (i2 + n2 > count) {
                n2 = count - i2;
            }
            stringBuilder.append(msArray.dumpArray(data, i2, n2)).append(" | ").append(msArray.arrayToString(data, i2, n2)).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String dumpArray(byte[] data, int start, int count) {
        StringBuilder stringBuilder = new StringBuilder();
        while (count > 0) {
            stringBuilder.append(Int32Extensions.toString(data[start] & 0xFF, "x2")).append(" ");
            ++start;
            --count;
        }
        return stringBuilder.toString();
    }

    public static int getRank(Object array) {
        int n2 = 0;
        Class<?> clazz = array.getClass();
        while (clazz.isArray()) {
            ++n2;
            clazz = clazz.getComponentType();
        }
        return n2;
    }

    public static int getLowerBound(Object array, int dimension) {
        if (array == null) {
            throw new NullReferenceException();
        }
        if (dimension < 0 || msArray.getRank(array) - 1 < dimension) {
            throw new ArgumentException("invalid dimension");
        }
        return 0;
    }

    public static int getUpperBound(Object array, int dimension) {
        if (array == null) {
            throw new NullReferenceException("array is null");
        }
        if (dimension < 0 || msArray.getRank(array) - 1 < dimension) {
            throw new ArgumentException("invalid dimension");
        }
        for (int i2 = 0; i2 < dimension; ++i2) {
            if ((array = Array.get(array, 0)) != null) continue;
            return -1;
        }
        return Array.getLength(array) - 1;
    }

    public static int getLength(Object array, int dimension) {
        if (array == null) {
            throw new NullReferenceException("array is null");
        }
        return msArray.getUpperBound(array, dimension) + 1;
    }

    public static void setValue(Object array, Object value, int index) {
        if (array == null) {
            throw new NullReferenceException();
        }
        Array.set(array, index, value);
    }

    public static <T> T[] createArrayWithInitialization(Class<T> aClass, int length) {
        boolean bl2 = Struct.class.isAssignableFrom(aClass);
        Object[] objectArray = (Object[])Array.newInstance(aClass, length);
        if (bl2) {
            try {
                Constructor<T> constructor = aClass.getConstructor(new Class[0]);
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray[i2] = constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return objectArray;
    }

    public static <T> T[][] createArrayWithInitialization(Class<T> aClass, int d1, int d2) {
        Object[][] objectArray = (Object[][])Array.newInstance(aClass, d1, d2);
        for (int i2 = 0; i2 < d1; ++i2) {
            for (int i3 = 0; i3 < d2; ++i3) {
                Object var6_6 = null;
                try {
                    var6_6 = aClass.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                objectArray[i2][i3] = var6_6;
            }
        }
        return objectArray;
    }

    public static <T extends ValueType<T>> void arraycopy(T[] src, int srcIndex, T[] dest, int destIndex, int length) {
        if (src == null) {
            throw new ArgumentNullException("src");
        }
        if (dest == null) {
            throw new ArgumentNullException("dest");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (srcIndex < 0) {
            throw new ArgumentOutOfRangeException("srcPos", "Non-negative number required.");
        }
        if (destIndex < 0) {
            throw new ArgumentOutOfRangeException("destPos", "Non-negative number required.");
        }
        if (srcIndex > src.length - length) {
            throw new ArgumentException("length");
        }
        if (destIndex > dest.length - length) {
            String string = StringExtensions.concat("Destination array was not long enough. Check ", "destIndex and length");
            throw new ArgumentException(string, StringExtensions.Empty);
        }
        int n2 = srcIndex + length;
        int n3 = destIndex;
        int n4 = srcIndex;
        while (n4 < n2) {
            dest[n3] = (ValueType)((ValueType)src[n4]).Clone();
            ++n4;
            ++n3;
        }
    }

    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        if (dest == null) {
            throw new ArgumentNullException("dest");
        }
        if (msArray.a(src) && msArray.a(dest)) {
            return;
        }
        if (src.getClass().getComponentType() != dest.getClass().getComponentType() && src.getClass().getComponentType() != Object.class && dest.getClass().getComponentType() != Object.class) {
            throw new InvalidCastException(src.getClass().getComponentType() + " != " + dest.getClass().getComponentType());
        }
        if (Struct.class.isAssignableFrom(src.getClass().getComponentType())) {
            Object[] objectArray = new Object[length];
            for (int i2 = 0; i2 < length; ++i2) {
                Array.set(objectArray, i2, ((Struct)Array.get(src, srcPos + i2)).Clone());
            }
            System.arraycopy(objectArray, 0, dest, destPos, length);
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static Object[] createInstance(Type elementType, int ... lengths) {
        throw new NotImplementedException();
    }

    public static Object[] createInstance(Type elementType, long ... lengths) {
        throw new NotImplementedException();
    }

    public static Object[] createInstance(Type elementType, int length) {
        Class clazz = elementType.getJavaClass();
        Object[] objectArray = msArray.createArrayWithInitialization(clazz, length);
        if (elementType.isPrimitive()) {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = clazz.equals(Boolean.class) ? Boolean.valueOf(false) : (clazz.equals(Character.class) ? (Serializable)Character.valueOf('\u0000') : (Serializable)(clazz.equals(Double.class) ? (Number)0.0 : (Number)(clazz.equals(Float.class) ? (Number)Float.valueOf(0.0f) : (Number)(clazz.equals(Byte.class) ? (Number)((byte)0) : (Number)(clazz.equals(Integer.class) ? (Number)0 : (Number)(clazz.equals(Long.class) ? (Number)0L : (Number)0))))));
            }
        }
        return objectArray;
    }

    public static Object[] createInstance(Type elementType, int[] lengths, int[] lowerBounds) {
        throw new NotImplementedException();
    }

    public static Object[] createInstance(Type elementType, int length1, int length2) {
        throw new NotImplementedException();
    }

    public static Object[] createInstance(Type elementType, int length1, int length2, int length3) {
        throw new NotImplementedException();
    }

    private static boolean a(Object object) {
        if (object != null) {
            for (int i2 = 0; i2 < Array.getLength(object); ++i2) {
                if (Array.get(object, i2) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static int binarySearch(Object[] array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (value == null) {
            return -1;
        }
        if (msArray.getRank(array) > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.length == 0) {
            return -1;
        }
        if (!(value instanceof Comparable)) {
            throw new ArgumentException("value does not support IComparable.");
        }
        return msArray.a(array, msArray.getLowerBound(array, 0), msArray.getLength(array, 0), value, null);
    }

    public static int binarySearch(Object[] array, Object value, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (msArray.getRank(array) > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.length == 0) {
            return -1;
        }
        if (comparer == null && value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return msArray.a(array, msArray.getLowerBound(array, 0), msArray.getLength(array, 0), value, comparer);
    }

    public static int binarySearch(Object[] array, int index, int length, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (msArray.getRank(array) > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < msArray.getLowerBound(array, 0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Value has to be >= 0.");
        }
        if (index > msArray.getLowerBound(array, 0) + msArray.getLength(array, 0) - length) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.length == 0) {
            return -1;
        }
        if (value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("value does not support IComparable");
        }
        return msArray.a(array, index, length, value, null);
    }

    public static int binarySearch(Object[] array, int index, int length, Object value, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (msArray.getRank(array) > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < msArray.getLowerBound(array, 0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Value has to be >= 0.");
        }
        if (index > msArray.getLowerBound(array, 0) + msArray.getLength(array, 0) - length) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.length == 0) {
            return -1;
        }
        if (comparer == null && value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return msArray.a(array, index, length, value, comparer);
    }

    static int a(Object[] objectArray, int n2, int n3, Object object, Comparator comparator) {
        if (comparator == null) {
            comparator = Comparer.Default;
        }
        int n4 = n2;
        int n5 = n2 + n3 - 1;
        int n6 = 0;
        while (n4 <= n5) {
            int n7 = n4 + (n5 - n4) / 2;
            Object object2 = objectArray[n7];
            try {
                n6 = comparator.compare(object2, object);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("value is not of the same type", exception);
            }
            if (n6 == 0) {
                return n7;
            }
            if (n6 > 0) {
                n5 = n7 - 1;
                continue;
            }
            n4 = n7 + 1;
        }
        return ~n4;
    }

    public static class FunctorComparer<T>
    implements Comparator<T> {
        private final Comparison<T> a;

        public FunctorComparer(Comparison<T> comparison) {
            this.a = comparison;
        }

        @Override
        public int compare(T x2, T y2) {
            return this.a.invoke(x2, y2);
        }
    }
}

