/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Xml.Compiler;
import com.aspose.html.internal.ms.System.Xml.Pattern;
import com.aspose.html.internal.ms.System.Xml.XPathExpression;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XslAvt;
import com.aspose.html.internal.ms.System.Xml.XslCompiledElement;
import com.aspose.html.internal.ms.System.Xml.XslTransformProcessor;
import com.aspose.html.internal.ms.System.Xml.XsltException;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

class XslNumber
extends XslCompiledElement {
    private int a;
    private Pattern b;
    private Pattern c;
    private XPathExpression d;
    private XslAvt e;
    private XslAvt f;
    private XslAvt g;
    private XslAvt h;
    private XslAvt i;
    private static final StringSwitchMap j = new StringSwitchMap("single", "multiple", "any", "");

    public XslNumber(Compiler c2) {
        super(c2);
    }

    @Override
    protected void init() {
    }

    public static double round(double n2) {
        double d2 = Math.floor(n2);
        return n2 - d2 >= 0.5 ? d2 + 1.0 : d2;
    }

    @Override
    protected void compile(Compiler c2) {
        if (c2.getDebugger() != null) {
            c2.getDebugger().debugCompile(this.getDebugInput());
        }
        c2.checkExtraAttributes("number", "level", "count", "from", "value", "format", "lang", "letter-value", "grouping-separator", "grouping-size");
        switch (j.of(c2.getAttribute("level"))) {
            case 0: {
                this.a = 0;
                break;
            }
            case 1: {
                this.a = 1;
                break;
            }
            case 2: {
                this.a = 2;
                break;
            }
            default: {
                this.a = 0;
            }
        }
        this.b = c2.compilePattern(c2.getAttribute("count"), c2.getInput());
        this.c = c2.compilePattern(c2.getAttribute("from"), c2.getInput());
        this.d = c2.compileExpression(c2.getAttribute("value"));
        this.e = c2.parseAvtAttribute("format");
        this.f = c2.parseAvtAttribute("lang");
        this.g = c2.parseAvtAttribute("letter-value");
        this.h = c2.parseAvtAttribute("grouping-separator");
        this.i = c2.parseAvtAttribute("grouping-size");
    }

    @Override
    public void evaluate(XslTransformProcessor p2) {
        String string;
        if (p2.getDebugger() != null) {
            p2.getDebugger().debugExecute(p2, this.getDebugInput());
        }
        if (!StringExtensions.equals(string = this.b(p2), StringExtensions.Empty)) {
            p2.getOut().writeString(string);
        }
    }

    private XslNumberFormatter a(XslTransformProcessor xslTransformProcessor) {
        String string = "1";
        String string2 = null;
        String string3 = null;
        char c2 = '\u0000';
        Decimal decimal = Decimal.newDecimalFromInt(0);
        if (this.e != null) {
            string = this.e.evaluate(xslTransformProcessor);
        }
        if (this.f != null) {
            string2 = this.f.evaluate(xslTransformProcessor);
        }
        if (this.g != null) {
            string3 = this.g.evaluate(xslTransformProcessor);
        }
        if (this.h != null) {
            c2 = this.h.evaluate(xslTransformProcessor).charAt(0);
        }
        if (this.i != null) {
            decimal = Decimal.parse(this.i.evaluate(xslTransformProcessor), CultureInfo.getInvariantCulture());
        }
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(Integer.MAX_VALUE)) || Decimal.op_LessThan(decimal, Decimal.newDecimalFromInt(1))) {
            decimal = Decimal.newDecimalFromInt(0);
        }
        return new XslNumberFormatter(string, string2, string3, c2, Decimal.to_IntFromDecimal(decimal));
    }

    private String b(XslTransformProcessor xslTransformProcessor) {
        XslNumberFormatter xslNumberFormatter = this.a(xslTransformProcessor);
        if (this.d != null) {
            double d2 = xslTransformProcessor.evaluateNumber(this.d);
            return xslNumberFormatter.format(d2);
        }
        switch (this.a) {
            case 0: {
                int n2 = this.e(xslTransformProcessor);
                return xslNumberFormatter.format(n2, n2 != 0);
            }
            case 1: {
                return xslNumberFormatter.format(this.c(xslTransformProcessor));
            }
            case 2: {
                int n3 = this.d(xslTransformProcessor);
                return xslNumberFormatter.format(n3, n3 != 0);
            }
        }
        throw new XsltException("Should not get here", null, xslTransformProcessor.getCurrentNode());
    }

    private int[] c(XslTransformProcessor xslTransformProcessor) {
        ArrayList arrayList = new ArrayList();
        XPathNavigator xPathNavigator = xslTransformProcessor.getCurrentNode().deepClone();
        boolean bl2 = false;
        do {
            if (this.b(xPathNavigator, xslTransformProcessor)) {
                bl2 = true;
                break;
            }
            if (!this.a(xPathNavigator, xslTransformProcessor)) continue;
            int n2 = 1;
            while (xPathNavigator.moveToPrevious()) {
                if (!this.a(xPathNavigator, xslTransformProcessor)) continue;
                ++n2;
            }
            arrayList.addItem(n2);
        } while (xPathNavigator.moveToParent());
        if (!bl2) {
            return new int[0];
        }
        int[] nArray = new int[arrayList.size()];
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            nArray[--n3] = (Integer)arrayList.get_Item(i2);
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    private int d(XslTransformProcessor var1_1) {
        var2_2 = 0;
        var3_3 = var1_1.getCurrentNode().deepClone();
        var3_3.moveToRoot();
        v0 = var4_4 = this.c == null;
        block0: while (true) {
            if (this.c != null && this.b(var3_3, var1_1)) {
                var4_4 = true;
                var2_2 = 0;
            } else if (var4_4 && this.a(var3_3, var1_1)) {
                ++var2_2;
            }
            if (var3_3.isSamePosition(var1_1.getCurrentNode())) {
                return var2_2;
            }
            if (var3_3.moveToFirstChild()) continue;
            do {
                if (!var3_3.moveToNext()) ** break;
                continue block0;
            } while (var3_3.moveToParent());
            break;
        }
        return 0;
    }

    private int e(XslTransformProcessor xslTransformProcessor) {
        XPathNavigator xPathNavigator = xslTransformProcessor.getCurrentNode().deepClone();
        while (!this.a(xPathNavigator, xslTransformProcessor)) {
            if (this.c != null && this.b(xPathNavigator, xslTransformProcessor)) {
                return 0;
            }
            if (xPathNavigator.moveToParent()) continue;
            return 0;
        }
        if (this.c != null) {
            XPathNavigator xPathNavigator2 = xPathNavigator.deepClone();
            if (this.b(xPathNavigator2, xslTransformProcessor)) {
                return 0;
            }
            boolean bl2 = false;
            while (xPathNavigator2.moveToParent()) {
                if (!this.b(xPathNavigator2, xslTransformProcessor)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return 0;
            }
        }
        int n2 = 1;
        while (xPathNavigator.moveToPrevious()) {
            if (!this.a(xPathNavigator, xslTransformProcessor)) continue;
            ++n2;
        }
        return n2;
    }

    private boolean a(XPathNavigator xPathNavigator, XslTransformProcessor xslTransformProcessor) {
        if (this.b == null) {
            return xPathNavigator.getNodeType() == xslTransformProcessor.getCurrentNode().getNodeType() && StringExtensions.equals(xPathNavigator.getLocalName(), xslTransformProcessor.getCurrentNode().getLocalName()) && StringExtensions.equals(xPathNavigator.getNamespaceURI(), xslTransformProcessor.getCurrentNode().getNamespaceURI());
        }
        return xslTransformProcessor.matches(this.b, xPathNavigator);
    }

    private boolean b(XPathNavigator xPathNavigator, XslTransformProcessor xslTransformProcessor) {
        if (this.c == null) {
            return xPathNavigator.getNodeType() == 0;
        }
        return xslTransformProcessor.matches(this.c, xPathNavigator);
    }

    private static class XslNumberFormatter {
        private String a;
        private String b;
        private ArrayList c = new ArrayList();

        public XslNumberFormatter(String format, String lang, String letterValue, char groupingSeparator, int groupingSize) {
            if (format == null || "".equals(format)) {
                this.c.addItem(FormatItem.getItem(null, "1", groupingSeparator, groupingSize));
            } else {
                NumberFormatterScanner numberFormatterScanner = new NumberFormatterScanner(format);
                String string = ".";
                this.a = numberFormatterScanner.advance(false);
                String string2 = numberFormatterScanner.advance(true);
                if (string2 == null) {
                    string = this.a;
                    this.a = null;
                    this.c.addItem(FormatItem.getItem(string, "1", groupingSeparator, groupingSize));
                } else {
                    this.c.addItem(FormatItem.getItem(".", string2, groupingSeparator, groupingSize));
                    do {
                        string = numberFormatterScanner.advance(false);
                        string2 = numberFormatterScanner.advance(true);
                        if (string2 == null) {
                            this.b = string;
                            break;
                        }
                        this.c.addItem(FormatItem.getItem(string, string2, groupingSeparator, groupingSize));
                    } while (string2 != null);
                }
            }
        }

        public String format(double value) {
            return this.format(value, true);
        }

        public String format(double value, boolean formatContent) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            if (this.a != null) {
                msStringBuilder2.append(this.a);
            }
            if (formatContent) {
                ((FormatItem)this.c.get_Item(0)).format(msStringBuilder2, value);
            }
            if (this.b != null) {
                msStringBuilder2.append(this.b);
            }
            return msStringBuilder2.toString();
        }

        public String format(int[] values) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            if (this.a != null) {
                msStringBuilder2.append(this.a);
            }
            int n2 = 0;
            int n3 = this.c.size() - 1;
            if (values.length > 0) {
                if (this.c.size() > 0) {
                    FormatItem formatItem = (FormatItem)this.c.get_Item(n2);
                    formatItem.format(msStringBuilder2, values[0]);
                }
                if (n2 < n3) {
                    ++n2;
                }
            }
            for (int i2 = 1; i2 < values.length; ++i2) {
                FormatItem formatItem = (FormatItem)this.c.get_Item(n2);
                msStringBuilder2.append(formatItem.sep);
                int n4 = values[i2];
                formatItem.format(msStringBuilder2, n4);
                if (n2 >= n3) continue;
                ++n2;
            }
            if (this.b != null) {
                msStringBuilder2.append(this.b);
            }
            return msStringBuilder2.toString();
        }

        private static class DigitItem
        extends FormatItem {
            private NumberFormatInfo a = new NumberFormatInfo();
            private int b;
            private msStringBuilder c;

            public DigitItem(String sep, int len, char gpSep, int gpSize) {
                super(sep);
                this.a.setNumberDecimalDigits(0);
                this.a.setNumberGroupSizes(new int[]{0});
                if (gpSep != '\u0000' && gpSize > 0) {
                    this.a.setNumberGroupSeparator(Character.toString(gpSep));
                    this.a.setNumberGroupSizes(new int[]{gpSize});
                }
                this.b = len;
            }

            @Override
            public void format(msStringBuilder b2, double num) {
                String string = DoubleExtensions.toString(num, "N", this.a);
                int n2 = this.b;
                if (n2 > 1) {
                    if (this.c == null) {
                        this.c = new msStringBuilder();
                    }
                    for (int i2 = n2; i2 > string.length(); --i2) {
                        this.c.append('0');
                    }
                    this.c.append(string.length() <= n2 ? string : StringExtensions.substring(string, string.length() - n2, n2));
                    string = this.c.toString();
                    this.c.setLength(0);
                }
                b2.append(string);
            }
        }

        private static class RomanItem
        extends FormatItem {
            private boolean a;
            static String[] ucrDigits = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
            static String[] lcrDigits = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
            static int[] decValues = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};

            public RomanItem(String sep, boolean uc) {
                super(sep);
                this.a = uc;
            }

            @Override
            public void format(msStringBuilder b2, double num) {
                if (num < 1.0 || num > 4999.0) {
                    b2.append(num);
                    return;
                }
                num = XslNumber.round(num);
                for (int i2 = 0; i2 < decValues.length; ++i2) {
                    while ((double)decValues[i2] <= num) {
                        if (this.a) {
                            b2.append(ucrDigits[i2]);
                        } else {
                            b2.append(lcrDigits[i2]);
                        }
                        num -= (double)decValues[i2];
                    }
                    if (num == 0.0) break;
                }
            }
        }

        private static class AlphaItem
        extends FormatItem {
            private boolean a;
            static char[] ucl = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
            static char[] lcl = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

            public AlphaItem(String sep, boolean uc) {
                super(sep);
                this.a = uc;
            }

            @Override
            public void format(msStringBuilder b2, double num) {
                AlphaItem.alphaSeq(b2, num, this.a ? ucl : lcl);
            }

            static void alphaSeq(msStringBuilder b2, double n2, char[] alphabet) {
                if ((n2 = XslNumber.round(n2)) == 0.0) {
                    return;
                }
                if (n2 > (double)alphabet.length) {
                    AlphaItem.alphaSeq(b2, Math.floor((n2 - 1.0) / (double)alphabet.length), alphabet);
                }
                b2.append(alphabet[((int)n2 - 1) % alphabet.length]);
            }
        }

        static abstract class FormatItem {
            public String sep;

            public FormatItem(String sep) {
                this.sep = sep;
            }

            public abstract void format(msStringBuilder var1, double var2);

            public static FormatItem getItem(String sep, String item, char gpSep, int gpSize) {
                switch (item.charAt(0)) {
                    default: {
                        return new DigitItem(sep, 1, gpSep, gpSize);
                    }
                    case '0': 
                    case '1': {
                        int n2;
                        for (n2 = 1; n2 < item.length() && Char.isDigit(item, n2); ++n2) {
                        }
                        return new DigitItem(sep, n2, gpSep, gpSize);
                    }
                    case 'a': {
                        return new AlphaItem(sep, false);
                    }
                    case 'A': {
                        return new AlphaItem(sep, true);
                    }
                    case 'i': {
                        return new RomanItem(sep, false);
                    }
                    case 'I': 
                }
                return new RomanItem(sep, true);
            }
        }

        private static class NumberFormatterScanner {
            private int a = 0;
            private int b;
            private String c;

            public NumberFormatterScanner(String fmt) {
                this.c = fmt;
                this.b = fmt.length();
            }

            public String advance(boolean alphaNum) {
                int n2 = this.a;
                while (this.a < this.b && Char.isLetterOrDigit(this.c, this.a) == alphaNum) {
                    ++this.a;
                }
                if (this.a == n2) {
                    return null;
                }
                return StringExtensions.substring(this.c, n2, this.a - n2);
            }
        }
    }
}

