/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Xml.Emitter;
import com.aspose.html.internal.ms.System.Xml.XmlWriter;

class XmlWriterEmitter
extends Emitter {
    private XmlWriter a;

    public XmlWriterEmitter(XmlWriter writer) {
        this.a = writer;
    }

    @Override
    public void writeStartDocument(Encoding encoding, int standalone) {
        String string = "";
        switch (standalone) {
            case 1: {
                string = " standalone=\"yes\"";
                break;
            }
            case 2: {
                string = " standalone=\"no\"";
            }
        }
        if (encoding == null) {
            this.a.writeProcessingInstruction("xml", StringExtensions.concat("version=\"1.0\"", string));
        } else {
            this.a.writeProcessingInstruction("xml", StringExtensions.concat("version=\"1.0\" encoding=\"", encoding.getWebName(), "\"", string));
        }
    }

    @Override
    public void writeEndDocument() {
    }

    @Override
    public void writeDocType(String type, String publicId, String systemId) {
        if (systemId == null) {
            return;
        }
        this.a.writeDocType(type, publicId, systemId, null);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String nsURI) {
        this.a.writeStartElement(prefix, localName, nsURI);
    }

    @Override
    public void writeEndElement() {
        this.a.writeEndElement();
    }

    @Override
    public void writeFullEndElement() {
        this.a.writeFullEndElement();
    }

    @Override
    public void writeAttributeString(String prefix, String localName, String nsURI, String value) {
        this.a.writeAttributeString(prefix, localName, nsURI, value);
    }

    @Override
    public void writeComment(String text) {
        while (StringExtensions.indexOf(text, "--") >= 0) {
            text = StringExtensions.replace(text, "--", "- -");
        }
        if (StringExtensions.endsWith(text, "-")) {
            text = StringExtensions.plusEqOperator(text, ' ');
        }
        this.a.writeComment(text);
    }

    @Override
    public void writeProcessingInstruction(String name, String text) {
        while (StringExtensions.indexOf(text, "?>") >= 0) {
            text = StringExtensions.replace(text, "?>", "? >");
        }
        this.a.writeProcessingInstruction(name, text);
    }

    @Override
    public void writeString(String text) {
        this.a.writeString(text);
    }

    @Override
    public void writeRaw(String data) {
        this.a.writeRaw(data);
    }

    @Override
    public void writeCDataSection(String text) {
        int n2 = StringExtensions.indexOf(text, "]]>");
        if (n2 >= 0) {
            this.a.writeCData(StringExtensions.substring(text, 0, n2 + 2));
            this.writeCDataSection(StringExtensions.substring(text, n2 + 2));
        } else {
            this.a.writeCData(text);
        }
    }

    @Override
    public void writeWhitespace(String value) {
        this.a.writeWhitespace(value);
    }

    @Override
    public void done() {
        this.a.flush();
    }
}

