/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.IO.StringWriter;
import com.aspose.html.internal.ms.System.IO.TextWriter;
import com.aspose.html.internal.ms.System.InvalidCastException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.System.Xml.DefaultXmlWriter;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XQueryConvert;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlNodeType;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlReader;
import com.aspose.html.internal.ms.System.Xml.XmlWellFormedWriter;
import com.aspose.html.internal.ms.System.Xml.XmlWriterSettings;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.time.TimeSpan;
import java.lang.reflect.Array;

public abstract class XmlWriter
implements IDisposable {
    private XmlWriterSettings a;

    protected XmlWriter() {
    }

    public XmlWriterSettings getSettings() {
        return this.a;
    }

    public abstract int getWriteState();

    public String getXmlLang() {
        return null;
    }

    public int getXmlSpace() {
        return 0;
    }

    public abstract void close();

    public static XmlWriter create(Stream stream) {
        return XmlWriter.create(stream, null);
    }

    public static XmlWriter create(String file) {
        return XmlWriter.create(file, null);
    }

    public static XmlWriter create(TextWriter writer) {
        return XmlWriter.create(writer, null);
    }

    public static XmlWriter create(XmlWriter writer) {
        return XmlWriter.create(writer, null);
    }

    public static XmlWriter create(msStringBuilder builder) {
        return XmlWriter.create(builder, null);
    }

    public static XmlWriter create(Stream stream, XmlWriterSettings settings) {
        Encoding encoding = settings != null ? settings.getEncoding() : Encoding.getUTF8();
        return XmlWriter.create(new StreamWriter(stream, encoding), settings);
    }

    public static XmlWriter create(String file, XmlWriterSettings settings) {
        Encoding encoding = settings != null ? settings.getEncoding() : Encoding.getUTF8();
        return XmlWriter.a(new StreamWriter(file, false, encoding), settings, true);
    }

    public static XmlWriter create(msStringBuilder builder, XmlWriterSettings settings) {
        return XmlWriter.create(new StringWriter(builder), settings);
    }

    public static XmlWriter create(TextWriter writer, XmlWriterSettings settings) {
        if (settings == null) {
            settings = new XmlWriterSettings();
        }
        return XmlWriter.a(writer, settings, settings.getCloseOutput());
    }

    public static XmlWriter create(XmlWriter writer, XmlWriterSettings settings) {
        settings = settings == null ? new XmlWriterSettings() : settings.deepClone();
        XmlWriterSettings xmlWriterSettings = writer.getSettings();
        if (xmlWriterSettings == null) {
            settings.setConformanceLevel(2);
            writer = new DefaultXmlWriter(writer);
            writer.a = settings;
        } else {
            int n2 = xmlWriterSettings.getConformanceLevel();
            switch (xmlWriterSettings.getConformanceLevel()) {
                case 0: {
                    n2 = settings.getConformanceLevel();
                    break;
                }
                case 1: 
                case 2: {
                    if (settings.getConformanceLevel() == 0) break;
                    n2 = settings.getConformanceLevel();
                }
            }
            settings.mergeFrom(xmlWriterSettings);
            if (xmlWriterSettings.getConformanceLevel() != n2) {
                writer = new DefaultXmlWriter(writer, false);
                writer.a = settings;
            }
        }
        return writer;
    }

    private static XmlWriter a(TextWriter textWriter, XmlWriterSettings xmlWriterSettings, boolean bl2) {
        if (xmlWriterSettings == null) {
            xmlWriterSettings = new XmlWriterSettings();
        }
        XmlWellFormedWriter xmlWellFormedWriter = new XmlWellFormedWriter(textWriter, xmlWriterSettings, bl2);
        return XmlWriter.create(xmlWellFormedWriter, xmlWriterSettings);
    }

    protected void dispose(boolean disposing) {
        this.close();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public abstract void flush();

    public abstract String lookupPrefix(String var1);

    private void a(XmlReader xmlReader, boolean bl2) {
        if (!bl2 && xmlReader.isDefault()) {
            return;
        }
        this.writeStartAttribute(xmlReader.getPrefix(), xmlReader.getLocalName(), xmlReader.getNamespaceURI());
        while (xmlReader.readAttributeValue()) {
            switch (xmlReader.getNodeType()) {
                case 3: {
                    this.writeString(xmlReader.getValue());
                    break;
                }
                case 5: {
                    this.writeEntityRef(xmlReader.getName());
                }
            }
        }
        this.writeEndAttribute();
    }

    public void writeAttributes(XmlReader reader, boolean defattr) {
        if (reader == null) {
            throw new ArgumentException("null XmlReader specified.", "reader");
        }
        switch (reader.getNodeType()) {
            case 17: {
                this.writeAttributeString("version", reader.get_Item("version"));
                if (reader.get_Item("encoding") != null) {
                    this.writeAttributeString("encoding", reader.get_Item("encoding"));
                }
                if (reader.get_Item("standalone") == null) break;
                this.writeAttributeString("standalone", reader.get_Item("standalone"));
                break;
            }
            case 1: 
            case 2: {
                if (reader.getNodeType() == 1 && !reader.moveToFirstAttribute()) break;
                do {
                    this.a(reader, defattr);
                } while (reader.moveToNextAttribute());
                reader.moveToElement();
                break;
            }
            default: {
                throw new XmlException("NodeType is not one of Element, Attribute, nor XmlDeclaration.");
            }
        }
    }

    public void writeAttributeString(String localName, String value) {
        this.writeAttributeString("", localName, null, value);
    }

    public void writeAttributeString(String localName, String ns, String value) {
        this.writeAttributeString("", localName, ns, value);
    }

    public void writeAttributeString(String prefix, String localName, String ns, String value) {
        this.writeStartAttribute(prefix, localName, ns);
        if (value != null && value.length() > 0) {
            this.writeString(value);
        }
        this.writeEndAttribute();
    }

    public abstract void writeBase64(byte[] var1, int var2, int var3);

    public void writeBinHex(byte[] buffer, int index, int count) {
        StringWriter stringWriter = new StringWriter();
        XmlConvert.writeBinHex(buffer, index, count, stringWriter);
        this.writeString(stringWriter.toString());
    }

    public abstract void writeCData(String var1);

    public abstract void writeCharEntity(char var1);

    public abstract void writeChars(char[] var1, int var2, int var3);

    public abstract void writeComment(String var1);

    public abstract void writeDocType(String var1, String var2, String var3, String var4);

    public void writeElementString(String localName, String value) {
        this.writeStartElement(localName);
        if (value != null && value.length() > 0) {
            this.writeString(value);
        }
        this.writeEndElement();
    }

    public void writeElementString(String localName, String ns, String value) {
        this.writeStartElement(localName, ns);
        if (value != null && value.length() > 0) {
            this.writeString(value);
        }
        this.writeEndElement();
    }

    public void writeElementString(String prefix, String localName, String ns, String value) {
        this.writeStartElement(prefix, localName, ns);
        if (value != null && value.length() > 0) {
            this.writeString(value);
        }
        this.writeEndElement();
    }

    public abstract void writeEndAttribute();

    public abstract void writeEndDocument();

    public abstract void writeEndElement();

    public abstract void writeEntityRef(String var1);

    public abstract void writeFullEndElement();

    public void writeName(String name) {
        this.writeNameInternal(name);
    }

    public void writeNmToken(String name) {
        this.writeNmTokenInternal(name);
    }

    public void writeQualifiedName(String localName, String ns) {
        this.writeQualifiedNameInternal(localName, ns);
    }

    void writeNameInternal(String name) {
        switch (this.getSettings().getConformanceLevel()) {
            case 1: 
            case 2: {
                XmlConvert.verifyName(name);
            }
        }
        this.writeString(name);
    }

    void writeNmTokenInternal(String name) {
        boolean bl2 = true;
        switch (this.getSettings().getConformanceLevel()) {
            case 1: 
            case 2: {
                bl2 = XmlChar.isNmToken(name);
            }
        }
        if (!bl2) {
            throw new ArgumentException("Argument name is not a valid NMTOKEN.");
        }
        this.writeString(name);
    }

    void writeQualifiedNameInternal(String localName, String ns) {
        String string;
        if (localName == null || StringExtensions.equals(localName, StringExtensions.Empty)) {
            throw new ArgumentException();
        }
        if (ns == null) {
            ns = StringExtensions.Empty;
        }
        if (this.getSettings() != null) {
            switch (this.getSettings().getConformanceLevel()) {
                case 1: 
                case 2: {
                    XmlConvert.verifyNCName(localName);
                }
            }
        } else {
            XmlConvert.verifyNCName(localName);
        }
        String string2 = string = ns.length() > 0 ? this.lookupPrefix(ns) : StringExtensions.Empty;
        if (string == null) {
            throw new ArgumentException(StringExtensions.format("Namespace '{0}' is not declared.", ns));
        }
        if (!StringExtensions.equals(string, StringExtensions.Empty)) {
            this.writeString(string);
            this.writeString(":");
            this.writeString(localName);
        } else {
            this.writeString(localName);
        }
    }

    public void writeNode(XPathNavigator navigator, boolean defattr) {
        if (navigator == null) {
            throw new ArgumentNullException("navigator");
        }
        switch (navigator.getNodeType()) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.writeString(navigator.getValue());
                break;
            }
            case 5: {
                this.writeWhitespace(navigator.getValue());
                break;
            }
            case 6: {
                this.writeWhitespace(navigator.getValue());
                break;
            }
            case 8: {
                this.writeComment(navigator.getValue());
                break;
            }
            case 7: {
                this.writeProcessingInstruction(navigator.getName(), navigator.getValue());
                break;
            }
            case 0: {
                if (!navigator.moveToFirstChild()) break;
                do {
                    this.writeNode(navigator, defattr);
                } while (navigator.moveToNext());
                navigator.moveToParent();
                break;
            }
            case 1: {
                this.writeStartElement(navigator.getPrefix(), navigator.getLocalName(), navigator.getNamespaceURI());
                if (navigator.moveToFirstNamespace(2)) {
                    do {
                        if (!defattr && navigator.getSchemaInfo() != null && !navigator.getSchemaInfo().isDefault()) continue;
                        this.writeAttributeString(navigator.getPrefix(), StringExtensions.equals(navigator.getLocalName(), StringExtensions.Empty) ? "xmlns" : navigator.getLocalName(), "http://www.w3.org/2000/xmlns/", navigator.getValue());
                    } while (navigator.moveToNextNamespace(2));
                    navigator.moveToParent();
                }
                if (navigator.moveToFirstAttribute()) {
                    do {
                        if (!defattr && navigator.getSchemaInfo() != null && !navigator.getSchemaInfo().isDefault()) continue;
                        this.writeAttributeString(navigator.getPrefix(), navigator.getLocalName(), navigator.getNamespaceURI(), navigator.getValue());
                    } while (navigator.moveToNextAttribute());
                    navigator.moveToParent();
                }
                if (navigator.moveToFirstChild()) {
                    do {
                        this.writeNode(navigator, defattr);
                    } while (navigator.moveToNext());
                    navigator.moveToParent();
                }
                if (navigator.isEmptyElement()) {
                    this.writeEndElement();
                    break;
                }
                this.writeFullEndElement();
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
    }

    public void writeNode(XmlReader reader, boolean defattr) {
        if (reader == null) {
            throw new ArgumentException();
        }
        if (reader.getReadState() == 0) {
            reader.read();
            do {
                this.writeNode(reader, defattr);
            } while (!reader.getEOF());
            return;
        }
        switch (reader.getNodeType()) {
            case 1: {
                int n2;
                this.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                if (reader.hasAttributes()) {
                    for (n2 = 0; n2 < reader.getAttributeCount(); ++n2) {
                        reader.moveToAttribute(n2);
                        this.a(reader, defattr);
                    }
                    reader.moveToElement();
                }
                if (reader.isEmptyElement()) {
                    this.writeEndElement();
                    break;
                }
                n2 = reader.getDepth();
                reader.read();
                if (reader.getNodeType() != 15) {
                    do {
                        this.writeNode(reader, defattr);
                    } while (n2 < reader.getDepth());
                }
                this.writeFullEndElement();
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                this.writeString(reader.getValue());
                break;
            }
            case 4: {
                this.writeCData(reader.getValue());
                break;
            }
            case 5: {
                this.writeEntityRef(reader.getName());
                break;
            }
            case 7: 
            case 17: {
                this.writeProcessingInstruction(reader.getName(), reader.getValue());
                break;
            }
            case 8: {
                this.writeComment(reader.getValue());
                break;
            }
            case 10: {
                this.writeDocType(reader.getName(), reader.get_Item("PUBLIC"), reader.get_Item("SYSTEM"), reader.getValue());
                break;
            }
            case 13: 
            case 14: {
                this.writeWhitespace(reader.getValue());
                break;
            }
            case 15: {
                this.writeFullEndElement();
                break;
            }
            case 16: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new XmlException(StringExtensions.concat("Unexpected node ", reader.getName(), " of type ", Enum.getName(XmlNodeType.class, reader.getNodeType())));
            }
        }
        reader.read();
    }

    public abstract void writeProcessingInstruction(String var1, String var2);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(char[] var1, int var2, int var3);

    public void writeStartAttribute(String localName) {
        this.writeStartAttribute(null, localName, null);
    }

    public void writeStartAttribute(String localName, String ns) {
        this.writeStartAttribute(null, localName, ns);
    }

    public abstract void writeStartAttribute(String var1, String var2, String var3);

    public abstract void writeStartDocument();

    public abstract void writeStartDocument(boolean var1);

    public void writeStartElement(String localName) {
        this.writeStartElement(null, localName, null);
    }

    public void writeStartElement(String localName, String ns) {
        this.writeStartElement(null, localName, ns);
    }

    public abstract void writeStartElement(String var1, String var2, String var3);

    public abstract void writeString(String var1);

    public abstract void writeSurrogateCharEntity(char var1, char var2);

    public abstract void writeWhitespace(String var1);

    public void writeValue(boolean value) {
        this.writeString(XQueryConvert.booleanToString(value));
    }

    public void writeValue(DateTime value) {
        this.writeString(XmlConvert.toString_DateTime(value.Clone()));
    }

    public void writeValue(Decimal value) {
        this.writeString(XQueryConvert.decimalToString(value.Clone()));
    }

    public void writeValue(double value) {
        this.writeString(XQueryConvert.doubleToString(value));
    }

    public void writeValue(int value) {
        this.writeString(XQueryConvert.intToString(value));
    }

    public void writeValue(long value) {
        this.writeString(XQueryConvert.integerToString(value));
    }

    public void writeValue(Object value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (Operators.is(value, String.class)) {
            this.writeString((String)value);
        } else if (Operators.is(value, Boolean.class)) {
            this.writeValue(Operators.unboxing(value, Boolean.TYPE));
        } else if (Operators.is(value, Byte.class)) {
            this.writeValue(Operators.unboxing(value, Byte.TYPE).byteValue());
        } else if (Operators.is(value, byte[].class)) {
            this.writeBase64(Operators.cast(value, byte[].class), 0, Operators.cast(value, byte[].class).length);
        } else if (Operators.is(value, char[].class)) {
            this.writeChars(Operators.cast(value, char[].class), 0, Operators.cast(value, char[].class).length);
        } else if (Operators.is(value, DateTime.class)) {
            this.writeValue(Operators.unboxing(value, DateTime.class).Clone());
        } else if (Operators.is(value, Decimal.class)) {
            this.writeValue(Operators.unboxing(value, Decimal.class).Clone());
        } else if (Operators.is(value, Double.class)) {
            this.writeValue(Operators.unboxing(value, Double.TYPE));
        } else if (Operators.is(value, Short.class)) {
            this.writeValue(Operators.unboxing(value, Short.TYPE).shortValue());
        } else if (Operators.is(value, Integer.class)) {
            this.writeValue(Operators.unboxing(value, Integer.TYPE));
        } else if (Operators.is(value, Long.class)) {
            this.writeValue(Operators.unboxing(value, Long.TYPE));
        } else if (Operators.is(value, Float.class)) {
            this.writeValue(Operators.unboxing(value, Float.TYPE).floatValue());
        } else if (Operators.is(value, TimeSpan.class)) {
            this.writeString(XmlConvert.toString_TimeSpan(Operators.unboxing(value, TimeSpan.class).Clone()));
        } else if (Operators.is(value, Uri.class)) {
            this.writeString(((Uri)value).toString());
        } else if (Operators.is(value, XmlQualifiedName.class)) {
            XmlQualifiedName xmlQualifiedName = (XmlQualifiedName)value;
            if (!xmlQualifiedName.equals(XmlQualifiedName.Empty)) {
                if (xmlQualifiedName.getNamespace().length() > 0 && this.lookupPrefix(xmlQualifiedName.getNamespace()) == null) {
                    throw new InvalidCastException(StringExtensions.format("The QName '{0}' cannot be written. No corresponding prefix is declared", xmlQualifiedName));
                }
                this.writeQualifiedName(xmlQualifiedName.getName(), xmlQualifiedName.getNamespace());
            } else {
                this.writeString(StringExtensions.Empty);
            }
        } else if (value instanceof XmlQualifiedName[]) {
            XmlQualifiedName[] xmlQualifiedNameArray;
            for (XmlQualifiedName xmlQualifiedName : xmlQualifiedNameArray = (XmlQualifiedName[])value) {
                if (!xmlQualifiedName.equals(XmlQualifiedName.Empty)) {
                    if (xmlQualifiedName.getNamespace().length() > 0 && this.lookupPrefix(xmlQualifiedName.getNamespace()) == null) {
                        throw new InvalidCastException(StringExtensions.format("The QName '{0}' cannot be written. No corresponding prefix is declared", xmlQualifiedName));
                    }
                    this.writeQualifiedName(xmlQualifiedName.getName(), xmlQualifiedName.getNamespace());
                    continue;
                }
                this.writeString(StringExtensions.Empty);
            }
        } else if (value instanceof IEnumerable) {
            boolean bl2 = false;
            for (Object e2 : (IEnumerable)value) {
                if (bl2) {
                    this.writeString(" ");
                } else {
                    bl2 = true;
                }
                this.writeValue(e2);
            }
        } else if (value.getClass().isArray()) {
            int n2;
            int n3 = msArray.getUpperBound(value, 0);
            Object[] objectArray = new Object[n3 + 1];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Array.set(objectArray, n2, Array.get(value, n2));
            }
            n2 = 0;
            for (Object object : objectArray) {
                if (n2 != 0) {
                    this.writeString(" ");
                } else {
                    n2 = 1;
                }
                this.writeValue(object);
            }
        } else {
            throw new InvalidCastException(StringExtensions.format("Type '{0}' cannot be cast to string", ObjectExtensions.getType(value)));
        }
    }

    public void writeValue(float value) {
        this.writeString(XQueryConvert.floatToString(value));
    }

    public void writeValue(String value) {
        this.writeString(value);
    }
}

