/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlReader;

class XmlReaderBinarySupport {
    private XmlReader a;
    private CharGetter b;
    private byte[] c = new byte[3];
    private int d;
    private int e;
    private msStringBuilder f;
    private boolean g;
    private boolean h;

    public XmlReaderBinarySupport(XmlReader reader) {
        this.a = reader;
        this.reset();
    }

    public CharGetter getGetter() {
        return this.b;
    }

    public void setGetter(CharGetter value) {
        this.b = value;
    }

    public void reset() {
        if (!this.h) {
            this.h = true;
            if (this.g) {
                switch (this.a.getNodeType()) {
                    case 3: 
                    case 4: 
                    case 13: 
                    case 14: {
                        this.a.read();
                    }
                }
                switch (this.e) {
                    case 1: 
                    case 3: {
                        this.a.read();
                    }
                }
            }
            this.d = -1;
            this.e = 0;
            this.g = false;
            this.h = false;
        }
    }

    private InvalidOperationException a(int n2) {
        return new InvalidOperationException(StringExtensions.format("Invalid attempt to read binary content by {0}, while once binary reading was started by {1}", n2, this.e));
    }

    private void a(boolean bl2, int n2) {
        if (this.e == 0) {
            if (this.f == null) {
                this.f = new msStringBuilder();
            } else {
                this.f.setLength(0);
            }
            if (n2 == 0) {
                return;
            }
            if (this.a.getReadState() != 1) {
                return;
            }
            switch (this.a.getNodeType()) {
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    if (bl2) break;
                    this.e = n2;
                    return;
                }
                case 1: {
                    if (!bl2) break;
                    if (!this.a.isEmptyElement()) {
                        this.a.read();
                    }
                    this.e = n2;
                    return;
                }
            }
            throw new XmlException(bl2 ? "Reader is not positioned on an element." : "Reader is not positioned on a text node.");
        }
        if (this.e == n2) {
            return;
        }
        throw this.a(n2);
    }

    public int readElementContentAsBase64(byte[] buffer, int offset, int length) {
        this.a(true, 1);
        return this.readBase64(buffer, offset, length);
    }

    public int readContentAsBase64(byte[] buffer, int offset, int length) {
        this.a(false, 2);
        return this.readBase64(buffer, offset, length);
    }

    public int readElementContentAsBinHex(byte[] buffer, int offset, int length) {
        this.a(true, 3);
        return this.readBinHex(buffer, offset, length);
    }

    public int readContentAsBinHex(byte[] buffer, int offset, int length) {
        this.a(false, 4);
        return this.readBinHex(buffer, offset, length);
    }

    public int readBase64(byte[] buffer, int offset, int length) {
        int n2;
        int n3;
        if (offset < 0) {
            throw XmlReaderBinarySupport.createArgumentOutOfRangeException("offset", offset, "Offset must be non-negative integer.");
        }
        if (length < 0) {
            throw XmlReaderBinarySupport.createArgumentOutOfRangeException("length", length, "Length must be non-negative integer.");
        }
        if (buffer.length < offset + length) {
            throw new ArgumentOutOfRangeException("buffer length is smaller than the sum of offset and length.");
        }
        if (this.a.isEmptyElement()) {
            return 0;
        }
        if (length == 0) {
            return 0;
        }
        int n4 = offset;
        int n5 = offset + length;
        if (this.d >= 0) {
            for (n3 = this.d; n3 < 3; ++n3) {
                buffer[n4++] = this.c[this.d++];
                if (n4 != n5) continue;
                return n5 - offset;
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            this.c[n3] = 0;
        }
        this.d = -1;
        n3 = (int)Math.ceil(1.3333333333333333 * (double)length);
        int n6 = n3 % 4;
        if (n6 > 0) {
            n3 += 4 - n6;
        }
        char[] cArray = new char[n3];
        int n7 = this.b != null ? this.b.invoke(cArray, 0, n3) : this.readValueChunk(cArray, 0, n3);
        byte by2 = 0;
        byte by3 = 0;
        for (n2 = 0; n2 < n7 - 3 && (n2 = this.a(cArray, n7, n2)) != n7; ++n2) {
            by2 = (byte)((this.a(cArray[n2]) & 0xFF) << 2);
            if (n4 < n5) {
                buffer[n4] = by2;
            } else if (by2 != 0) {
                if (this.d < 0) {
                    this.d = 0;
                }
                this.c[0] = by2;
            }
            if (++n2 == n7 || (n2 = this.a(cArray, n7, n2)) == n7) break;
            by2 = this.a(cArray[n2]);
            by3 = (byte)((by2 & 0xFF) >> 4);
            if (n4 < n5) {
                buffer[n4] = (byte)((buffer[n4] & 0xFF) + (by3 & 0xFF));
                ++n4;
            } else if (by3 != 0) {
                if (this.d < 0) {
                    this.d = 0;
                }
                this.c[0] = (byte)((this.c[0] & 0xFF) + (by3 & 0xFF));
            }
            by3 = (byte)((by2 & 0xFF & 0xF) << 4);
            if (n4 < n5) {
                buffer[n4] = by3;
            } else if (by3 != 0) {
                if (this.d < 0) {
                    this.d = 1;
                }
                this.c[1] = by3;
            }
            if (++n2 == n7 || (n2 = this.a(cArray, n7, n2)) == n7) break;
            by2 = this.a(cArray[n2]);
            by3 = (byte)((by2 & 0xFF) >> 2);
            if (n4 < n5) {
                buffer[n4] = (byte)((buffer[n4] & 0xFF) + (by3 & 0xFF));
                ++n4;
            } else if (by3 != 0) {
                if (this.d < 0) {
                    this.d = 1;
                }
                this.c[1] = (byte)((this.c[1] & 0xFF) + (by3 & 0xFF));
            }
            by3 = (byte)((by2 & 0xFF & 3) << 6);
            if (n4 < n5) {
                buffer[n4] = by3;
            } else if (by3 != 0) {
                if (this.d < 0) {
                    this.d = 2;
                }
                this.c[2] = by3;
            }
            if (++n2 == n7 || (n2 = this.a(cArray, n7, n2)) == n7) break;
            by3 = this.a(cArray[n2]);
            if (n4 < n5) {
                buffer[n4] = (byte)((buffer[n4] & 0xFF) + (by3 & 0xFF));
                ++n4;
                continue;
            }
            if (by3 == 0) continue;
            if (this.d < 0) {
                this.d = 2;
            }
            this.c[2] = (byte)((this.c[2] & 0xFF) + (by3 & 0xFF));
        }
        if ((n2 = Math.min(n5 - offset, n4 - offset)) < length && n7 > 0) {
            return n2 + this.readBase64(buffer, offset + n2, length - n2);
        }
        return n2;
    }

    private byte a(char c2) {
        switch (c2) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return (byte)(c2 - 65);
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return (byte)(c2 - 97 + 26);
        }
        if (c2 >= '0' && c2 <= '9') {
            return (byte)(c2 - 48 + 52);
        }
        throw new XmlException("Invalid Base64 character was found.");
    }

    private int a(char[] cArray, int n2, int n3) {
        while ((cArray[n3] == '=' || XmlChar.isWhitespace(cArray[n3])) && n2 != ++n3) {
        }
        return n3;
    }

    static Exception createArgumentOutOfRangeException(String name, Object value, String message) {
        return new ArgumentOutOfRangeException(name, value, message);
    }

    public int readBinHex(byte[] buffer, int offset, int length) {
        if (offset < 0) {
            throw XmlReaderBinarySupport.createArgumentOutOfRangeException("offset", offset, "Offset must be non-negative integer.");
        }
        if (length < 0) {
            throw XmlReaderBinarySupport.createArgumentOutOfRangeException("length", length, "Length must be non-negative integer.");
        }
        if (buffer.length < offset + length) {
            throw new ArgumentOutOfRangeException("buffer length is smaller than the sum of offset and length.");
        }
        if (length == 0) {
            return 0;
        }
        char[] cArray = new char[length * 2];
        int n2 = this.b != null ? this.b.invoke(cArray, 0, length * 2) : this.readValueChunk(cArray, 0, length * 2);
        return XmlConvert.fromBinHexString(cArray, offset, n2, buffer);
    }

    public int readValueChunk(char[] buffer, int offset, int length) {
        int n2 = this.e;
        if (this.e == 0) {
            this.a(false, 0);
        }
        if (offset < 0) {
            throw XmlReaderBinarySupport.createArgumentOutOfRangeException("offset", offset, "Offset must be non-negative integer.");
        }
        if (length < 0) {
            throw XmlReaderBinarySupport.createArgumentOutOfRangeException("length", length, "Length must be non-negative integer.");
        }
        if (buffer.length < offset + length) {
            throw new ArgumentOutOfRangeException("buffer length is smaller than the sum of offset and length.");
        }
        if (length == 0) {
            return 0;
        }
        if (!this.g && this.a.isEmptyElement()) {
            return 0;
        }
        boolean bl2 = true;
        block6: while (bl2 && this.f.getLength() < length) {
            switch (this.a.getNodeType()) {
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    if (this.g) {
                        switch (this.a.getNodeType()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 13: 
                            case 14: {
                                this.a();
                                break;
                            }
                            default: {
                                bl2 = false;
                            }
                        }
                    }
                    this.f.append(this.a.getValue());
                    this.g = true;
                    continue block6;
                }
            }
            bl2 = false;
        }
        this.e = n2;
        int n3 = this.f.getLength();
        if (n3 > length) {
            n3 = length;
        }
        String string = this.f.toString(0, n3);
        this.f.remove(0, string.length());
        StringExtensions.copyTo(string, 0, buffer, offset, string.length());
        if (n3 < length && bl2) {
            return n3 + this.readValueChunk(buffer, offset + n3, length - n3);
        }
        return n3;
    }

    private boolean a() {
        this.h = true;
        boolean bl2 = this.a.read();
        this.h = false;
        return bl2;
    }

    public static final class CommandState
    extends Enum {
        public static final int None = 0;
        public static final int ReadElementContentAsBase64 = 1;
        public static final int ReadContentAsBase64 = 2;
        public static final int ReadElementContentAsBinHex = 3;
        public static final int ReadContentAsBinHex = 4;

        private CommandState() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)CommandState.class, Integer.class){
                {
                    this.addConstant("None", 0L);
                    this.addConstant("ReadElementContentAsBase64", 1L);
                    this.addConstant("ReadContentAsBase64", 2L);
                    this.addConstant("ReadElementContentAsBinHex", 3L);
                    this.addConstant("ReadContentAsBinHex", 4L);
                }
            });
        }
    }

    public static interface CharGetter {
        public int invoke(char[] var1, int var2, int var3);
    }
}

