/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.IXmlNamespaceResolver;
import com.aspose.html.internal.ms.System.Xml.XmlReader;

@SerializableAttribute
public class XmlQualifiedName {
    public static XmlQualifiedName Empty = new XmlQualifiedName();
    private String a;
    private String b;
    private int c;

    public XmlQualifiedName() {
        this(StringExtensions.Empty, StringExtensions.Empty);
    }

    public XmlQualifiedName(String name) {
        this(name, StringExtensions.Empty);
    }

    public XmlQualifiedName(String name, String ns) {
        this.a = name == null ? StringExtensions.Empty : name;
        this.b = ns == null ? StringExtensions.Empty : ns;
        this.c = this.a.hashCode() ^ this.b.hashCode();
    }

    public boolean isEmpty() {
        return this.a.length() == 0 && this.b.length() == 0;
    }

    public String getName() {
        return this.a;
    }

    public String getNamespace() {
        return this.b;
    }

    public boolean equals(Object other) {
        return XmlQualifiedName.op_Equality(this, other instanceof XmlQualifiedName ? (XmlQualifiedName)other : null);
    }

    public int hashCode() {
        return this.c;
    }

    public String toString() {
        if (StringExtensions.equals(this.b, StringExtensions.Empty)) {
            return this.a;
        }
        return StringExtensions.concat(this.b, ":", this.a);
    }

    public static String toString(String name, String ns) {
        if (StringExtensions.equals(ns, StringExtensions.Empty)) {
            return name;
        }
        return StringExtensions.concat(ns, ":", name);
    }

    static XmlQualifiedName parse(String name, IXmlNamespaceResolver resolver) {
        return XmlQualifiedName.parse(name, resolver, false);
    }

    static XmlQualifiedName parse(String name, IXmlNamespaceResolver resolver, boolean considerDefaultNamespace) {
        int n2 = StringExtensions.indexOf(name, ':');
        if (n2 < 0 && !considerDefaultNamespace) {
            return new XmlQualifiedName(name);
        }
        String string = n2 < 0 ? StringExtensions.Empty : StringExtensions.substring(name, 0, n2);
        String string2 = n2 < 0 ? name : StringExtensions.substring(name, n2 + 1);
        String string3 = resolver.lookupNamespace(string);
        if (string3 == null) {
            if (string.length() > 0) {
                throw new ArgumentException("Invalid qualified name.");
            }
            string3 = StringExtensions.Empty;
        }
        return new XmlQualifiedName(string2, string3);
    }

    static XmlQualifiedName parse(String name, XmlReader reader) {
        return XmlQualifiedName.parse(name, reader, false);
    }

    static XmlQualifiedName parse(String name, XmlReader reader, boolean considerDefaultNamespace) {
        int n2 = StringExtensions.indexOf(name, ':');
        if (n2 < 0 && !considerDefaultNamespace) {
            return new XmlQualifiedName(name);
        }
        String string = reader.lookupNamespace(n2 < 0 ? StringExtensions.Empty : StringExtensions.substring(name, 0, n2));
        if (string == null && n2 > 0) {
            throw new ArgumentException("Invalid qualified name.");
        }
        return new XmlQualifiedName(n2 < 0 ? name : StringExtensions.substring(name, n2 + 1), string);
    }

    public static boolean op_Equality(XmlQualifiedName a2, XmlQualifiedName b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return a2.c == b2.c && a2.a.equals(b2.a) && a2.b.equals(b2.b);
    }

    public static boolean op_Inequality(XmlQualifiedName a2, XmlQualifiedName b2) {
        return !XmlQualifiedName.op_Equality(a2, b2);
    }
}

