/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlLinkedNode;

public abstract class XmlCharacterData
extends XmlLinkedNode {
    private String a;

    protected XmlCharacterData(String data, XmlDocument doc) {
        super(doc);
        if (data == null) {
            data = StringExtensions.Empty;
        }
        this.a = data;
    }

    public String getData() {
        return this.a;
    }

    public void setData(String value) {
        String string = this.a;
        this.getOwnerDocument().onNodeChanging(this, this.getParentNode(), string, value);
        this.a = value;
        this.getOwnerDocument().onNodeChanged(this, this.getParentNode(), string, value);
    }

    @Override
    public String getInnerText() {
        return this.a;
    }

    @Override
    public void setInnerText(String value) {
        this.setData(value);
    }

    public int getLength() {
        return this.a != null ? this.a.length() : 0;
    }

    @Override
    public String getValue() {
        return this.a;
    }

    @Override
    public void setValue(String value) {
        this.setData(value);
    }

    @Override
    int getXPathNodeType() {
        return 4;
    }

    public void appendData(String strData) {
        String string = this.a;
        String string2 = this.a = StringExtensions.plusEqOperator(this.a, strData);
        this.getOwnerDocument().onNodeChanging(this, this.getParentNode(), string, string2);
        this.a = string2;
        this.getOwnerDocument().onNodeChanged(this, this.getParentNode(), string, string2);
    }

    public void deleteData(int offset, int count) {
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Must be non-negative and must not be greater than the length of this instance.");
        }
        int n2 = this.a.length() - offset;
        if (offset + count < this.a.length()) {
            n2 = count;
        }
        String string = this.a;
        String string2 = StringExtensions.remove(this.a, offset, n2);
        this.getOwnerDocument().onNodeChanging(this, this.getParentNode(), string, string2);
        this.a = string2;
        this.getOwnerDocument().onNodeChanged(this, this.getParentNode(), string, string2);
    }

    public void insertData(int offset, String strData) {
        if (offset < 0 || offset > this.a.length()) {
            throw new ArgumentOutOfRangeException("offset", "Must be non-negative and must not be greater than the length of this instance.");
        }
        String string = this.a;
        String string2 = StringExtensions.insert(this.a, offset, strData);
        this.getOwnerDocument().onNodeChanging(this, this.getParentNode(), string, string2);
        this.a = string2;
        this.getOwnerDocument().onNodeChanged(this, this.getParentNode(), string, string2);
    }

    public void replaceData(int offset, int count, String strData) {
        if (offset < 0 || offset > this.a.length()) {
            throw new ArgumentOutOfRangeException("offset", "Must be non-negative and must not be greater than the length of this instance.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Must be non-negative.");
        }
        if (strData == null) {
            throw new ArgumentNullException("strData", "Must be non-null.");
        }
        String string = this.a;
        String string2 = StringExtensions.concat(StringExtensions.substring(this.a, 0, offset), strData);
        if (offset + count < this.a.length()) {
            string2 = StringExtensions.plusEqOperator(string2, StringExtensions.substring(this.a, offset + count));
        }
        this.getOwnerDocument().onNodeChanging(this, this.getParentNode(), string, string2);
        this.a = string2;
        this.getOwnerDocument().onNodeChanged(this, this.getParentNode(), string, string2);
    }

    public String substring(int offset, int count) {
        if (this.a.length() < offset + count) {
            return StringExtensions.substring(this.a, offset);
        }
        return StringExtensions.substring(this.a, offset, count);
    }
}

