/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.DTDAttListDeclaration;
import com.aspose.html.internal.ms.System.Xml.DTDAttributeDefinition;
import com.aspose.html.internal.ms.System.Xml.IHasXmlChildNode;
import com.aspose.html.internal.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlCharacterData;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlElement;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlLinkedNode;
import com.aspose.html.internal.ms.System.Xml.XmlNameEntry;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlNode;
import com.aspose.html.internal.ms.System.Xml.XmlParserContext;
import com.aspose.html.internal.ms.System.Xml.XmlTextReader;
import com.aspose.html.internal.ms.System.Xml.XmlWriter;

public class XmlAttribute
extends XmlNode
implements IHasXmlChildNode {
    private XmlNameEntry a;
    boolean isDefault;
    private XmlLinkedNode b;
    private IXmlSchemaInfo c;

    protected XmlAttribute(String prefix, String localName, String namespaceURI, XmlDocument doc) {
        this(prefix, localName, namespaceURI, doc, false, true);
    }

    XmlAttribute(String prefix, String localName, String namespaceURI, XmlDocument doc, boolean atomizedNames, boolean checkNamespace) {
        super(doc);
        if (!atomizedNames) {
            if (prefix == null) {
                prefix = StringExtensions.Empty;
            }
            if (namespaceURI == null) {
                namespaceURI = StringExtensions.Empty;
            }
        }
        if (checkNamespace && ("xmlns".equals(prefix) || "".equals(prefix) && "xmlns".equals(localName))) {
            if (!"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                throw new ArgumentException("Invalid attribute namespace for namespace declaration.");
            }
            if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                throw new ArgumentException("Invalid attribute namespace for namespace declaration.");
            }
        }
        if (!atomizedNames) {
            if (!"".equals(prefix) && !XmlChar.isName(prefix)) {
                throw new ArgumentException("Invalid attribute prefix.");
            }
            if (!XmlChar.isName(localName)) {
                throw new ArgumentException("Invalid attribute local name.");
            }
            prefix = doc.getNameTable().add(prefix);
            localName = doc.getNameTable().add(localName);
            namespaceURI = doc.getNameTable().add(namespaceURI);
        }
        this.a = doc.getNameCache().add(prefix, localName, namespaceURI, true);
    }

    @Override
    public XmlLinkedNode getLastLinkedChild() {
        return this.b;
    }

    @Override
    public void setLastLinkedChild(XmlLinkedNode value) {
        this.b = value;
    }

    @Override
    public String getBaseURI() {
        return this.getOwnerElement() != null ? this.getOwnerElement().getBaseURI() : StringExtensions.Empty;
    }

    @Override
    public void setInnerText(String value) {
        this.setValue(value);
    }

    @Override
    public void setInnerXml(String value) {
        this.removeAll();
        XmlNamespaceManager xmlNamespaceManager = this.constructNamespaceManager();
        XmlParserContext xmlParserContext = new XmlParserContext(this.getOwnerDocument().getNameTable(), xmlNamespaceManager, this.getOwnerDocument().getDocumentType() != null ? this.getOwnerDocument().getDocumentType().getDTD() : null, this.getBaseURI(), this.getXmlLang(), this.getXmlSpace(), null);
        XmlTextReader xmlTextReader = new XmlTextReader(value, 2, xmlParserContext);
        xmlTextReader.setXmlResolver(this.getOwnerDocument().getResolver());
        xmlTextReader.read();
        this.getOwnerDocument().readAttributeNodeValue(xmlTextReader, this);
    }

    @Override
    public String getLocalName() {
        return this.a.LocalName;
    }

    @Override
    public String getName() {
        return this.a.getPrefixedName(this.getOwnerDocument().getNameCache());
    }

    @Override
    public String getNamespaceURI() {
        return this.a.NS;
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    int getXPathNodeType() {
        return 2;
    }

    @Override
    public XmlDocument getOwnerDocument() {
        return super.getOwnerDocument();
    }

    public XmlElement getOwnerElement() {
        return this.getAttributeOwnerElement();
    }

    @Override
    public XmlNode getParentNode() {
        return null;
    }

    @Override
    public String getPrefix() {
        return this.a.Prefix;
    }

    @Override
    public void setPrefix(String value) {
        if (this.isReadOnly()) {
            throw new XmlException("This node is readonly.");
        }
        if ("xmlns".equals(this.a.Prefix) && !"xmlns".equals(value)) {
            throw new ArgumentException("Cannot bind to the reserved namespace.");
        }
        value = this.getOwnerDocument().getNameTable().add(value);
        this.a = this.getOwnerDocument().getNameCache().add(value, this.a.LocalName, this.a.NS, true);
    }

    @Override
    public IXmlSchemaInfo getSchemaInfo() {
        return this.c;
    }

    @Override
    void setSchemaInfo(IXmlSchemaInfo value) {
        this.c = value;
    }

    public boolean getSpecified() {
        return !this.isDefault;
    }

    @Override
    public String getValue() {
        return this.getInnerText();
    }

    @Override
    public void setValue(String value) {
        XmlNode xmlNode;
        if (this.isReadOnly()) {
            throw new ArgumentException("Attempt to modify a read-only node.");
        }
        this.getOwnerDocument().checkIdTableUpdate(this, this.getInnerText(), value);
        XmlNode xmlNode2 = this.getFirstChild();
        XmlNode xmlNode3 = xmlNode = xmlNode2 instanceof XmlCharacterData ? xmlNode2 : null;
        if (xmlNode == null) {
            this.removeAll();
            this.appendChild(this.getOwnerDocument().createTextNode(value), false);
        } else if (this.getFirstChild().getNextSibling() != null) {
            this.removeAll();
            this.appendChild(this.getOwnerDocument().createTextNode(value), false);
        } else {
            xmlNode.setValue(value);
        }
        this.isDefault = false;
    }

    @Override
    String getXmlLang() {
        return this.getOwnerElement() != null ? this.getOwnerElement().getXmlLang() : StringExtensions.Empty;
    }

    @Override
    int getXmlSpace() {
        return this.getOwnerElement() != null ? this.getOwnerElement().getXmlSpace() : 0;
    }

    @Override
    public XmlNode appendChild(XmlNode child) {
        return super.appendChild(child);
    }

    @Override
    public XmlNode insertBefore(XmlNode newChild, XmlNode refChild) {
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public XmlNode insertAfter(XmlNode newChild, XmlNode refChild) {
        return super.insertAfter(newChild, refChild);
    }

    @Override
    public XmlNode prependChild(XmlNode node) {
        return super.prependChild(node);
    }

    @Override
    public XmlNode removeChild(XmlNode node) {
        return super.removeChild(node);
    }

    @Override
    public XmlNode replaceChild(XmlNode newChild, XmlNode oldChild) {
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public XmlNode cloneNode(boolean deep) {
        XmlAttribute xmlAttribute = this.getOwnerDocument().createAttribute(this.a.Prefix, this.a.LocalName, this.a.NS, true, false);
        if (deep) {
            for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
                xmlAttribute.appendChild(xmlNode.cloneNode(deep), false);
            }
        }
        return xmlAttribute;
    }

    void setDefault() {
        this.isDefault = true;
    }

    @Override
    public void writeContentTo(XmlWriter w2) {
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            xmlNode.writeTo(w2);
        }
    }

    @Override
    public void writeTo(XmlWriter w2) {
        if (this.isDefault) {
            return;
        }
        w2.writeStartAttribute(this.a.Prefix, this.a.LocalName, this.a.NS);
        this.writeContentTo(w2);
        w2.writeEndAttribute();
    }

    DTDAttributeDefinition getAttributeDefinition() {
        if (this.getOwnerElement() == null) {
            return null;
        }
        DTDAttListDeclaration dTDAttListDeclaration = this.getOwnerDocument().getDocumentType() != null ? this.getOwnerDocument().getDocumentType().getDTD().getAttListDecls().get_Item(this.getOwnerElement().getName()) : null;
        return dTDAttListDeclaration != null ? dTDAttListDeclaration.get_Item(this.getName()) : null;
    }
}

