/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.CompiledExpression;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathParser;
import java.util.Comparator;

class XPathSorter {
    Expression _expr;
    Comparator _cmp;
    int _type;

    public XPathSorter(Object expr, Comparator cmp) {
        this._expr = XPathSorter.expressionFromObject(expr);
        this._cmp = cmp;
        this._type = 1;
    }

    public XPathSorter(Object expr, int orderSort, int orderCase, String lang, int dataType) {
        this._expr = XPathSorter.expressionFromObject(expr);
        this._type = dataType;
        this._cmp = dataType == 2 ? new XPathNumberComparer(orderSort) : new XPathTextComparer(orderSort, orderCase, lang);
    }

    static Expression expressionFromObject(Object expr) {
        if (expr instanceof CompiledExpression) {
            return ((CompiledExpression)expr).getExpressionNode();
        }
        if (expr instanceof String) {
            return new XPathParser().compile((String)expr);
        }
        throw new XPathException("Invalid query object");
    }

    public Object evaluate(BaseIterator iter) {
        if (this._type == 2) {
            return this._expr.evaluateNumber(iter);
        }
        return this._expr.evaluateString(iter);
    }

    public int compare(Object o1, Object o2) {
        return this._cmp.compare(o1, o2);
    }

    private static class XPathTextComparer
    implements Comparator {
        private int a;
        private int b;
        private int c;
        private CultureInfo d;

        public XPathTextComparer(int orderSort, int orderCase, String strLang) {
            this.c = orderCase;
            this.b = orderCase == 1 ? -1 : 1;
            this.a = orderSort == 1 ? 1 : -1;
            this.d = strLang == null || "".equals(strLang) ? CultureInfo.getCurrentCulture() : new CultureInfo(strLang);
        }

        public int compare(Object o1, Object o2) {
            String string = (String)o1;
            String string2 = (String)o2;
            int n2 = StringExtensions.compare(string, string2, true, this.d);
            if (n2 != 0 || this.c == 0) {
                return n2 * this.a;
            }
            return this.a * this.b * StringExtensions.compare(string, string2, false, this.d);
        }
    }

    private static class XPathNumberComparer
    implements Comparator {
        private int a;

        public XPathNumberComparer(int orderSort) {
            this.a = orderSort == 1 ? 1 : -1;
        }

        public int compare(Object o1, Object o2) {
            double d2;
            double d3 = (Double)o1;
            if (d3 < (d2 = ((Double)o2).doubleValue())) {
                return -this.a;
            }
            if (d3 > d2) {
                return this.a;
            }
            if (d3 == d2) {
                return 0;
            }
            if (Double.isNaN(d3)) {
                return Double.isNaN(d2) ? 0 : -this.a;
            }
            return this.a;
        }
    }
}

