/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericDictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IEqualityComparer;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IO.StringReader;
import com.aspose.html.internal.ms.System.IO.StringWriter;
import com.aspose.html.internal.ms.System.IO.TextReader;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.CompiledExpression;
import com.aspose.html.internal.ms.System.Xml.ExprFilter;
import com.aspose.html.internal.ms.System.Xml.ExprRoot;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.IStaticXsltContext;
import com.aspose.html.internal.ms.System.Xml.IXPathNavigable;
import com.aspose.html.internal.ms.System.Xml.IXmlNamespaceResolver;
import com.aspose.html.internal.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.internal.ms.System.Xml.NodeNameTest;
import com.aspose.html.internal.ms.System.Xml.NodeTest;
import com.aspose.html.internal.ms.System.Xml.NodeTypeTest;
import com.aspose.html.internal.ms.System.Xml.NullIterator;
import com.aspose.html.internal.ms.System.Xml.TodoAttribute;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.WrapperIterator;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathExpression;
import com.aspose.html.internal.ms.System.Xml.XPathItem;
import com.aspose.html.internal.ms.System.Xml.XPathNavigatorComparer;
import com.aspose.html.internal.ms.System.Xml.XPathNavigatorReader;
import com.aspose.html.internal.ms.System.Xml.XPathNodeIterator;
import com.aspose.html.internal.ms.System.Xml.XQueryConvert;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlNameTable;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlParserContext;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlReader;
import com.aspose.html.internal.ms.System.Xml.XmlReaderSettings;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaDatatype;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSet;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaValidationException;
import com.aspose.html.internal.ms.System.Xml.XmlWriter;
import com.aspose.html.internal.ms.System.Xml.XmlWriterSettings;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class XPathNavigator
extends XPathItem
implements ICloneable,
IXPathNavigable,
IXmlNamespaceResolver {
    static char[] escape_text_chars = new char[]{'&', '<', '>'};
    static char[] escape_attr_chars = new char[]{'\"', '&', '<', '>', '\r', '\n'};

    public static IEqualityComparer getNavigatorComparer() {
        return XPathNavigatorComparer.Instance;
    }

    protected XPathNavigator() {
    }

    public abstract String getBaseURI();

    public boolean canEdit() {
        return false;
    }

    public boolean hasAttributes() {
        if (!this.moveToFirstAttribute()) {
            return false;
        }
        this.moveToParent();
        return true;
    }

    public boolean hasChildren() {
        if (!this.moveToFirstChild()) {
            return false;
        }
        this.moveToParent();
        return true;
    }

    public abstract boolean isEmptyElement();

    public abstract String getLocalName();

    public abstract String getName();

    public abstract String getNamespaceURI();

    public abstract XmlNameTable getNameTable();

    public abstract int getNodeType();

    public abstract String getPrefix();

    public String getXmlLang() {
        XPathNavigator xPathNavigator = this.deepClone();
        switch (xPathNavigator.getNodeType()) {
            case 2: 
            case 3: {
                xPathNavigator.moveToParent();
            }
        }
        do {
            if (!xPathNavigator.moveToAttribute("lang", "http://www.w3.org/XML/1998/namespace")) continue;
            return xPathNavigator.getValue();
        } while (xPathNavigator.moveToParent());
        return StringExtensions.Empty;
    }

    @Override
    public abstract XPathNavigator deepClone();

    public int comparePosition(XPathNavigator nav) {
        int n2;
        int n3;
        if (this.isSamePosition(nav)) {
            return 2;
        }
        if (this.isDescendant(nav)) {
            return 0;
        }
        if (nav.isDescendant(this)) {
            return 1;
        }
        XPathNavigator xPathNavigator = this.deepClone();
        XPathNavigator xPathNavigator2 = nav.deepClone();
        xPathNavigator.moveToRoot();
        xPathNavigator2.moveToRoot();
        if (!xPathNavigator.isSamePosition(xPathNavigator2)) {
            return 3;
        }
        xPathNavigator.moveTo(this);
        xPathNavigator2.moveTo(nav);
        int n4 = 0;
        while (xPathNavigator.moveToParent()) {
            ++n4;
        }
        xPathNavigator.moveTo(this);
        int n5 = 0;
        while (xPathNavigator2.moveToParent()) {
            ++n5;
        }
        xPathNavigator2.moveTo(nav);
        for (n3 = n4; n3 > n5; --n3) {
            xPathNavigator.moveToParent();
        }
        for (n2 = n5; n2 > n3; --n2) {
            xPathNavigator2.moveToParent();
        }
        while (!xPathNavigator.isSamePosition(xPathNavigator2)) {
            xPathNavigator.moveToParent();
            xPathNavigator2.moveToParent();
            --n3;
        }
        xPathNavigator.moveTo(this);
        for (n2 = n4; n2 > n3 + 1; --n2) {
            xPathNavigator.moveToParent();
        }
        xPathNavigator2.moveTo(nav);
        for (n2 = n5; n2 > n3 + 1; --n2) {
            xPathNavigator2.moveToParent();
        }
        if (xPathNavigator.getNodeType() == 3) {
            if (xPathNavigator2.getNodeType() != 3) {
                return 0;
            }
            while (xPathNavigator.moveToNextNamespace()) {
                if (!xPathNavigator.isSamePosition(xPathNavigator2)) continue;
                return 0;
            }
            return 1;
        }
        if (xPathNavigator2.getNodeType() == 3) {
            return 1;
        }
        if (xPathNavigator.getNodeType() == 2) {
            if (xPathNavigator2.getNodeType() != 2) {
                return 0;
            }
            while (xPathNavigator.moveToNextAttribute()) {
                if (!xPathNavigator.isSamePosition(xPathNavigator2)) continue;
                return 0;
            }
            return 1;
        }
        while (xPathNavigator.moveToNext()) {
            if (!xPathNavigator.isSamePosition(xPathNavigator2)) continue;
            return 0;
        }
        return 1;
    }

    public XPathExpression compile(String xpath) {
        return XPathExpression.compile(xpath);
    }

    XPathExpression compile(String xpath, IStaticXsltContext ctx) {
        return XPathExpression.compile(xpath, null, ctx);
    }

    public Object evaluate(String xpath) {
        return this.evaluate(this.compile(xpath));
    }

    public Object evaluate(XPathExpression expr) {
        return this.evaluate(expr, null);
    }

    public Object evaluate(XPathExpression expr, XPathNodeIterator context) {
        return this.a(expr, context, null);
    }

    private BaseIterator a(XPathNodeIterator xPathNodeIterator, IXmlNamespaceResolver iXmlNamespaceResolver) {
        BaseIterator baseIterator;
        BaseIterator baseIterator2 = baseIterator = xPathNodeIterator instanceof BaseIterator ? (BaseIterator)xPathNodeIterator : null;
        if (baseIterator == null) {
            baseIterator = new WrapperIterator(xPathNodeIterator, iXmlNamespaceResolver);
        }
        return baseIterator;
    }

    private Object a(XPathExpression xPathExpression, XPathNodeIterator xPathNodeIterator, IXmlNamespaceResolver iXmlNamespaceResolver) {
        CompiledExpression compiledExpression = (CompiledExpression)xPathExpression;
        if (iXmlNamespaceResolver == null) {
            iXmlNamespaceResolver = compiledExpression.getNamespaceManager();
        }
        if (xPathNodeIterator == null) {
            xPathNodeIterator = new NullIterator(this, iXmlNamespaceResolver);
        }
        BaseIterator baseIterator = this.a(xPathNodeIterator, iXmlNamespaceResolver);
        baseIterator.setNamespaceManager(iXmlNamespaceResolver);
        return compiledExpression.evaluate(baseIterator);
    }

    XPathNodeIterator evaluateNodeSet(XPathExpression expr, XPathNodeIterator context, IXmlNamespaceResolver ctx) {
        CompiledExpression compiledExpression = (CompiledExpression)expr;
        if (ctx == null) {
            ctx = compiledExpression.getNamespaceManager();
        }
        if (context == null) {
            context = new NullIterator(this, compiledExpression.getNamespaceManager());
        }
        BaseIterator baseIterator = this.a(context, ctx);
        baseIterator.setNamespaceManager(ctx);
        return compiledExpression.evaluateNodeSet(baseIterator);
    }

    String evaluateString(XPathExpression expr, XPathNodeIterator context, IXmlNamespaceResolver ctx) {
        CompiledExpression compiledExpression = (CompiledExpression)expr;
        if (ctx == null) {
            ctx = compiledExpression.getNamespaceManager();
        }
        if (context == null) {
            context = new NullIterator(this, compiledExpression.getNamespaceManager());
        }
        BaseIterator baseIterator = this.a(context, ctx);
        return compiledExpression.evaluateString(baseIterator);
    }

    double evaluateNumber(XPathExpression expr, XPathNodeIterator context, IXmlNamespaceResolver ctx) {
        CompiledExpression compiledExpression = (CompiledExpression)expr;
        if (ctx == null) {
            ctx = compiledExpression.getNamespaceManager();
        }
        if (context == null) {
            context = new NullIterator(this, compiledExpression.getNamespaceManager());
        }
        BaseIterator baseIterator = this.a(context, ctx);
        baseIterator.setNamespaceManager(ctx);
        return compiledExpression.evaluateNumber(baseIterator);
    }

    boolean evaluateBoolean(XPathExpression expr, XPathNodeIterator context, IXmlNamespaceResolver ctx) {
        CompiledExpression compiledExpression = (CompiledExpression)expr;
        if (ctx == null) {
            ctx = compiledExpression.getNamespaceManager();
        }
        if (context == null) {
            context = new NullIterator(this, compiledExpression.getNamespaceManager());
        }
        BaseIterator baseIterator = this.a(context, ctx);
        baseIterator.setNamespaceManager(ctx);
        return compiledExpression.evaluateBoolean(baseIterator);
    }

    public String getAttribute(String localName, String namespaceURI) {
        if (!this.moveToAttribute(localName, namespaceURI)) {
            return StringExtensions.Empty;
        }
        String string = this.getValue();
        this.moveToParent();
        return string;
    }

    public String getNamespace(String name) {
        if (!this.moveToNamespace(name)) {
            return StringExtensions.Empty;
        }
        String string = this.getValue();
        this.moveToParent();
        return string;
    }

    public boolean isDescendant(XPathNavigator nav) {
        if (nav != null) {
            nav = nav.deepClone();
            while (nav.moveToParent()) {
                if (!this.isSamePosition(nav)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean isSamePosition(XPathNavigator var1);

    public boolean matches(String xpath) {
        return this.matches(this.compile(xpath));
    }

    public boolean matches(XPathExpression expr) {
        NodeTest nodeTest;
        Expression expression = ((CompiledExpression)expr).getExpressionNode();
        if (expression instanceof ExprRoot) {
            return this.getNodeType() == 0;
        }
        NodeTest nodeTest2 = nodeTest = expression instanceof NodeTest ? (NodeTest)expression : null;
        if (nodeTest != null) {
            switch (nodeTest.getAxis().getAxis()) {
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new XPathException("Only child and attribute pattern are allowed for a pattern.");
                }
            }
            return nodeTest.match(((CompiledExpression)expr).getNamespaceManager(), this);
        }
        if (expression instanceof ExprFilter) {
            while ((expression = ((ExprFilter)expression).getLeftHandSide()) instanceof ExprFilter) {
            }
            if (expression instanceof NodeTest && !((NodeTest)expression).match(((CompiledExpression)expr).getNamespaceManager(), this)) {
                return false;
            }
        }
        int n2 = expression.getReturnType();
        switch (n2) {
            case 3: 
            case 5: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (expression.getEvaluatedNodeType()) {
            case 2: 
            case 3: {
                if (this.getNodeType() == expression.getEvaluatedNodeType()) break;
                return false;
            }
        }
        XPathNodeIterator xPathNodeIterator = this.select(expr);
        while (xPathNodeIterator.moveNext()) {
            if (!this.isSamePosition(xPathNodeIterator.getCurrent())) continue;
            return true;
        }
        XPathNavigator xPathNavigator = this.deepClone();
        while (xPathNavigator.moveToParent()) {
            xPathNodeIterator = xPathNavigator.select(expr);
            while (xPathNodeIterator.moveNext()) {
                if (!this.isSamePosition(xPathNodeIterator.getCurrent())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean moveTo(XPathNavigator var1);

    public boolean moveToAttribute(String localName, String namespaceURI) {
        if (this.moveToFirstAttribute()) {
            do {
                if (!StringExtensions.equals(this.getLocalName(), localName) || !StringExtensions.equals(this.getNamespaceURI(), namespaceURI)) continue;
                return true;
            } while (this.moveToNextAttribute());
            this.moveToParent();
        }
        return false;
    }

    public boolean moveToNamespace(String name) {
        if (this.moveToFirstNamespace()) {
            do {
                if (!StringExtensions.equals(this.getLocalName(), name)) continue;
                return true;
            } while (this.moveToNextNamespace());
            this.moveToParent();
        }
        return false;
    }

    public boolean moveToFirst() {
        return this.moveToFirstImpl();
    }

    public void moveToRoot() {
        while (this.moveToParent()) {
        }
    }

    boolean moveToFirstImpl() {
        switch (this.getNodeType()) {
            case 2: 
            case 3: {
                return false;
            }
        }
        if (!this.moveToParent()) {
            return false;
        }
        this.moveToFirstChild();
        return true;
    }

    public abstract boolean moveToFirstAttribute();

    public abstract boolean moveToFirstChild();

    public boolean moveToFirstNamespace() {
        return this.moveToFirstNamespace(0);
    }

    public abstract boolean moveToFirstNamespace(int var1);

    public abstract boolean moveToId(String var1);

    public abstract boolean moveToNext();

    public abstract boolean moveToNextAttribute();

    public boolean moveToNextNamespace() {
        return this.moveToNextNamespace(0);
    }

    public abstract boolean moveToNextNamespace(int var1);

    public abstract boolean moveToParent();

    public abstract boolean moveToPrevious();

    public XPathNodeIterator select(String xpath) {
        return this.select(this.compile(xpath));
    }

    public XPathNodeIterator select(XPathExpression expr) {
        return this.select(expr, null);
    }

    XPathNodeIterator select(XPathExpression expr, IXmlNamespaceResolver ctx) {
        CompiledExpression compiledExpression = (CompiledExpression)expr;
        if (ctx == null) {
            ctx = compiledExpression.getNamespaceManager();
        }
        NullIterator nullIterator = new NullIterator(this, ctx);
        return compiledExpression.evaluateNodeSet(nullIterator);
    }

    public XPathNodeIterator selectAncestors(int type, boolean matchSelf) {
        int n2 = matchSelf ? 1 : 0;
        return this.selectTest(new NodeTypeTest(n2, type));
    }

    public XPathNodeIterator selectAncestors(String name, String namespaceURI, boolean matchSelf) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (namespaceURI == null) {
            throw new ArgumentNullException("namespaceURI");
        }
        int n2 = matchSelf ? 1 : 0;
        XmlQualifiedName xmlQualifiedName = new XmlQualifiedName(name, namespaceURI);
        return this.selectTest(new NodeNameTest(n2, xmlQualifiedName, true));
    }

    private static IEnumerable a(XPathNavigator xPathNavigator, int n2) {
        EnumerateChildrenIterator0 enumerateChildrenIterator0 = new EnumerateChildrenIterator0();
        enumerateChildrenIterator0.n = xPathNavigator;
        enumerateChildrenIterator0.type = n2;
        enumerateChildrenIterator0.s_n = xPathNavigator;
        enumerateChildrenIterator0.s_type = n2;
        enumerateChildrenIterator0.s_PC = -2;
        return enumerateChildrenIterator0;
    }

    public XPathNodeIterator selectChildren(int type) {
        return new WrapperIterator(new EnumerableIterator(XPathNavigator.a(this, type), 0), null);
    }

    static IEnumerable enumerateChildren(XPathNavigator n2, String name, String ns) {
        EnumerateChildrenIterator1 enumerateChildrenIterator1 = new EnumerateChildrenIterator1();
        enumerateChildrenIterator1.n = n2;
        enumerateChildrenIterator1.name = name;
        enumerateChildrenIterator1.ns = ns;
        enumerateChildrenIterator1.s_n = n2;
        enumerateChildrenIterator1.s_name = name;
        enumerateChildrenIterator1.s_ns = ns;
        enumerateChildrenIterator1.s_PC = -2;
        return enumerateChildrenIterator1;
    }

    public XPathNodeIterator selectChildren(String name, String namespaceURI) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (namespaceURI == null) {
            throw new ArgumentNullException("namespaceURI");
        }
        return new WrapperIterator(new EnumerableIterator(XPathNavigator.enumerateChildren(this, name, namespaceURI), 0), null);
    }

    public XPathNodeIterator selectDescendants(int type, boolean matchSelf) {
        int n2 = matchSelf ? 5 : 4;
        return this.selectTest(new NodeTypeTest(n2, type));
    }

    public XPathNodeIterator selectDescendants(String name, String namespaceURI, boolean matchSelf) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (namespaceURI == null) {
            throw new ArgumentNullException("namespaceURI");
        }
        int n2 = matchSelf ? 5 : 4;
        XmlQualifiedName xmlQualifiedName = new XmlQualifiedName(name, namespaceURI);
        return this.selectTest(new NodeNameTest(n2, xmlQualifiedName, true));
    }

    XPathNodeIterator selectTest(NodeTest test) {
        return test.evaluateNodeSet(new NullIterator(this));
    }

    public String toString() {
        return this.getValue();
    }

    public boolean checkValidity(XmlSchemaSet schemas, ValidationEventHandler delegate) {
        XmlReaderSettings xmlReaderSettings = new XmlReaderSettings();
        xmlReaderSettings.setNameTable(this.getNameTable());
        xmlReaderSettings.setSchemas(schemas);
        xmlReaderSettings.ValidationEventHandler.add(delegate);
        xmlReaderSettings.setValidationType(4);
        try {
            XmlReader xmlReader = XmlReader.create(this.readSubtree(), xmlReaderSettings);
            while (!xmlReader.getEOF()) {
                xmlReader.read();
            }
        }
        catch (XmlSchemaValidationException xmlSchemaValidationException) {
            return false;
        }
        return true;
    }

    @Override
    public XPathNavigator createNavigator() {
        return this.deepClone();
    }

    public Object evaluate(String xpath, IXmlNamespaceResolver nsResolver) {
        return this.a(this.compile(xpath), null, nsResolver);
    }

    @Override
    public IGenericDictionary<String, String> getNamespacesInScope(int scope) {
        Dictionary<String, String> dictionary = new Dictionary<String, String>();
        int n2 = scope == 2 ? 2 : (scope == 1 ? 1 : 0);
        XPathNavigator xPathNavigator = this.deepClone();
        if (xPathNavigator.getNodeType() != 1) {
            xPathNavigator.moveToParent();
        }
        if (!xPathNavigator.moveToFirstNamespace(n2)) {
            return dictionary;
        }
        do {
            dictionary.addItem(xPathNavigator.getName(), xPathNavigator.getValue());
        } while (xPathNavigator.moveToNextNamespace(n2));
        return dictionary;
    }

    @Override
    public String lookupNamespace(String prefix) {
        XPathNavigator xPathNavigator = this.deepClone();
        if (xPathNavigator.getNodeType() != 1) {
            xPathNavigator.moveToParent();
        }
        if (xPathNavigator.moveToNamespace(prefix)) {
            return xPathNavigator.getValue();
        }
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceUri) {
        XPathNavigator xPathNavigator = this.deepClone();
        if (xPathNavigator.getNodeType() != 1) {
            xPathNavigator.moveToParent();
        }
        if (!xPathNavigator.moveToFirstNamespace()) {
            return null;
        }
        do {
            if (!StringExtensions.equals(xPathNavigator.getValue(), namespaceUri)) continue;
            return xPathNavigator.getName();
        } while (xPathNavigator.moveToNextNamespace());
        return null;
    }

    private boolean a(XPathNodeIterator xPathNodeIterator) {
        if (xPathNodeIterator.moveNext()) {
            this.moveTo(xPathNodeIterator.getCurrent());
            return true;
        }
        return false;
    }

    public boolean moveToChild(int type) {
        return this.a(this.selectChildren(type));
    }

    public boolean moveToChild(String localName, String namespaceURI) {
        return this.a(this.selectChildren(localName, namespaceURI));
    }

    public boolean moveToNext(String localName, String namespaceURI) {
        XPathNavigator xPathNavigator = this.deepClone();
        while (xPathNavigator.moveToNext()) {
            if (!StringExtensions.equals(xPathNavigator.getLocalName(), localName) || !StringExtensions.equals(xPathNavigator.getNamespaceURI(), namespaceURI)) continue;
            this.moveTo(xPathNavigator);
            return true;
        }
        return false;
    }

    public boolean moveToNext(int type) {
        XPathNavigator xPathNavigator = this.deepClone();
        while (xPathNavigator.moveToNext()) {
            if (type != 9 && xPathNavigator.getNodeType() != type) continue;
            this.moveTo(xPathNavigator);
            return true;
        }
        return false;
    }

    public boolean moveToFollowing(String localName, String namespaceURI) {
        return this.moveToFollowing(localName, namespaceURI, null);
    }

    public boolean moveToFollowing(String localName, String namespaceURI, XPathNavigator end) {
        if (localName == null) {
            throw new ArgumentNullException("localName");
        }
        if (namespaceURI == null) {
            throw new ArgumentNullException("namespaceURI");
        }
        localName = this.getNameTable().get(localName);
        if (localName == null) {
            return false;
        }
        namespaceURI = this.getNameTable().get(namespaceURI);
        if (namespaceURI == null) {
            return false;
        }
        XPathNavigator xPathNavigator = this.deepClone();
        switch (xPathNavigator.getNodeType()) {
            case 2: 
            case 3: {
                xPathNavigator.moveToParent();
            }
        }
        do {
            if (!xPathNavigator.moveToFirstChild()) {
                while (!xPathNavigator.moveToNext()) {
                    if (xPathNavigator.moveToParent()) continue;
                    return false;
                }
            }
            if (end == null || !end.isSamePosition(xPathNavigator)) continue;
            return false;
        } while (!ObjectExtensions.referenceEquals(localName, xPathNavigator.getLocalName()) || !ObjectExtensions.referenceEquals(namespaceURI, xPathNavigator.getNamespaceURI()));
        this.moveTo(xPathNavigator);
        return true;
    }

    public boolean moveToFollowing(int type) {
        return this.moveToFollowing(type, null);
    }

    public boolean moveToFollowing(int type, XPathNavigator end) {
        if (type == 0) {
            return false;
        }
        XPathNavigator xPathNavigator = this.deepClone();
        switch (xPathNavigator.getNodeType()) {
            case 2: 
            case 3: {
                xPathNavigator.moveToParent();
            }
        }
        do {
            if (!xPathNavigator.moveToFirstChild()) {
                while (!xPathNavigator.moveToNext()) {
                    if (xPathNavigator.moveToParent()) continue;
                    return false;
                }
            }
            if (end == null || !end.isSamePosition(xPathNavigator)) continue;
            return false;
        } while (type != 9 && xPathNavigator.getNodeType() != type);
        this.moveTo(xPathNavigator);
        return true;
    }

    public XmlReader readSubtree() {
        switch (this.getNodeType()) {
            case 0: 
            case 1: {
                return new XPathNavigatorReader(this);
            }
        }
        throw new InvalidOperationException(StringExtensions.format("NodeType {0} is not supported to read as a subtree of an XPathNavigator.", this.getNodeType()));
    }

    public XPathNodeIterator select(String xpath, IXmlNamespaceResolver nsResolver) {
        return this.select(this.compile(xpath), nsResolver);
    }

    public XPathNavigator selectSingleNode(String xpath) {
        return this.selectSingleNode(xpath, null);
    }

    public XPathNavigator selectSingleNode(String xpath, IXmlNamespaceResolver nsResolver) {
        XPathExpression xPathExpression = this.compile(xpath);
        xPathExpression.setContext(nsResolver);
        return this.selectSingleNode(xPathExpression);
    }

    public XPathNavigator selectSingleNode(XPathExpression expression) {
        XPathNodeIterator xPathNodeIterator = this.select(expression);
        if (xPathNodeIterator.moveNext()) {
            return xPathNodeIterator.getCurrent();
        }
        return null;
    }

    public void writeSubtree(XmlWriter writer) {
        writer.writeNode(this, false);
    }

    static String escapeString(String value, boolean attr) {
        char[] cArray;
        msStringBuilder msStringBuilder2 = null;
        char[] cArray2 = cArray = attr ? escape_attr_chars : escape_text_chars;
        if (StringExtensions.indexOfAny(value, cArray) < 0) {
            return value;
        }
        msStringBuilder2 = new msStringBuilder(value, value.length() + 10);
        if (attr) {
            msStringBuilder2.replace("\"", "&quot;");
        }
        msStringBuilder2.replace("<", "&lt;");
        msStringBuilder2.replace(">", "&gt;");
        if (attr) {
            msStringBuilder2.replace("\r\n", "&#10;");
            msStringBuilder2.replace("\r", "&#10;");
            msStringBuilder2.replace("\n", "&#10;");
        }
        return msStringBuilder2.toString();
    }

    public String getInnerXml() {
        switch (this.getNodeType()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                return XPathNavigator.escapeString(this.getValue(), true);
            }
            case 4: 
            case 5: 
            case 6: {
                return StringExtensions.Empty;
            }
            case 7: 
            case 8: {
                return this.getValue();
            }
        }
        XmlReader xmlReader = this.readSubtree();
        xmlReader.read();
        int n2 = xmlReader.getDepth();
        if (this.getNodeType() != 0) {
            xmlReader.read();
        } else {
            n2 = -1;
        }
        StringWriter stringWriter = new StringWriter();
        XmlWriterSettings xmlWriterSettings = new XmlWriterSettings();
        xmlWriterSettings.setIndent(true);
        xmlWriterSettings.setConformanceLevel(1);
        xmlWriterSettings.setOmitXmlDeclaration(true);
        XmlWriter xmlWriter = XmlWriter.create(stringWriter, xmlWriterSettings);
        while (!xmlReader.getEOF() && xmlReader.getDepth() > n2) {
            xmlWriter.writeNode(xmlReader, false);
        }
        return stringWriter.toString();
    }

    public void setInnerXml(String value) {
        this.a();
        if (this.getNodeType() == 2) {
            this.setValue(value);
            return;
        }
        this.appendChild(value);
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOuterXml() {
        switch (this.getNodeType()) {
            case 2: {
                return StringExtensions.concat(this.getPrefix(), this.getPrefix().length() > 0 ? ":" : StringExtensions.Empty, this.getLocalName(), "=\"", XPathNavigator.escapeString(this.getValue(), true), "\"");
            }
            case 3: {
                return StringExtensions.concat("xmlns", this.getLocalName().length() > 0 ? ":" : StringExtensions.Empty, this.getLocalName(), "=\"", XPathNavigator.escapeString(this.getValue(), true), "\"");
            }
            case 4: {
                return XPathNavigator.escapeString(this.getValue(), false);
            }
            case 5: 
            case 6: {
                return this.getValue();
            }
        }
        XmlWriterSettings xmlWriterSettings = new XmlWriterSettings();
        xmlWriterSettings.setIndent(true);
        xmlWriterSettings.setOmitXmlDeclaration(true);
        xmlWriterSettings.setConformanceLevel(1);
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        XmlWriter xmlWriter = XmlWriter.create(msStringBuilder2, xmlWriterSettings);
        try {
            this.writeSubtree(xmlWriter);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
        return msStringBuilder2.toString();
    }

    public void setOuterXml(String value) {
        switch (this.getNodeType()) {
            case 0: 
            case 2: 
            case 3: {
                throw new XmlException("Setting OuterXml Root, Attribute and Namespace is not supported.");
            }
        }
        this.deleteSelf();
        this.appendChild(value);
        this.moveToFirstChild();
    }

    public IXmlSchemaInfo getSchemaInfo() {
        return null;
    }

    @Override
    public Object getTypedValue() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                XmlSchemaDatatype xmlSchemaDatatype;
                if (this.getXmlType() == null || (xmlSchemaDatatype = this.getXmlType().getDatatype()) == null) break;
                return xmlSchemaDatatype.parseValue(this.getValue(), this.getNameTable(), this);
            }
        }
        return this.getValue();
    }

    public Object getUnderlyingObject() {
        return null;
    }

    @Override
    public boolean getValueAsBoolean() {
        return XQueryConvert.stringToBoolean(this.getValue());
    }

    @Override
    public DateTime getValueAsDateTime() {
        return XmlConvert.toDateTime(this.getValue());
    }

    @Override
    public double getValueAsDouble() {
        return XQueryConvert.stringToDouble(this.getValue());
    }

    @Override
    public int getValueAsInt() {
        return XQueryConvert.stringToInt(this.getValue());
    }

    @Override
    public long getValueAsLong() {
        return XQueryConvert.stringToInteger(this.getValue());
    }

    @Override
    public Type getValueType() {
        return this.getSchemaInfo() != null && this.getSchemaInfo().getSchemaType() != null && this.getSchemaInfo().getSchemaType().getDatatype() != null ? this.getSchemaInfo().getSchemaType().getDatatype().getValueType() : null;
    }

    @Override
    public XmlSchemaType getXmlType() {
        if (this.getSchemaInfo() != null) {
            return this.getSchemaInfo().getSchemaType();
        }
        return null;
    }

    private XmlReader a(String string) {
        XmlReaderSettings xmlReaderSettings = new XmlReaderSettings();
        xmlReaderSettings.setConformanceLevel(1);
        XmlNamespaceManager xmlNamespaceManager = new XmlNamespaceManager(this.getNameTable());
        for (KeyValuePair keyValuePair : this.getNamespacesInScope(0)) {
            xmlNamespaceManager.addNamespace((String)keyValuePair.getKey(), (String)keyValuePair.getValue());
        }
        return XmlReader.create((TextReader)new StringReader(string), xmlReaderSettings, new XmlParserContext(this.getNameTable(), xmlNamespaceManager, null, 0));
    }

    public XmlWriter appendChild() {
        throw new NotSupportedException();
    }

    public void appendChild(String xmlFragments) {
        this.appendChild(this.a(xmlFragments));
    }

    public void appendChild(XmlReader reader) {
        XmlWriter xmlWriter = this.appendChild();
        while (!reader.getEOF()) {
            xmlWriter.writeNode(reader, false);
        }
        xmlWriter.close();
    }

    public void appendChild(XPathNavigator nav) {
        this.appendChild(new XPathNavigatorReader(nav));
    }

    public void appendChildElement(String prefix, String name, String ns, String value) {
        XmlWriter xmlWriter = this.appendChild();
        xmlWriter.writeStartElement(prefix, name, ns);
        xmlWriter.writeString(value);
        xmlWriter.writeEndElement();
        xmlWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAttribute(String prefix, String localName, String namespaceURI, String value) {
        XmlWriter xmlWriter = this.createAttributes();
        try {
            xmlWriter.writeAttributeString(prefix, localName, namespaceURI, value);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    public XmlWriter createAttributes() {
        throw new NotSupportedException();
    }

    public void deleteSelf() {
        throw new NotSupportedException();
    }

    public void deleteRange(XPathNavigator nav) {
        throw new NotSupportedException();
    }

    public XmlWriter replaceRange(XPathNavigator nav) {
        throw new NotSupportedException();
    }

    public XmlWriter insertAfter() {
        switch (this.getNodeType()) {
            case 0: 
            case 2: 
            case 3: {
                throw new InvalidOperationException(StringExtensions.format("Insertion after {0} is not allowed.", this.getNodeType()));
            }
        }
        XPathNavigator xPathNavigator = this.deepClone();
        if (xPathNavigator.moveToNext()) {
            return xPathNavigator.insertBefore();
        }
        if (xPathNavigator.moveToParent()) {
            return xPathNavigator.appendChild();
        }
        throw new InvalidOperationException("Could not move to parent to insert sibling node");
    }

    public void insertAfter(String xmlFragments) {
        this.insertAfter(this.a(xmlFragments));
    }

    public void insertAfter(XmlReader reader) {
        XmlWriter xmlWriter = this.insertAfter();
        try {
            xmlWriter.writeNode(reader, false);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    public void insertAfter(XPathNavigator nav) {
        this.insertAfter(new XPathNavigatorReader(nav));
    }

    public XmlWriter insertBefore() {
        throw new NotSupportedException();
    }

    public void insertBefore(String xmlFragments) {
        this.insertBefore(this.a(xmlFragments));
    }

    public void insertBefore(XmlReader reader) {
        XmlWriter xmlWriter = this.insertBefore();
        try {
            xmlWriter.writeNode(reader, false);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    public void insertBefore(XPathNavigator nav) {
        this.insertBefore(new XPathNavigatorReader(nav));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementAfter(String prefix, String localName, String namespaceURI, String value) {
        XmlWriter xmlWriter = this.insertAfter();
        try {
            xmlWriter.writeElementString(prefix, localName, namespaceURI, value);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementBefore(String prefix, String localName, String namespaceURI, String value) {
        XmlWriter xmlWriter = this.insertBefore();
        try {
            xmlWriter.writeElementString(prefix, localName, namespaceURI, value);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    public XmlWriter prependChild() {
        XPathNavigator xPathNavigator = this.deepClone();
        if (xPathNavigator.moveToFirstChild()) {
            return xPathNavigator.insertBefore();
        }
        return this.appendChild();
    }

    public void prependChild(String xmlFragments) {
        this.prependChild(this.a(xmlFragments));
    }

    public void prependChild(XmlReader reader) {
        XmlWriter xmlWriter = this.prependChild();
        try {
            xmlWriter.writeNode(reader, false);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    public void prependChild(XPathNavigator nav) {
        this.prependChild(new XPathNavigatorReader(nav));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prependChildElement(String prefix, String localName, String namespaceURI, String value) {
        XmlWriter xmlWriter = this.prependChild();
        try {
            xmlWriter.writeElementString(prefix, localName, namespaceURI, value);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.dispose();
            }
        }
    }

    public void replaceSelf(String xmlFragment) {
        this.replaceSelf(this.a(xmlFragment));
    }

    public void replaceSelf(XmlReader reader) {
        throw new NotSupportedException();
    }

    public void replaceSelf(XPathNavigator navigator) {
        this.replaceSelf(new XPathNavigatorReader(navigator));
    }

    @TodoAttribute
    public void setTypedValue(Object value) {
        throw new NotSupportedException();
    }

    public void setValue(String value) {
        throw new NotSupportedException();
    }

    private void a() {
        switch (this.getNodeType()) {
            case 3: {
                throw new InvalidOperationException("Removing namespace node content is not supported.");
            }
            case 2: {
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.deleteSelf();
                return;
            }
        }
        if (!this.hasChildren()) {
            return;
        }
        XPathNavigator xPathNavigator = this.deepClone();
        xPathNavigator.moveToFirstChild();
        while (!xPathNavigator.isSamePosition(this)) {
            xPathNavigator.deleteSelf();
        }
    }

    private static final class EnumerateChildrenIterator1
    implements IGenericEnumerable<Object>,
    IGenericEnumerator<Object> {
        Object s_current;
        int s_PC;
        XPathNavigator s_n;
        String s_name;
        String s_ns;
        XPathNavigator nav__0;
        XPathNavigator nav2__1;
        XPathNavigator n;
        String name;
        String ns;

        private EnumerateChildrenIterator1() {
        }

        @Override
        public void dispose() {
            this.s_PC = -1;
        }

        @Override
        public boolean hasNext() {
            long l2 = this.s_PC;
            this.s_PC = -1;
            int n2 = 0;
            switch ((int)l2) {
                case 0: {
                    if (this.n.moveToFirstChild()) {
                        this.n.moveToParent();
                        this.nav__0 = this.n.deepClone();
                        this.nav__0.moveToFirstChild();
                        this.nav2__1 = this.nav__0.deepClone();
                        n2 = 1;
                        break;
                    }
                    return false;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            while (n2 != 0) {
                switch (n2) {
                    case 1: {
                        if ((StringExtensions.equals(this.name, StringExtensions.Empty) || StringExtensions.equals(this.nav__0.getLocalName(), this.name)) && (StringExtensions.equals(this.ns, StringExtensions.Empty) || StringExtensions.equals(this.nav__0.getNamespaceURI(), this.ns))) {
                            this.nav2__1.moveTo(this.nav__0);
                            this.s_current = this.nav2__1;
                            this.s_PC = 1;
                            return true;
                        }
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        if (this.nav__0.moveToNext()) {
                            n2 = 1;
                            break;
                        }
                        n2 = 0;
                        this.s_PC = -1;
                    }
                }
            }
            return false;
        }

        @Override
        public void reset() {
            throw new NotSupportedException();
        }

        @Override
        public IGenericEnumerator<Object> iterator() {
            AtomicInteger atomicInteger = new AtomicInteger(this.s_PC);
            boolean bl2 = atomicInteger.compareAndSet(-2, 0);
            if (bl2) {
                this.s_PC = atomicInteger.intValue();
                return this;
            }
            EnumerateChildrenIterator1 enumerateChildrenIterator1 = new EnumerateChildrenIterator1();
            enumerateChildrenIterator1.n = this.s_n;
            enumerateChildrenIterator1.name = this.s_name;
            enumerateChildrenIterator1.ns = this.s_ns;
            return enumerateChildrenIterator1;
        }

        @Override
        public Object next() {
            return this.s_current;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumerateChildrenIterator0
    implements IGenericEnumerable<Object>,
    IGenericEnumerator<Object> {
        Object s_current;
        int s_PC;
        XPathNavigator s_n;
        int s_type;
        XPathNavigator nav__0;
        XPathNavigator nav2__1;
        XPathNavigator n;
        int type;

        private EnumerateChildrenIterator0() {
        }

        @Override
        public void dispose() {
            this.s_PC = -1;
        }

        @Override
        public boolean hasNext() {
            long l2 = this.s_PC;
            this.s_PC = -1;
            int n2 = 0;
            switch ((int)l2) {
                case 0: {
                    if (this.n.moveToFirstChild()) {
                        this.n.moveToParent();
                        this.nav__0 = this.n.deepClone();
                        this.nav__0.moveToFirstChild();
                        this.nav2__1 = null;
                        n2 = 1;
                        break;
                    }
                    return false;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            while (n2 != 0) {
                switch (n2) {
                    case 1: {
                        if (this.type == 9 || this.nav__0.getNodeType() == this.type) {
                            if (this.nav2__1 == null) {
                                this.nav2__1 = this.nav__0.deepClone();
                            } else {
                                this.nav2__1.moveTo(this.nav__0);
                            }
                            this.s_current = this.nav2__1;
                            this.s_PC = 1;
                            return true;
                        }
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        if (this.nav__0.moveToNext()) {
                            n2 = 1;
                            break;
                        }
                        n2 = 0;
                        this.s_PC = -1;
                    }
                }
            }
            return false;
        }

        @Override
        public void reset() {
            throw new NotSupportedException();
        }

        @Override
        public IGenericEnumerator<Object> iterator() {
            AtomicInteger atomicInteger = new AtomicInteger(this.s_PC);
            boolean bl2 = atomicInteger.compareAndSet(-2, 0);
            if (bl2) {
                this.s_PC = atomicInteger.intValue();
                return this;
            }
            EnumerateChildrenIterator0 enumerateChildrenIterator0 = new EnumerateChildrenIterator0();
            enumerateChildrenIterator0.n = this.s_n;
            enumerateChildrenIterator0.type = this.s_type;
            return enumerateChildrenIterator0;
        }

        @Override
        public Object next() {
            return this.s_current;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class EnumerableIterator
    extends XPathNodeIterator {
        private IEnumerable a;
        private IEnumerator b;
        private int c;

        public EnumerableIterator(IEnumerable source, int pos) {
            this.a = source;
            for (int i2 = 0; i2 < pos; ++i2) {
                this.moveNext();
            }
        }

        @Override
        public XPathNodeIterator deepClone() {
            return new EnumerableIterator(this.a, this.c);
        }

        @Override
        public boolean moveNext() {
            if (this.b == null) {
                this.b = this.a.iterator();
            }
            if (!this.b.hasNext()) {
                return false;
            }
            ++this.c;
            return true;
        }

        @Override
        public int getCurrentPosition() {
            return this.c;
        }

        @Override
        public XPathNavigator getCurrent() {
            return this.c == 0 ? null : (XPathNavigator)this.b.next();
        }
    }
}

