/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XPathNodeIterator;
import com.aspose.html.internal.ms.System.Xml.XmlChar;

class XPathFunctions {
    XPathFunctions() {
    }

    public static boolean toBoolean(Object arg) {
        if (arg == null) {
            throw new ArgumentNullException();
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg;
        }
        if (arg instanceof Double) {
            double d2 = (Double)arg;
            return d2 != 0.0 && !Double.isNaN(d2);
        }
        if (arg instanceof String) {
            return ((String)arg).length() != 0;
        }
        if (arg instanceof XPathNodeIterator) {
            XPathNodeIterator xPathNodeIterator = (XPathNodeIterator)arg;
            return xPathNodeIterator.moveNext();
        }
        if (arg instanceof XPathNavigator) {
            return XPathFunctions.toBoolean(((XPathNavigator)arg).selectChildren(9));
        }
        throw new ArgumentException();
    }

    public static boolean toBoolean(boolean b2) {
        return b2;
    }

    public static boolean toBoolean(double d2) {
        return d2 != 0.0 && !Double.isNaN(d2);
    }

    public static boolean toBoolean(String s2) {
        return s2 != null && s2.length() > 0;
    }

    public static boolean toBoolean(BaseIterator iter) {
        return iter != null && iter.moveNext();
    }

    public static String toString(Object arg) {
        if (arg == null) {
            throw new ArgumentNullException();
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg != false ? "true" : "false";
        }
        if (arg instanceof Double) {
            return XPathFunctions.toString((Double)arg);
        }
        if (arg instanceof XPathNodeIterator) {
            XPathNodeIterator xPathNodeIterator = (XPathNodeIterator)arg;
            if (!xPathNodeIterator.moveNext()) {
                return "";
            }
            return xPathNodeIterator.getCurrent().getValue();
        }
        if (arg instanceof XPathNavigator) {
            return ((XPathNavigator)arg).getValue();
        }
        throw new ArgumentException();
    }

    public static String toString(double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        return DoubleExtensions.toString(d2, "R", NumberFormatInfo.getInvariantInfo());
    }

    public static double toNumber(Object arg) {
        if (arg == null) {
            throw new ArgumentNullException();
        }
        if (arg instanceof BaseIterator || arg instanceof XPathNavigator) {
            arg = XPathFunctions.toString(arg);
        }
        if (arg instanceof String) {
            String string = (String)arg;
            return XPathFunctions.toNumber(string);
        }
        if (arg instanceof Double) {
            return (Double)arg;
        }
        if (arg instanceof Boolean) {
            return Convert.toDouble((Boolean)arg);
        }
        throw new ArgumentException();
    }

    public static double toNumber(String arg) {
        if (arg == null) {
            throw new ArgumentNullException();
        }
        String string = StringExtensions.trim(arg, XmlChar.WhitespaceChars);
        if (string.length() == 0) {
            return Double.NaN;
        }
        try {
            if (string.charAt(0) == '.') {
                string = StringExtensions.concat(Character.valueOf('.'), string);
            }
            return DoubleExtensions.parse(string, 39, NumberFormatInfo.getInvariantInfo());
        }
        catch (OverflowException overflowException) {
            return Double.NaN;
        }
        catch (FormatException formatException) {
            return Double.NaN;
        }
    }
}

