/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IConvertible;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.NullIterator;
import com.aspose.html.internal.ms.System.Xml.WrapperIterator;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathFunctions;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XPathNodeIterator;

abstract class Expression {
    public abstract int getReturnType();

    public int getReturnType(BaseIterator iter) {
        return this.getReturnType();
    }

    public Expression optimize() {
        return this;
    }

    public boolean hasStaticValue() {
        return false;
    }

    public Object getStaticValue() {
        switch (this.getReturnType()) {
            case 1: {
                return this.getStaticValueAsString();
            }
            case 0: {
                return this.getStaticValueAsNumber();
            }
            case 2: {
                return this.getStaticValueAsBoolean();
            }
        }
        return null;
    }

    public String getStaticValueAsString() {
        return this.hasStaticValue() ? XPathFunctions.toString(this.getStaticValue()) : null;
    }

    public double getStaticValueAsNumber() {
        return this.hasStaticValue() ? XPathFunctions.toNumber(this.getStaticValue()) : 0.0;
    }

    public boolean getStaticValueAsBoolean() {
        return this.hasStaticValue() ? XPathFunctions.toBoolean(this.getStaticValue()) : false;
    }

    public XPathNavigator getStaticValueAsNavigator() {
        Object object = this.getStaticValue();
        return object instanceof XPathNavigator ? (XPathNavigator)object : null;
    }

    public abstract Object evaluate(BaseIterator var1);

    public BaseIterator evaluateNodeSet(BaseIterator iter) {
        int n2 = this.getReturnType(iter);
        switch (n2) {
            case 3: 
            case 4: 
            case 5: {
                XPathNavigator xPathNavigator;
                Object object = this.evaluate(iter);
                XPathNodeIterator xPathNodeIterator = object instanceof XPathNodeIterator ? (XPathNodeIterator)object : null;
                BaseIterator baseIterator = null;
                if (xPathNodeIterator != null) {
                    BaseIterator baseIterator2 = baseIterator = xPathNodeIterator instanceof BaseIterator ? (BaseIterator)xPathNodeIterator : null;
                    if (baseIterator == null) {
                        baseIterator = new WrapperIterator(xPathNodeIterator, iter.getNamespaceManager());
                    }
                    return baseIterator;
                }
                XPathNavigator xPathNavigator2 = xPathNavigator = object instanceof XPathNavigator ? (XPathNavigator)object : null;
                if (xPathNavigator != null) {
                    XPathNodeIterator xPathNodeIterator2 = xPathNavigator.selectChildren(9);
                    BaseIterator baseIterator3 = baseIterator = xPathNodeIterator2 instanceof BaseIterator ? (BaseIterator)xPathNodeIterator2 : null;
                    if (baseIterator == null && xPathNodeIterator2 != null) {
                        baseIterator = new WrapperIterator(xPathNodeIterator2, iter.getNamespaceManager());
                    }
                }
                if (baseIterator != null) {
                    return baseIterator;
                }
                if (object == null) {
                    return new NullIterator(iter);
                }
                n2 = Expression.getReturnType(object);
            }
        }
        throw new XPathException(StringExtensions.format("expected nodeset but was {1}: {0}", this.toString(), n2));
    }

    protected static int getReturnType(Object obj) {
        if (obj instanceof String) {
            return 1;
        }
        if (obj instanceof Boolean) {
            return 2;
        }
        if (obj instanceof XPathNodeIterator) {
            return 3;
        }
        if (obj instanceof Double || obj instanceof Integer) {
            return 0;
        }
        if (obj instanceof XPathNavigator) {
            return 4;
        }
        throw new XPathException(StringExtensions.concat("invalid node type: ", ObjectExtensions.getType(obj).toString()));
    }

    int getEvaluatedNodeType() {
        return 9;
    }

    boolean isPositional() {
        return false;
    }

    boolean getPeer() {
        return false;
    }

    public double evaluateNumber(BaseIterator iter) {
        Object object;
        int n2 = this.getReturnType(iter);
        if (n2 == 3) {
            object = this.evaluateString(iter);
            n2 = 1;
        } else {
            object = this.evaluate(iter);
        }
        if (n2 == 5) {
            n2 = Expression.getReturnType(object);
        }
        switch (n2) {
            case 0: {
                if (object instanceof Double) {
                    return (Double)object;
                }
                if (object instanceof IConvertible) {
                    return ((IConvertible)object).toDouble(CultureInfo.getInvariantCulture());
                }
                return (Double)object;
            }
            case 2: {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            case 3: {
                return XPathFunctions.toNumber(this.evaluateString(iter));
            }
            case 1: {
                return XPathFunctions.toNumber((String)object);
            }
            case 4: {
                return XPathFunctions.toNumber(((XPathNavigator)object).getValue());
            }
        }
        throw new XPathException("invalid node type");
    }

    public String evaluateString(BaseIterator iter) {
        Object object = this.evaluate(iter);
        int n2 = this.getReturnType(iter);
        if (n2 == 5) {
            n2 = Expression.getReturnType(object);
        }
        switch (n2) {
            case 0: {
                double d2 = (Double)object;
                return XPathFunctions.toString(d2);
            }
            case 2: {
                return (Boolean)object != false ? "true" : "false";
            }
            case 1: {
                return (String)object;
            }
            case 3: {
                BaseIterator baseIterator = (BaseIterator)object;
                if (baseIterator == null || !baseIterator.moveNext()) {
                    return "";
                }
                return baseIterator.getCurrent().getValue();
            }
            case 4: {
                return ((XPathNavigator)object).getValue();
            }
        }
        throw new XPathException("invalid node type");
    }

    public boolean evaluateBoolean(BaseIterator iter) {
        Object object = this.evaluate(iter);
        int n2 = this.getReturnType(iter);
        if (n2 == 5) {
            n2 = Expression.getReturnType(object);
        }
        switch (n2) {
            case 0: {
                double d2 = Convert.toDouble(object);
                return d2 != 0.0 && d2 != -0.0 && !Double.isNaN(d2);
            }
            case 2: {
                return (Boolean)object;
            }
            case 1: {
                return ((String)object).length() != 0;
            }
            case 3: {
                BaseIterator baseIterator = (BaseIterator)object;
                return baseIterator != null && baseIterator.moveNext();
            }
            case 4: {
                return ((XPathNavigator)object).hasChildren();
            }
        }
        throw new XPathException("invalid node type");
    }

    public Object evaluateAs(BaseIterator iter, int type) {
        switch (type) {
            case 2: {
                return this.evaluateBoolean(iter);
            }
            case 3: {
                return this.evaluateNodeSet(iter);
            }
            case 1: {
                return this.evaluateString(iter);
            }
            case 0: {
                return this.evaluateNumber(iter);
            }
        }
        return this.evaluate(iter);
    }

    public boolean getRequireSorting() {
        return false;
    }
}

