/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArithmeticException;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.core.System.p;
import com.aspose.html.internal.ms.lang.Operators;

public class UInt64
extends Number
implements Comparable<UInt64> {
    private static final long[] a = new long[37];
    private static final int[] b = new int[37];
    private static final int[] c = new int[37];
    private static boolean d;
    private Long e;
    public static final String MaxValueString = "18446744073709551615";
    public static UInt64 MaxValue;
    public static UInt64 MinValue;
    public static UInt64 OneValue;

    public UInt64(Long value) {
        this.e = value;
    }

    public UInt64(long value) {
        this.e = value;
    }

    public UInt64(int value) {
        this.e = new Long(value);
    }

    public UInt64(String value) {
        if (value.startsWith("0x") || value.startsWith("0X")) {
            if ((value = value.substring(2)).endsWith("L")) {
                value = value.substring(0, value.length() - 1);
            }
            this.e = UInt64.parseUnsignedLong(value, 16);
        } else {
            this.e = UInt64.parseUnsignedLong(value, 10);
        }
    }

    public static boolean isOverflowCheck() {
        return d;
    }

    public static void setOverflowCheck(boolean overflowCheck) {
        d = overflowCheck;
    }

    @Override
    public byte byteValue() {
        return this.e.byteValue();
    }

    @Override
    public short shortValue() {
        return this.e.shortValue();
    }

    @Override
    public int intValue() {
        return this.e.intValue();
    }

    @Override
    public long longValue() {
        return this.e;
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    @Override
    public int compareTo(UInt64 value) {
        return UInt64.a(this.e, value.e);
    }

    private static int a(long l2, long l3) {
        long l4 = l2 ^ Long.MIN_VALUE;
        long l5 = l3 ^ Long.MIN_VALUE;
        return l4 < l5 ? -1 : (l4 > l5 ? 1 : 0);
    }

    public boolean equals(UInt64 other) {
        if (ObjectExtensions.referenceEquals(null, other)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, other)) {
            return true;
        }
        return this.e.equals(other.e);
    }

    public boolean equals(Object obj) {
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (ObjectExtensions.getType(obj) != Operators.typeOf(UInt64.class)) {
            return false;
        }
        return this.equals((UInt64)obj);
    }

    public int hashCode() {
        return this.e.hashCode();
    }

    public int getTypeCode() {
        return 12;
    }

    public static String toString(UInt64 value) {
        return UInt64.a(value.longValue());
    }

    public String toString() {
        return k.a(null, this, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public String toString(IFormatProvider provider) {
        return k.a(null, this, (IFormatProvider)NumberFormatInfo.getInstance(provider));
    }

    public String toString(String format) {
        return k.a(format, this, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public String toString(String format, IFormatProvider provider) {
        return k.a(format, this, (IFormatProvider)NumberFormatInfo.getInstance(provider));
    }

    private static boolean a(long l2, int n2, int n3) {
        if (l2 >= 0L) {
            if (l2 < a[n3]) {
                return false;
            }
            if (l2 > a[n3]) {
                return true;
            }
            return n2 > b[n3];
        }
        return true;
    }

    public static long parseUnsignedLong(String s2, int radix) {
        if (s2.length() == 0) {
            throw new OverflowException("empty string");
        }
        int n2 = c[radix] - 1;
        long l2 = 0L;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            int n3 = UInt64.a(s2.charAt(i2), radix);
            if (n3 == -1) {
                throw new OverflowException(s2);
            }
            if (i2 > n2 && UInt64.a(l2, n3, radix)) {
                throw new OverflowException("Too large for unsigned long: " + s2);
            }
            l2 = l2 * (long)radix + (long)n3;
        }
        return l2;
    }

    private static int a(char c2, int n2) {
        char c3 = c2;
        switch (n2) {
            case 8: {
                if (c3 >= '0' && c3 <= '7') {
                    return c3 - 48;
                }
            }
            case 10: {
                if (c3 >= '0' && c3 <= '9') {
                    return c3 - 48;
                }
            }
            case 16: {
                if (c3 >= '0' && c3 <= '9') {
                    return c3 - 48;
                }
                if (c3 >= 'A' && c3 <= 'F') {
                    return c3 - 55;
                }
                if (c3 < 'a' || c3 > 'f') break;
                return c3 - 87;
            }
        }
        return Character.digit(c2, n2);
    }

    public static UInt64 parse(String s2) {
        return k.a(p.a(s2));
    }

    public static UInt64 parse(String s2, int style) {
        return k.a(p.a(s2, style));
    }

    public static UInt64 parse(String s2, IFormatProvider provider) {
        return k.a(p.a(s2, provider));
    }

    public static UInt64 parse(String s2, int style, IFormatProvider provider) {
        return k.a(p.a(s2, style, provider));
    }

    public static boolean tryParse(String s2, UInt64[] result) {
        return UInt64.tryParse(s2, 7, NumberFormatInfo.getCurrentInfo(), result);
    }

    public static boolean tryParse(String s2, int style, IFormatProvider provider, UInt64[] result) {
        try {
            result[0] = UInt64.parse(s2, style, provider);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static UInt64 op_Increment(UInt64 x2) {
        if (d && UInt64.op_GreaterThan(x2, UInt64.op_Subtraction(MaxValue, OneValue))) {
            throw new ArithmeticException("Owerflow: op_Increment");
        }
        Long l2 = x2.e;
        l2 = l2 + 1L;
        return new UInt64(l2);
    }

    public static UInt64 op_Decrement(UInt64 x2) {
        if (d && UInt64.op_LessThan(x2, UInt64.op_Increment(new UInt64(0L)))) {
            throw new ArithmeticException("Owerflow: op_Increment");
        }
        Long l2 = x2.e;
        l2 = l2 - 1L;
        return new UInt64(l2);
    }

    public static UInt64 op_OnesComplement(UInt64 x2) {
        return new UInt64((long)(x2.e ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static UInt64 op_BitwiseAnd(UInt64 x2, UInt64 y2) {
        return new UInt64(x2.e & y2.e);
    }

    public static UInt64 op_BitwiseOr(UInt64 x2, UInt64 y2) {
        return new UInt64(x2.e | y2.e);
    }

    public static UInt64 op_ExclusiveOr(UInt64 x2, UInt64 y2) {
        return new UInt64(x2.e ^ y2.e);
    }

    public static UInt64 op_Addition(UInt64 x2, UInt64 y2) {
        UInt64 uInt64 = new UInt64(x2.e + y2.e);
        if (d && UInt64.op_GreaterThan(x2, MinValue) && UInt64.op_GreaterThan(y2, MinValue) && (UInt64.op_LessThan(uInt64, x2) || UInt64.op_LessThan(uInt64, y2))) {
            throw new ArithmeticException("Owerflow: op_Addition");
        }
        return uInt64;
    }

    public static UInt64 op_Subtraction(UInt64 x2, UInt64 y2) {
        if (d && UInt64.op_LessThan(x2, y2)) {
            throw new ArithmeticException("Underflow: op_Subtraction");
        }
        return new UInt64(x2.e - y2.e);
    }

    public static UInt64 op_Multiply(UInt64 x2, UInt64 y2) {
        if (UInt64.a(x2.e, UInt64.MinValue.e) == 0 || UInt64.a(y2.e, UInt64.MinValue.e) == 0) {
            return MinValue;
        }
        long l2 = x2.e * y2.e;
        UInt64 uInt64 = UInt64.op_Division(new UInt64(l2), y2);
        if (d && UInt64.op_Inequality(x2, uInt64)) {
            throw new ArithmeticException("Owerflow: op_Multiply");
        }
        return new UInt64(l2);
    }

    public static UInt64 op_Division(UInt64 x2, UInt64 y2) {
        long l2;
        if (y2.equals(MinValue)) {
            throw new ArithmeticException("Division by zero");
        }
        long l3 = x2.e;
        long l4 = y2.e;
        if (l4 < 0L) {
            if (UInt64.a(l3, l4) < 0) {
                return MinValue;
            }
            return OneValue;
        }
        if (l3 >= 0L) {
            return new UInt64(l3 / l4);
        }
        long l5 = l3 - (l2 = (l3 >>> 1) / l4 << 1) * l4;
        return new UInt64(l2 + (long)(UInt64.a(l5, l4) >= 0 ? 1 : 0));
    }

    public static UInt64 op_Modulus(UInt64 x2, UInt64 y2) {
        long l2;
        if (y2.equals(MinValue)) {
            throw new ArithmeticException("Division by zero");
        }
        long l3 = x2.e;
        long l4 = y2.e;
        if (l4 < 0L) {
            if (UInt64.a(l3, l4) < 0) {
                return new UInt64(l3);
            }
            return new UInt64(l3 - l4);
        }
        if (l3 >= 0L) {
            return new UInt64(l3 % l4);
        }
        long l5 = (l3 >>> 1) / l4 << 1;
        return new UInt64(l2 - (UInt64.a(l2 = l3 - l5 * l4, l4) >= 0 ? l4 : 0L));
    }

    public static UInt64 op_RightShift(UInt64 x2, int y2) {
        return new UInt64(x2.e >>> y2);
    }

    public static UInt64 op_LeftShift(UInt64 x2, int y2) {
        return new UInt64(x2.e << y2);
    }

    public static boolean op_Equality(UInt64 x2, UInt64 y2) {
        return x2.e.equals(y2.e);
    }

    public static boolean op_Inequality(UInt64 x2, UInt64 y2) {
        return !x2.e.equals(y2.e);
    }

    public static boolean op_GreaterThan(UInt64 x2, UInt64 y2) {
        return UInt64.a(x2.e, y2.e) > 0;
    }

    public static boolean op_LessThan(UInt64 x2, UInt64 y2) {
        return UInt64.a(x2.e, y2.e) < 0;
    }

    public static boolean op_GreaterThanOrEqual(UInt64 x2, UInt64 y2) {
        return UInt64.a(x2.e, y2.e) >= 0;
    }

    public static boolean op_LessThanOrEqual(UInt64 x2, UInt64 y2) {
        return UInt64.a(x2.e, y2.e) <= 0;
    }

    public static int sizeOf() {
        return 8;
    }

    public byte[] toByteArray() {
        return BitConverter.getBytesUInt64(this.e);
    }

    public static UInt64 toUInt64(byte[] byteArray) {
        return new UInt64(BitConverter.toUInt64(byteArray, 0));
    }

    private static String a(long l2) {
        int n2;
        long l3 = l2 & Long.MAX_VALUE;
        if (l2 == l3) {
            return String.valueOf(l3);
        }
        String string = "-9223372036854775808";
        char[] cArray = string.toCharArray();
        cArray[0] = 48;
        for (n2 = cArray.length - 1; n2 != 0 && l3 != 0L; l3 /= 10L, --n2) {
            int n3 = n2;
            cArray[n3] = (char)((long)cArray[n3] + l3 % 10L);
            if (cArray[n3] <= '9') continue;
            int n4 = n2;
            cArray[n4] = (char)(cArray[n4] - 10);
            int n5 = n2 - 1;
            cArray[n5] = (char)(cArray[n5] + '\u0001');
        }
        n2 = 49 - cArray[0];
        return new String(cArray, n2, cArray.length - n2);
    }

    static {
        for (int i2 = 2; i2 <= 36; ++i2) {
            UInt64.a[i2] = UInt64.op_Division((UInt64)new UInt64((long)-1L), (UInt64)new UInt64((long)((long)i2))).e;
            UInt64.b[i2] = (int)UInt64.op_Modulus((UInt64)new UInt64((long)-1L), (UInt64)new UInt64((long)((long)i2))).e.longValue();
            UInt64.c[i2] = Long.toString(Long.MAX_VALUE, i2).length();
        }
        d = false;
        MaxValue = new UInt64(MaxValueString);
        MinValue = new UInt64(0L);
        OneValue = new UInt64(1L);
    }
}

