/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Text;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.Text.EncoderFallback;
import com.aspose.html.internal.ms.System.Text.EncoderFallbackBuffer;
import com.aspose.html.internal.ms.System.Text.EncoderReplacementFallback;

@SerializableAttribute
public abstract class Encoder {
    private EncoderFallback a = new EncoderReplacementFallback();
    private EncoderFallbackBuffer b;

    protected Encoder() {
    }

    public EncoderFallback getFallback() {
        return this.a;
    }

    public void setFallback(EncoderFallback value) {
        if (value == null) {
            throw new ArgumentNullException();
        }
        this.a = value;
        this.b = null;
    }

    public EncoderFallbackBuffer getFallbackBuffer() {
        if (this.b == null) {
            this.b = this.getFallback().createFallbackBuffer();
        }
        return this.b;
    }

    public abstract int getByteCount(char[] var1, int var2, int var3, boolean var4);

    public abstract int getBytes(char[] var1, int var2, int var3, byte[] var4, int var5, boolean var6);

    public void reset() {
        if (this.b != null) {
            this.b.reset();
        }
    }

    public void convert(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex, int byteCount, boolean flush, int[] charsUsed, int[] bytesUsed, boolean[] completed) {
        if (chars == null) {
            throw new ArgumentNullException("chars");
        }
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (charIndex < 0) {
            throw new ArgumentOutOfRangeException("charIndex");
        }
        if (charCount < 0 || chars.length < charIndex + charCount) {
            throw new ArgumentOutOfRangeException("charCount");
        }
        if (byteIndex < 0) {
            throw new ArgumentOutOfRangeException("byteIndex");
        }
        if (byteCount < 0 || bytes.length < byteIndex + byteCount) {
            throw new ArgumentOutOfRangeException("byteCount");
        }
        charsUsed[0] = charCount;
        if (charCount == 0 && byteCount == 0) {
            completed[0] = true;
            charsUsed[0] = 0;
            bytesUsed[0] = 0;
        }
        while (charsUsed[0] > 0) {
            if (this.getByteCount(chars, charIndex, charsUsed[0], flush) <= byteCount) {
                bytesUsed[0] = this.getBytes(chars, charIndex, charsUsed[0], bytes, byteIndex, flush);
                completed[0] = charsUsed[0] == charCount && (this.b == null || this.b.getRemaining() == 0);
                return;
            }
            flush = false;
            charsUsed[0] = charsUsed[0] / 2;
        }
    }
}

