/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.Collections.IDictionaryEnumerator;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Security.XmlSyntaxException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.b;

@SerializableAttribute
public final class SecurityElement {
    private String a;
    private String b;
    private ArrayList c;
    private ArrayList d;
    private static final char[] e = new char[]{' ', '<', '>'};
    private static final char[] f = new char[]{'<', '>'};
    private static final char[] g = new char[]{' ', '<', '>'};
    private static final char[] h = new char[]{'\"', '<', '>'};
    private static final char[] i = new char[]{'<', '>', '\"', '\'', '&'};

    public SecurityElement(String tag) {
        this(tag, null);
    }

    public SecurityElement(String tag, String text) {
        if (tag == null) {
            throw new ArgumentNullException("tag");
        }
        if (!SecurityElement.isValidTag(tag)) {
            throw new ArgumentException("Invalid XML string: " + tag);
        }
        this.b = tag;
        this.setText(text);
    }

    SecurityElement(SecurityElement se) {
        this.setTag(se.getTag());
        this.setText(se.getText());
        if (se.c != null) {
            for (Object object : se.c) {
                this.addAttribute(((SecurityAttribute)object).a(), ((SecurityAttribute)object).b());
            }
        }
        if (se.d != null) {
            for (Object object : se.d) {
                this.addChild((SecurityElement)object);
            }
        }
    }

    public Hashtable getAttributes() {
        if (this.c == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable(this.c.size());
        for (SecurityAttribute securityAttribute : this.c) {
            hashtable.addItem(securityAttribute.a(), securityAttribute.b());
        }
        return hashtable;
    }

    public void setAttributes(Hashtable value) {
        if (value == null || value.size() == 0) {
            this.c.clear();
            return;
        }
        if (this.c == null) {
            this.c = new ArrayList();
        } else {
            this.c.clear();
        }
        IDictionaryEnumerator iDictionaryEnumerator = value.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.c.addItem(new SecurityAttribute((String)iDictionaryEnumerator.getKey(), (String)iDictionaryEnumerator.getValue()));
        }
    }

    public ArrayList getChildren() {
        return this.d;
    }

    public void setChildren(ArrayList value) {
        if (value != null) {
            for (Object e2 : value) {
                if (e2 != null) continue;
                throw new ArgumentNullException();
            }
        }
        this.d = value;
    }

    public String getTag() {
        return this.b;
    }

    public void setTag(String value) {
        if (value == null) {
            throw new ArgumentNullException("Tag");
        }
        if (!SecurityElement.isValidTag(value)) {
            throw new ArgumentException("Invalid XML string: " + value);
        }
        this.b = value;
    }

    public String getText() {
        return this.a;
    }

    public void setText(String value) {
        if (value != null && !SecurityElement.isValidText(value)) {
            throw new ArgumentException("Invalid XML string: " + value);
        }
        this.a = SecurityElement.c(value);
    }

    public void addAttribute(String name, String value) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (this.a(name) != null) {
            throw new ArgumentException(StringExtensions.concat("Duplicate attribute : ", name));
        }
        if (this.c == null) {
            this.c = new ArrayList();
        }
        this.c.addItem(new SecurityAttribute(name, value));
    }

    public void addChild(SecurityElement child) {
        if (child == null) {
            throw new ArgumentNullException("child");
        }
        if (this.d == null) {
            this.d = new ArrayList();
        }
        this.d.addItem(child);
    }

    public String attribute(String name) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        SecurityAttribute securityAttribute = this.a(name);
        return securityAttribute == null ? null : securityAttribute.b();
    }

    public SecurityElement copy() {
        return new SecurityElement(this);
    }

    public boolean equal(SecurityElement other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!StringExtensions.equals(this.a, other.a)) {
            return false;
        }
        if (!StringExtensions.equals(this.b, other.b)) {
            return false;
        }
        if (this.c == null && other.c != null && other.c.size() != 0) {
            return false;
        }
        if (other.c == null && this.c != null && this.c.size() != 0) {
            return false;
        }
        if (this.c != null && other.c != null) {
            if (this.c.size() != other.c.size()) {
                return false;
            }
            for (SecurityAttribute securityAttribute : this.c) {
                SecurityAttribute securityAttribute2 = other.a(securityAttribute.a());
                if (securityAttribute2 != null && StringExtensions.equals(securityAttribute.b(), securityAttribute2.b())) continue;
                return false;
            }
        }
        if (this.d == null && other.d != null && other.d.size() != 0) {
            return false;
        }
        if (other.d == null && this.d != null && this.d.size() != 0) {
            return false;
        }
        if (this.d != null && other.d != null) {
            if (this.d.size() != other.d.size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.d.size(); ++i2) {
                if (((SecurityElement)this.d.get_Item(i2)).equal((SecurityElement)other.d.get_Item(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        if (StringExtensions.indexOfAny(str, i) == -1) {
            return str;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = str.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '<': {
                    msStringBuilder2.append("&lt;");
                    continue block7;
                }
                case '>': {
                    msStringBuilder2.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    msStringBuilder2.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    msStringBuilder2.append("&apos;");
                    continue block7;
                }
                case '&': {
                    msStringBuilder2.append("&amp;");
                    continue block7;
                }
                default: {
                    msStringBuilder2.append(c2);
                }
            }
        }
        return msStringBuilder2.toString();
    }

    private static String c(String string) {
        if (string == null) {
            return null;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder(string);
        msStringBuilder2.replace("&lt;", "<");
        msStringBuilder2.replace("&gt;", ">");
        msStringBuilder2.replace("&amp;", "&");
        msStringBuilder2.replace("&quot;", "\"");
        msStringBuilder2.replace("&apos;", "'");
        return msStringBuilder2.toString();
    }

    public static SecurityElement fromString(String xml) {
        if (xml == null) {
            throw new ArgumentNullException("xml");
        }
        if (xml.length() == 0) {
            throw new XmlSyntaxException("Empty string.");
        }
        try {
            b b2 = new b();
            b2.d(xml);
            return b2.a();
        }
        catch (Exception exception) {
            String string = "Invalid XML.";
            throw new XmlSyntaxException(string, exception);
        }
    }

    public static boolean isValidAttributeName(String name) {
        return name != null && StringExtensions.indexOfAny(name, g) == -1;
    }

    public static boolean isValidAttributeValue(String value) {
        return value != null && StringExtensions.indexOfAny(value, h) == -1;
    }

    public static boolean isValidTag(String tag) {
        return tag != null && StringExtensions.indexOfAny(tag, e) == -1;
    }

    public static boolean isValidText(String text) {
        return text != null && StringExtensions.indexOfAny(text, f) == -1;
    }

    public SecurityElement searchForChildByTag(String tag) {
        if (tag == null) {
            throw new ArgumentNullException("tag");
        }
        if (this.d == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            SecurityElement securityElement = (SecurityElement)this.d.get_Item(i2);
            if (!StringExtensions.equals(securityElement.b, tag)) continue;
            return securityElement;
        }
        return null;
    }

    public String searchForTextOfTag(String tag) {
        if (tag == null) {
            throw new ArgumentNullException("tag");
        }
        if (StringExtensions.equals(this.b, tag)) {
            return this.a;
        }
        if (this.d == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            String string = ((SecurityElement)this.d.get_Item(i2)).searchForTextOfTag(tag);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder[] msStringBuilderArray = new msStringBuilder[]{msStringBuilder2};
        this.a(msStringBuilderArray, 0);
        msStringBuilder2 = msStringBuilderArray[0];
        return msStringBuilder2.toString();
    }

    private void a(msStringBuilder[] msStringBuilderArray, int n2) {
        msStringBuilderArray[0].append("<");
        msStringBuilderArray[0].append(this.b);
        if (this.c != null) {
            msStringBuilderArray[0].append(" ");
            for (int i2 = 0; i2 < this.c.size(); ++i2) {
                Object object = (SecurityAttribute)this.c.get_Item(i2);
                msStringBuilderArray[0].append(((SecurityAttribute)object).a()).append("=\"").append(SecurityElement.escape(((SecurityAttribute)object).b())).append("\"");
                if (i2 == this.c.size() - 1) continue;
                msStringBuilderArray[0].append(Environment.NewLine);
            }
        }
        if (!(this.a != null && !StringExtensions.equals(this.a, StringExtensions.Empty) || this.d != null && this.d.size() != 0)) {
            msStringBuilderArray[0].append("/>").append(Environment.NewLine);
        } else {
            msStringBuilderArray[0].append(">").append(SecurityElement.escape(this.a));
            if (this.d != null) {
                msStringBuilderArray[0].append(Environment.NewLine);
                for (Object object : this.d) {
                    super.a(msStringBuilderArray, n2 + 1);
                }
            }
            msStringBuilderArray[0].append("</").append(this.b).append(">").append(Environment.NewLine);
        }
    }

    SecurityAttribute a(String string) {
        if (this.c != null) {
            for (SecurityAttribute securityAttribute : this.c) {
                if (!StringExtensions.equals(securityAttribute.a(), string)) continue;
                return securityAttribute;
            }
        }
        return null;
    }

    static class SecurityAttribute {
        private String a;
        private String b;

        public SecurityAttribute(String name, String value) {
            if (!SecurityElement.isValidAttributeName(name)) {
                throw new ArgumentException("Invalid XML attribute name: " + name);
            }
            if (!SecurityElement.isValidAttributeValue(value)) {
                throw new ArgumentException("Invalid XML attribute value: " + value);
            }
            this.a = name;
            this.b = SecurityElement.c(value);
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return this.b;
        }
    }
}

