/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.EnumExtensions;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.StoreName;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Collection;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509StoreManager;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.k;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.l;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public final class X509Store {
    private String a;
    private int b;
    private X509Certificate2Collection c;
    private int d;
    private k e;
    private static final StringSwitchMap f = new StringSwitchMap("Root");

    public X509Store() {
        this("MY", 1);
    }

    public X509Store(String storeName) {
        this(storeName, 1);
    }

    public X509Store(short storeName) {
        this(storeName, 1);
    }

    public X509Store(int storeLocation) {
        this("MY", storeLocation);
    }

    public X509Store(short storeName, int storeLocation) {
        if (storeName < 1 || storeName > 8) {
            throw new ArgumentException("storeName");
        }
        if (storeLocation < 1 || storeLocation > 2) {
            throw new ArgumentException("storeLocation");
        }
        switch (storeName) {
            case 3: {
                this.a = "CA";
                break;
            }
            default: {
                this.a = EnumExtensions.toString(StoreName.class, storeName);
            }
        }
        this.b = storeLocation;
    }

    public X509Store(String storeName, int storeLocation) {
        if (storeLocation < 1 || storeLocation > 2) {
            throw new ArgumentException("storeLocation");
        }
        this.a = storeName;
        this.b = storeLocation;
    }

    public X509Certificate2Collection getCertificates() {
        if (this.c == null) {
            this.c = new X509Certificate2Collection();
        } else if (this.e == null) {
            this.c.clear();
        }
        return this.c;
    }

    public int getLocation() {
        return this.b;
    }

    public String getName() {
        return this.a;
    }

    private l a() {
        if (this.b == 1) {
            return X509StoreManager.getCurrentUser();
        }
        return X509StoreManager.getLocalMachine();
    }

    private boolean b() {
        return this.e != null;
    }

    private boolean c() {
        return (this.d & 1) == 0;
    }

    public k getStore() {
        return this.e;
    }

    public IntPtr getStoreHandle() {
        return IntPtr.Zero;
    }

    public void add(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        if (!this.b()) {
            throw new CryptographicException(StringExtensions.format("Store isn't opened.", new Object[0]));
        }
        if (this.c()) {
            throw new CryptographicException(StringExtensions.format("Store is read-only.", new Object[0]));
        }
        if (!this.b(certificate)) {
            try {
                if (certificate.getInternalCertificate() == null) {
                    throw new CryptographicException("Input data cannot be coded as a valid certificate.");
                }
                this.e.a(certificate.getInternalCertificate());
            }
            finally {
                this.getCertificates().add(certificate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        if (certificates.size() == 0) {
            return;
        }
        if (!this.b()) {
            throw new CryptographicException(StringExtensions.format("Store isn't opened.", new Object[0]));
        }
        if (this.c()) {
            throw new CryptographicException(StringExtensions.format("Store is read-only.", new Object[0]));
        }
        for (X509Certificate2 x509Certificate2 : certificates) {
            if (this.b(x509Certificate2)) continue;
            try {
                if (x509Certificate2.getInternalCertificate() == null) {
                    throw new CryptographicException("Input data cannot be coded as a valid certificate.");
                }
                this.e.a(x509Certificate2.getInternalCertificate());
            }
            finally {
                this.getCertificates().add(x509Certificate2);
            }
        }
    }

    public void close() {
        this.e = null;
        if (this.c != null) {
            this.c.clear();
        }
    }

    public void open(int flags) {
        String string;
        if (StringExtensions.isNullOrEmpty(this.a)) {
            throw new CryptographicException(StringExtensions.format("Invalid store name (null or empty).", new Object[0]));
        }
        switch (f.of(this.a)) {
            case 0: {
                string = "Trust";
                break;
            }
            default: {
                string = this.a;
            }
        }
        boolean bl2 = (flags & 4) != 4;
        this.e = this.a().a(string, bl2);
        if (this.e == null) {
            throw new CryptographicException(StringExtensions.format("Store {0} doesn't exists.", this.a));
        }
        this.d = flags;
        for (X509Certificate x509Certificate : this.e.a()) {
            X509Certificate2 x509Certificate2 = new X509Certificate2(x509Certificate.getRawData());
            x509Certificate2.setPrivateKey(x509Certificate.getRSA());
            this.getCertificates().add(x509Certificate2);
        }
    }

    public void remove(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        if (!this.b()) {
            throw new CryptographicException(StringExtensions.format("Store isn't opened.", new Object[0]));
        }
        if (!this.a(certificate)) {
            return;
        }
        if (this.c()) {
            throw new CryptographicException(StringExtensions.format("Store is read-only.", new Object[0]));
        }
        try {
            this.e.b(new X509Certificate(certificate.getRawData()));
        }
        finally {
            this.getCertificates().remove(certificate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        if (certificates.size() == 0) {
            return;
        }
        if (!this.b()) {
            throw new CryptographicException(StringExtensions.format("Store isn't opened.", new Object[0]));
        }
        boolean bl2 = false;
        for (X509Certificate2 x509Certificate2 : certificates) {
            if (!this.a(x509Certificate2)) continue;
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        if (this.c()) {
            throw new CryptographicException(StringExtensions.format("Store is read-only.", new Object[0]));
        }
        try {
            for (X509Certificate2 x509Certificate2 : certificates) {
                this.e.b(new X509Certificate(x509Certificate2.getRawData()));
            }
        }
        finally {
            this.getCertificates().removeRange(certificates);
        }
    }

    private boolean a(X509Certificate2 x509Certificate2) {
        if (this.e == null || this.c == null || x509Certificate2 == null) {
            return false;
        }
        for (X509Certificate2 x509Certificate22 : this.c) {
            if (!x509Certificate2.equals(x509Certificate22)) continue;
            return true;
        }
        return false;
    }

    private boolean b(X509Certificate2 x509Certificate2) {
        if (this.e == null || this.c == null || x509Certificate2 == null) {
            return false;
        }
        X509Certificate2 x509Certificate22 = null;
        for (X509Certificate2 x509Certificate23 : this.c) {
            if (!x509Certificate2.equals(x509Certificate23)) continue;
            if (x509Certificate2.hasPrivateKey() == x509Certificate23.hasPrivateKey()) {
                return true;
            }
            x509Certificate22 = x509Certificate23;
        }
        if (x509Certificate22 != null) {
            this.remove(x509Certificate22);
        }
        return false;
    }
}

