/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509BasicConstraintsExtension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509EnhancedKeyUsageExtension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ExtensionEnumerator;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509KeyUsageExtension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public final class X509ExtensionCollection
implements ICollection,
IEnumerable {
    static byte[] a = new byte[0];
    private ArrayList b;
    private static final StringSwitchMap c = new StringSwitchMap("2.5.29.14", "2.5.29.15", "2.5.29.19", "2.5.29.37");

    public X509ExtensionCollection() {
        this.b = new ArrayList();
    }

    public X509ExtensionCollection(X509Certificate cert) {
        this.b = new ArrayList(cert.getExtensions().size());
        if (cert.getExtensions().size() == 0) {
            return;
        }
        Object[] objectArray = new Object[2];
        for (com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Extension x509Extension : cert.getExtensions()) {
            boolean bl2 = x509Extension.getCritical();
            String string = x509Extension.getOid();
            byte[] byArray = null;
            ASN1 aSN1 = x509Extension.getValue();
            byArray = Operators.castToInt32(aSN1.getTag(), 6) == 4 && aSN1.getCount() > 0 ? aSN1.get_Item(0).getBytes() : aSN1.getBytes();
            X509Extension x509Extension2 = null;
            switch (c.of(string)) {
                case 0: {
                    x509Extension2 = new X509SubjectKeyIdentifierExtension(new AsnEncodedData(string, byArray), bl2);
                    break;
                }
                case 1: {
                    x509Extension2 = new X509KeyUsageExtension(new AsnEncodedData(string, byArray), bl2);
                    break;
                }
                case 2: {
                    x509Extension2 = new X509BasicConstraintsExtension(new AsnEncodedData(string, byArray), bl2);
                    break;
                }
                case 3: {
                    x509Extension2 = new X509EnhancedKeyUsageExtension(new AsnEncodedData(string, byArray), bl2);
                }
            }
            if (x509Extension2 == null) {
                byte[] byArray2 = byArray;
                if (byArray2 == null) {
                    byArray2 = a;
                }
                x509Extension2 = new X509Extension(string, byArray2, bl2);
            }
            this.b.addItem(x509Extension2);
        }
    }

    @Override
    public int size() {
        return this.b.size();
    }

    @Override
    public boolean isSynchronized() {
        return this.b.isSynchronized();
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public X509Extension get_Item(int index) {
        if (index < 0) {
            throw new InvalidOperationException("index");
        }
        return (X509Extension)this.b.get_Item(index);
    }

    public X509Extension get_Item(String oid) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        if (this.b.size() == 0 || oid.length() == 0) {
            return null;
        }
        for (X509Extension x509Extension : this.b) {
            if (!StringExtensions.equals(x509Extension.getOid().getValue(), oid)) continue;
            return x509Extension;
        }
        return null;
    }

    public int add(X509Extension extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        return this.b.addItem(extension);
    }

    public void copyTo(X509Extension[] array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (index >= array.length) {
            throw new ArgumentOutOfRangeException("index >= array.Length");
        }
        this.b.copyTo(Array.boxing(array), index);
    }

    @Override
    public void copyTo(Array array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (index >= array.getLength()) {
            throw new ArgumentOutOfRangeException("index >= array.Length");
        }
        this.b.copyTo(array, index);
    }

    public X509ExtensionEnumerator iterator() {
        return new X509ExtensionEnumerator(this.b);
    }
}

