/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Security.Cryptography.DeriveBytes;
import com.aspose.html.internal.ms.System.Security.Cryptography.HMACSHA1;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.l;

public class Rfc2898DeriveBytes
extends DeriveBytes {
    private static final int a = 1000;
    private int b;
    private byte[] c;
    private HMACSHA1 d;
    private byte[] e;
    private int f;
    private int g;

    public Rfc2898DeriveBytes(String password, byte[] salt) {
        this(password, salt, 1000);
    }

    public Rfc2898DeriveBytes(String password, byte[] salt, int iterations) {
        if (password == null) {
            throw new ArgumentNullException("password");
        }
        this.setSalt(salt);
        this.setIterationCount(iterations);
        this.d = new HMACSHA1(Encoding.getUTF8().getBytes(password));
    }

    public Rfc2898DeriveBytes(byte[] password, byte[] salt, int iterations) {
        if (password == null) {
            throw new ArgumentNullException("password");
        }
        this.setSalt(salt);
        this.setIterationCount(iterations);
        this.d = new HMACSHA1(password);
    }

    public Rfc2898DeriveBytes(String password, int saltSize) {
        this(password, saltSize, 1000);
    }

    public Rfc2898DeriveBytes(String password, int saltSize, int iterations) {
        if (password == null) {
            throw new ArgumentNullException("password");
        }
        if (saltSize < 0) {
            throw new ArgumentOutOfRangeException("saltSize", "invalid salt length");
        }
        this.setSalt(l.a(saltSize));
        this.setIterationCount(iterations);
        this.d = new HMACSHA1(Encoding.getUTF8().getBytes(password));
    }

    public int getIterationCount() {
        return this.b;
    }

    public void setIterationCount(int value) {
        if (value < 1) {
            throw new ArgumentOutOfRangeException("value", "IterationCount < 1");
        }
        this.b = value;
    }

    public byte[] getSalt() {
        return (byte[])this.c.clone();
    }

    public void setSalt(byte[] value) {
        if (value == null) {
            throw new ArgumentNullException("Salt");
        }
        if (value.length < 8) {
            throw new ArgumentException("Salt < 8 bytes");
        }
        this.c = (byte[])value.clone();
    }

    private byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        byArray[byArray.length - 4] = (byte)(n3 >> 24);
        byArray[byArray.length - 3] = (byte)(n3 >> 16);
        byArray[byArray.length - 2] = (byte)(n3 >> 8);
        byArray[byArray.length - 1] = (byte)n3;
        byte[] byArray3 = byArray2 = this.d.computeHash(byArray);
        for (int i2 = 1; i2 < n2; ++i2) {
            byte[] byArray4 = this.d.computeHash(byArray3);
            for (int i3 = 0; i3 < 20; ++i3) {
                byArray2[i3] = (byte)(byArray2[i3] & 0xFF ^ byArray4[i3] & 0xFF);
            }
            byArray3 = byArray4;
        }
        return byArray2;
    }

    @Override
    public byte[] getBytes(int cb2) {
        if (cb2 < 1) {
            throw new ArgumentOutOfRangeException("cb");
        }
        int n2 = cb2 / 20;
        int n3 = cb2 % 20;
        if (n3 != 0) {
            ++n2;
        }
        byte[] byArray = new byte[cb2];
        int n4 = 0;
        if (this.f > 0) {
            int n5 = Math.min(20 - this.f, cb2);
            Buffer.blockCopy(Array.boxing(this.e), this.f, Array.boxing(byArray), 0, n5);
            if (n5 >= cb2) {
                return byArray;
            }
            if ((n2 - 1) * 20 + n5 > byArray.length) {
                --n2;
            }
            this.f = 0;
            n4 = n5;
        }
        byte[] byArray2 = new byte[this.c.length + 4];
        Buffer.blockCopy(Array.boxing(this.c), 0, Array.boxing(byArray2), 0, this.c.length);
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.e = this.a(byArray2, this.b, ++this.g);
            int n6 = i2 == n2 ? byArray.length - n4 : 20;
            Buffer.blockCopy(Array.boxing(this.e), this.f, Array.boxing(byArray), n4, n6);
            n4 += this.f + n6;
            this.f = n6 == 20 ? 0 : n6;
        }
        return byArray;
    }

    @Override
    public void reset() {
        this.e = null;
        this.f = 0;
        this.g = 0;
    }
}

