/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.EventArgs;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricKeyExchangeDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricKeyExchangeFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspKeyContainerInfo;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICspAsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAOAEPKeyExchangeFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.internal.ms.System.bc.BouncyCastleProviderHelper;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.RSAManaged;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.e;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.m;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.s;
import com.aspose.html.internal.ms.core.logger.Log4jLogger;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;

public final class RSACryptoServiceProvider
extends RSA
implements ICspAsymmetricAlgorithm {
    private static final int a = 1;
    private m b;
    private boolean c;
    private boolean d;
    private boolean e = true;
    private boolean f;
    private RSAManaged g;
    private static final StringSwitchMap h = new StringSwitchMap("1.3.14.3.2.26", "1.2.840.113549.2.5", "2.16.840.1.101.3.4.2.1", "2.16.840.1.101.3.4.2.2", "2.16.840.1.101.3.4.2.3");
    private PrivateKey i;

    public RSACryptoServiceProvider() {
        this.a(1024, (CspParameters)null);
    }

    public RSACryptoServiceProvider(CspParameters parameters) {
        this.a(1024, parameters);
    }

    public RSACryptoServiceProvider(int dwKeySize) {
        this.a(dwKeySize, (CspParameters)null);
    }

    public RSACryptoServiceProvider(int dwKeySize, CspParameters parameters) {
        this.a(dwKeySize, parameters);
    }

    private void a(int n2, CspParameters cspParameters) {
        this.LegalKeySizesValue = new KeySizes[1];
        this.LegalKeySizesValue[0] = new KeySizes(384, 16384, 8);
        super.setKeySize(n2);
        this.g = new RSAManaged(this.getKeySize());
        this.g.KeyGenerated.add(new RSAManaged.a(){

            @Override
            public void a(Object object, EventArgs eventArgs) {
                RSACryptoServiceProvider.this.a(object, eventArgs);
            }
        });
        boolean bl2 = this.c = cspParameters != null;
        if (cspParameters == null) {
            cspParameters = new CspParameters(1);
            this.b = new m(cspParameters);
        } else {
            boolean bl3;
            this.b = new m(cspParameters);
            boolean bl4 = this.b.d();
            boolean bl5 = bl3 = (cspParameters.getFlags() & 8) != 0;
            if (bl3 && !bl4) {
                throw new CryptographicException("Keyset does not exist");
            }
            if (this.b.b() != null) {
                this.d = true;
                this.fromXmlString(this.b.b());
            }
        }
    }

    @Override
    public String getKeyExchangeAlgorithm() {
        return "RSA-PKCS1-KeyEx";
    }

    @Override
    public int getKeySize() {
        if (this.g == null) {
            return this.KeySizeValue;
        }
        return this.g.getKeySize();
    }

    public boolean getPersistKeyInCsp() {
        return this.c;
    }

    public void setPersistKeyInCsp(boolean value) {
        this.c = value;
        if (this.c) {
            this.a(this.g, null);
        }
    }

    public boolean getPublicOnly() {
        return this.g.getPublicOnly() && this.i == null;
    }

    @Override
    public String getSignatureAlgorithm() {
        return "https://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd#rsa-sha1";
    }

    public byte[] decrypt(byte[] rgb, boolean fOAEP) {
        AsymmetricKeyExchangeDeformatter asymmetricKeyExchangeDeformatter = null;
        asymmetricKeyExchangeDeformatter = fOAEP ? new RSAOAEPKeyExchangeDeformatter(this.g) : new RSAPKCS1KeyExchangeDeformatter(this.g);
        return asymmetricKeyExchangeDeformatter.decryptKeyExchange(rgb);
    }

    @Override
    public byte[] decryptValue(byte[] rgb) {
        if (!this.g.isCrtPossible()) {
            throw new CryptographicException("Incomplete private key - missing CRT.");
        }
        return this.g.decryptValue(rgb);
    }

    public byte[] encrypt(byte[] rgb, boolean fOAEP) {
        AsymmetricKeyExchangeFormatter asymmetricKeyExchangeFormatter = null;
        asymmetricKeyExchangeFormatter = fOAEP ? new RSAOAEPKeyExchangeFormatter(this.g) : new RSAPKCS1KeyExchangeFormatter(this.g);
        return asymmetricKeyExchangeFormatter.createKeyExchange(rgb);
    }

    @Override
    public byte[] encryptValue(byte[] rgb) {
        return this.g.encryptValue(rgb);
    }

    @Override
    public RSAParameters exportParameters(boolean includePrivateParameters) {
        if (includePrivateParameters && !this.e) {
            throw new CryptographicException("cannot export private key");
        }
        return this.g.exportParameters(includePrivateParameters);
    }

    @Override
    public void importParameters(RSAParameters parameters) {
        this.g.importParameters(parameters.Clone());
    }

    private HashAlgorithm a(Object object) {
        if (object == null) {
            throw new ArgumentNullException("halg");
        }
        HashAlgorithm hashAlgorithm = null;
        if (object instanceof String) {
            hashAlgorithm = HashAlgorithm.create((String)object);
        } else if (object instanceof HashAlgorithm) {
            hashAlgorithm = (HashAlgorithm)object;
        } else if (object instanceof Class) {
            try {
                hashAlgorithm = (HashAlgorithm)((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            throw new ArgumentException("halg");
        }
        return hashAlgorithm;
    }

    public byte[] signData(byte[] buffer, Object halg) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        return this.signData(buffer, 0, buffer.length, halg);
    }

    public byte[] signData(Stream inputStream, Object halg) {
        HashAlgorithm hashAlgorithm = this.a(halg);
        byte[] byArray = hashAlgorithm.computeHash(inputStream);
        return s.b(this, hashAlgorithm, byArray);
    }

    public byte[] signData(byte[] buffer, int offset, int count, Object halg) {
        HashAlgorithm hashAlgorithm = this.a(halg);
        byte[] byArray = hashAlgorithm.computeHash(buffer, offset, count);
        return s.b(this, hashAlgorithm, byArray);
    }

    private String a(String string) {
        switch (h.of(string)) {
            case 0: {
                return "SHA1";
            }
            case 1: {
                return "MD5";
            }
            case 2: {
                return "SHA256";
            }
            case 3: {
                return "SHA384";
            }
            case 4: {
                return "SHA512";
            }
        }
        throw new CryptographicException(string + " is an unsupported hash algorithm for RSA signing");
    }

    public byte[] signHash(byte[] rgbHash, String str) {
        if (rgbHash == null) {
            throw new ArgumentNullException("rgbHash");
        }
        String string = str == null ? "SHA1" : this.a(str);
        HashAlgorithm hashAlgorithm = HashAlgorithm.create(string);
        return s.b(this, hashAlgorithm, rgbHash);
    }

    public boolean verifyData(byte[] buffer, Object halg, byte[] signature) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (signature == null) {
            throw new ArgumentNullException("signature");
        }
        HashAlgorithm hashAlgorithm = this.a(halg);
        byte[] byArray = hashAlgorithm.computeHash(buffer);
        return s.a((RSA)this, hashAlgorithm, byArray, signature);
    }

    public boolean verifyHash(byte[] rgbHash, String str, byte[] rgbSignature) {
        if (rgbHash == null) {
            throw new ArgumentNullException("rgbHash");
        }
        if (rgbSignature == null) {
            throw new ArgumentNullException("rgbSignature");
        }
        String string = str == null ? "SHA1" : this.a(str);
        HashAlgorithm hashAlgorithm = HashAlgorithm.create(string);
        return s.a((RSA)this, hashAlgorithm, rgbHash, rgbSignature);
    }

    @Override
    protected void dispose(boolean disposing) {
        if (!this.f) {
            if (this.d && !this.c) {
                this.b.f();
            }
            if (this.g != null) {
                this.g.clear();
            }
            this.f = true;
        }
    }

    private void a(Object object, EventArgs eventArgs) {
        if (this.c && !this.d) {
            this.b.a(this.toXmlString(!this.g.getPublicOnly()));
            this.b.e();
            this.d = true;
        }
    }

    @Override
    public CspKeyContainerInfo getCspKeyContainerInfo() {
        return new CspKeyContainerInfo(this.b.c());
    }

    @Override
    public byte[] exportCspBlob(boolean includePrivateParameters) {
        byte[] byArray = null;
        byArray = includePrivateParameters ? com.aspose.html.internal.ms.core.System.Security.Cryptography.e.a(this) : com.aspose.html.internal.ms.core.System.Security.Cryptography.e.b(this);
        byArray[5] = -92;
        return byArray;
    }

    @Override
    public void importCspBlob(byte[] keyBlob) {
        if (keyBlob == null) {
            throw new ArgumentNullException("keyBlob");
        }
        RSA rSA = com.aspose.html.internal.ms.core.System.Security.Cryptography.e.e(keyBlob);
        if (rSA instanceof RSACryptoServiceProvider) {
            RSAParameters rSAParameters = rSA.exportParameters(!((RSACryptoServiceProvider)rSA).getPublicOnly()).Clone();
            this.importParameters(rSAParameters.Clone());
        } else {
            try {
                RSAParameters rSAParameters = rSA.exportParameters(true).Clone();
                this.importParameters(rSAParameters.Clone());
            }
            catch (Exception exception) {
                RSAParameters rSAParameters = rSA.exportParameters(false).Clone();
                this.importParameters(rSAParameters.Clone());
            }
        }
    }

    public void setJavaPrivateKey(PrivateKey javaPrivateKey) {
        this.c = true;
        this.i = javaPrivateKey;
    }

    protected boolean hasJavaPrivateKey() {
        return this.i != null;
    }

    protected byte[] signDataSHA1withRSA(byte[] data) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(this.i);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception exception) {
            Log4jLogger.debug(exception.toString(), exception);
            return null;
        }
    }

    protected byte[] signDataNoneWithRSA(byte[] data) {
        try {
            Provider provider = BouncyCastleProviderHelper.getBCProvider();
            Signature signature = Signature.getInstance("NONEwithRSA", provider);
            signature.initSign(this.i);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception exception) {
            Log4jLogger.debug(exception.toString(), exception);
            return null;
        }
    }
}

