/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicAttributeObjectCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.CmsSigner;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.SignerInfoCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.SubjectIdentifier;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformation;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformationVerifier;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.security.a;
import java.security.cert.CertificateException;

public final class SignerInfo {
    private SubjectIdentifier a;
    private X509Certificate2 b;
    private Oid c;
    private SignerInfoCollection d;
    private CryptographicAttributeObjectCollection e;
    private CryptographicAttributeObjectCollection f;
    private int g;
    private SignerInformation h;

    SignerInfo(SubjectIdentifier signer, X509Certificate2 certificate, Oid digest, SignerInfoCollection counter, CryptographicAttributeObjectCollection signed, CryptographicAttributeObjectCollection unsigned, int version, SignerInformation si) {
        this.a = signer;
        this.b = certificate;
        this.c = digest;
        this.d = counter;
        this.e = signed;
        this.f = unsigned;
        this.g = version;
        this.h = si;
    }

    public CryptographicAttributeObjectCollection getSignedAttributes() {
        return this.e;
    }

    public X509Certificate2 getCertificate() {
        return this.b;
    }

    public SignerInfoCollection getCounterSignerInfos() {
        return this.d;
    }

    public Oid getDigestAlgorithm() {
        return this.c;
    }

    public SubjectIdentifier getSignerIdentifier() {
        return this.a;
    }

    public CryptographicAttributeObjectCollection getUnsignedAttributes() {
        return this.f;
    }

    public int getVersion() {
        return this.g;
    }

    public void checkHash() {
    }

    public void checkSignature(boolean verifySignatureOnly) {
        try {
            SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().build(com.aspose.html.internal.ms.core.bc.security.a.a(this.b));
            this.h.verify(signerInformationVerifier);
        }
        catch (CMSException cMSException) {
            throw new CryptographicException(cMSException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new CryptographicException(certificateException.getMessage());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CryptographicException(operatorCreationException.getMessage());
        }
    }

    public void computeCounterSignature() {
        throw new NotSupportedException("This requires that the current process is running in user interactive mode. Try to use ComputeCounterSignature(CmsSigner) method.");
    }

    public void computeCounterSignature(CmsSigner signer) {
        if (signer == null) {
            throw new ArgumentNullException("signer");
        }
        throw new NotImplementedException();
    }

    public void removeCounterSignature(SignerInfo counterSignerInfo) {
        throw new NotImplementedException();
    }

    public void removeCounterSignature(int index) {
        if (index < 0 || index >= this.d.size()) {
            throw new ArgumentException("index was out of range");
        }
        this.removeCounterSignature(this.d.get_Item(index));
    }
}

