/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricSignatureDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public class DSASignatureDeformatter
extends AsymmetricSignatureDeformatter {
    private DSA a;

    public DSASignatureDeformatter() {
    }

    public DSASignatureDeformatter(AsymmetricAlgorithm key) {
        this.setKey(key);
    }

    @Override
    public void setHashAlgorithm(String strName) {
        if (strName == null) {
            throw new ArgumentNullException("strName");
        }
        try {
            SHA1.create(strName);
        }
        catch (ClassCastException classCastException) {
            throw new CryptographicUnexpectedOperationException(n.a("DSA requires SHA1"));
        }
    }

    @Override
    public void setKey(AsymmetricAlgorithm key) {
        if (key == null) {
            throw new ArgumentNullException("key");
        }
        this.a = (DSA)key;
    }

    @Override
    public boolean verifySignature(byte[] rgbHash, byte[] rgbSignature) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException(n.a("missing key"));
        }
        return this.a.verifySignature(rgbHash, rgbSignature);
    }
}

