/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Reflection;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.FileNotFoundException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.Reflection.AssemblyName;
import com.aspose.html.internal.ms.System.Reflection.CustomAttribute;
import com.aspose.html.internal.ms.System.Reflection.ICustomAttributeProvider;
import com.aspose.html.internal.ms.System.Reflection.Module;
import com.aspose.html.internal.ms.System.Reflection.RuntimeType;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.core.logger.Log4jLogger;
import com.aspose.html.internal.ms.lang.Operators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;

@SerializableAttribute
public class Assembly
implements ICustomAttributeProvider {
    private static Assembly a = new Assembly();
    private Class b;

    private Assembly() {
        this.b = this.getClass();
    }

    private Assembly(Class aClass) {
        this.b = aClass;
    }

    public static Assembly getExecutingAssembly() {
        return a;
    }

    public static Assembly getAssembly(Type type) {
        if (type == null) {
            throw new ArgumentNullException("type");
        }
        return new Assembly(type.getJavaClass());
    }

    public Stream getManifestResourceStream(String name) {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            return MemoryStream.fromInputStream(inputStream);
        }
        catch (IOException iOException) {
            Log4jLogger.debug(iOException.toString());
            return null;
        }
    }

    public Stream getManifestResourceStream(Type resourceSource, String name) {
        try {
            return MemoryStream.fromInputStream(resourceSource.getJavaClass().getResourceAsStream(name));
        }
        catch (IOException iOException) {
            Log4jLogger.debug(iOException.toString());
            return null;
        }
    }

    public File getManifestResourceFile(String uri) throws URISyntaxException {
        return new File(new URI(this.getClass().getClassLoader().getResource(uri).toString()));
    }

    public String[] getManifestResourceNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("com/aspose/metadata/resources/");
            while (enumeration.hasMoreElements()) {
                try {
                    URL uRL = enumeration.nextElement();
                    linkedHashSet.add(uRL.getFile());
                }
                catch (Exception exception) {
                    Log4jLogger.debug(exception.toString());
                }
            }
        }
        catch (Exception exception) {
            Log4jLogger.debug(exception.toString());
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public AssemblyName getName() {
        throw new NotImplementedException();
    }

    public String getFullName() {
        return "MS";
    }

    public Module[] getModules() {
        throw new NotImplementedException();
    }

    public Module getModule(String name) {
        if (name == null) {
            throw new ArgumentNullException();
        }
        if ("".equals(name)) {
            throw new ArgumentException();
        }
        for (Module module : this.getModules()) {
            if (!module.getScopeName().equals(name)) continue;
            return module;
        }
        throw new FileNotFoundException();
    }

    @Override
    public Object[] getCustomAttributes(boolean inherit) {
        return CustomAttribute.a(this, Operators.typeOf(Object.class));
    }

    @Override
    public Object[] getCustomAttributes(Type attributeType, boolean inherit) {
        if (attributeType == null) {
            throw new ArgumentNullException("attributeType");
        }
        RuntimeType runtimeType = Operators.as(attributeType.getUnderlyingSystemType(), RuntimeType.class);
        if (runtimeType == null) {
            throw new ArgumentException("Type must be a type provided by the runtime.", "attributeType");
        }
        return CustomAttribute.a(this, (Type)runtimeType);
    }

    @Override
    public boolean isDefined(Type attributeType, boolean inherit) {
        throw new NotImplementedException();
    }

    public Type[] getTypes() {
        throw new NotImplementedException();
    }

    public Type[] getExportedTypes() {
        throw new NotImplementedException();
    }

    public Type getType(String name, boolean throwOnError, boolean ignoreCase) {
        throw new NotImplementedException();
    }

    public Type getType(String name, boolean throwOnError) {
        return this.getType(name, throwOnError, false);
    }

    public Type getType(String name) {
        return this.getType(name, false, false);
    }

    public String getLocation() {
        try {
            return new File(this.b.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            Log4jLogger.debug(uRISyntaxException.toString(), uRISyntaxException);
            return null;
        }
    }
}

