/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Mail;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Net.Mail.AttachmentBase;
import com.aspose.html.internal.ms.System.Net.Mail.LinkedResource;
import com.aspose.html.internal.ms.System.Net.Mail.LinkedResourceCollection;
import com.aspose.html.internal.ms.System.Net.Mime.ContentType;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Uri;

public class AlternateView
extends AttachmentBase {
    private Uri a;
    private LinkedResourceCollection b = new LinkedResourceCollection();

    public AlternateView(String fileName) {
        super(fileName);
        if (fileName == null) {
            throw new ArgumentNullException();
        }
    }

    public AlternateView(String fileName, ContentType contentType) {
        super(fileName, contentType);
        if (fileName == null) {
            throw new ArgumentNullException();
        }
    }

    public AlternateView(String fileName, String mediaType) {
        super(fileName, mediaType);
        if (fileName == null) {
            throw new ArgumentNullException();
        }
    }

    public AlternateView(Stream contentStream) {
        super(contentStream);
    }

    public AlternateView(Stream contentStream, String mediaType) {
        super(contentStream, mediaType);
    }

    public AlternateView(Stream contentStream, ContentType contentType) {
        super(contentStream, contentType);
    }

    public Uri getBaseUri() {
        return this.a;
    }

    public void setBaseUri(Uri value) {
        this.a = value;
    }

    public LinkedResourceCollection getLinkedResources() {
        return this.b;
    }

    public static AlternateView createAlternateViewFromString(String content) {
        if (content == null) {
            throw new ArgumentNullException();
        }
        MemoryStream memoryStream = new MemoryStream(Encoding.getUTF8().getBytes(content));
        AlternateView alternateView = new AlternateView(memoryStream);
        alternateView.setTransferEncoding(0);
        return alternateView;
    }

    public static AlternateView createAlternateViewFromString(String content, ContentType contentType) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        Encoding encoding = contentType.getCharSet() != null ? Encoding.getEncoding(contentType.getCharSet()) : Encoding.getUTF8();
        MemoryStream memoryStream = new MemoryStream(encoding.getBytes(content));
        AlternateView alternateView = new AlternateView((Stream)memoryStream, contentType);
        alternateView.setTransferEncoding(0);
        return alternateView;
    }

    public static AlternateView createAlternateViewFromString(String content, Encoding encoding, String mediaType) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        if (encoding == null) {
            encoding = Encoding.getUTF8();
        }
        MemoryStream memoryStream = new MemoryStream(encoding.getBytes(content));
        ContentType contentType = new ContentType();
        contentType.setMediaType(mediaType);
        contentType.setCharSet(encoding.getHeaderName());
        AlternateView alternateView = new AlternateView((Stream)memoryStream, contentType);
        alternateView.setTransferEncoding(0);
        return alternateView;
    }

    @Override
    protected void dispose(boolean disposing) {
        if (disposing) {
            for (LinkedResource linkedResource : this.b) {
                linkedResource.dispose();
            }
        }
        super.dispose(disposing);
    }
}

