/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.Collections.IDictionaryEnumerator;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Net.ICredentials;
import com.aspose.html.internal.ms.System.Net.ICredentialsByHost;
import com.aspose.html.internal.ms.System.Net.NetworkCredential;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.lang.Operators;

public class CredentialCache
implements IEnumerable,
ICredentials,
ICredentialsByHost {
    static NetworkCredential a = new NetworkCredential(StringExtensions.Empty, StringExtensions.Empty, StringExtensions.Empty);
    private Hashtable b = new Hashtable();
    private Hashtable c = new Hashtable();

    public static ICredentials getDefaultCredentials() {
        return a;
    }

    public static NetworkCredential getDefaultNetworkCredentials() {
        return a;
    }

    @Override
    public NetworkCredential getCredential(Uri uriPrefix, String authType) {
        int n2 = -1;
        NetworkCredential networkCredential = null;
        if (uriPrefix == null || authType == null) {
            return null;
        }
        String string = uriPrefix.getAbsolutePath();
        string = StringExtensions.substring(string, 0, StringExtensions.lastIndexOf(string, '/'));
        IDictionaryEnumerator iDictionaryEnumerator = this.b.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            Uri uri;
            CredentialCacheKey credentialCacheKey = Operators.as(iDictionaryEnumerator.getKey(), CredentialCacheKey.class);
            if (credentialCacheKey.a() <= n2 || StringExtensions.compare(credentialCacheKey.d(), authType, true) != 0 || !StringExtensions.equals((uri = credentialCacheKey.c()).getScheme(), uriPrefix.getScheme()) || uri.getPort() != uriPrefix.getPort() || !StringExtensions.equals(uri.getHost(), uriPrefix.getHost()) || !StringExtensions.startsWith(string, credentialCacheKey.b())) continue;
            n2 = credentialCacheKey.a();
            networkCredential = (NetworkCredential)iDictionaryEnumerator.getValue();
        }
        return networkCredential;
    }

    public IEnumerator iterator() {
        return this.b.getValues().iterator();
    }

    public void add(Uri uriPrefix, String authType, NetworkCredential cred) {
        if (uriPrefix == null) {
            throw new ArgumentNullException("uriPrefix");
        }
        if (authType == null) {
            throw new ArgumentNullException("authType");
        }
        this.b.addItem(new CredentialCacheKey(uriPrefix, authType), cred);
    }

    public void remove(Uri uriPrefix, String authType) {
        if (uriPrefix == null) {
            throw new ArgumentNullException("uriPrefix");
        }
        if (authType == null) {
            throw new ArgumentNullException("authType");
        }
        this.b.removeItem(new CredentialCacheKey(uriPrefix, authType));
    }

    @Override
    public NetworkCredential getCredential(String host, int port, String authenticationType) {
        NetworkCredential networkCredential = null;
        if (host == null || port < 0 || authenticationType == null) {
            return null;
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.c.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            CredentialCacheForHostKey credentialCacheForHostKey = Operators.as(iDictionaryEnumerator.getKey(), CredentialCacheForHostKey.class);
            if (StringExtensions.compare(credentialCacheForHostKey.c(), authenticationType, true) != 0 || !StringExtensions.equals(credentialCacheForHostKey.a(), host) || credentialCacheForHostKey.b() != port) continue;
            networkCredential = (NetworkCredential)iDictionaryEnumerator.getValue();
        }
        return networkCredential;
    }

    public void add(String host, int port, String authenticationType, NetworkCredential credential) {
        if (host == null) {
            throw new ArgumentNullException("host");
        }
        if (port < 0) {
            throw new ArgumentOutOfRangeException("port");
        }
        if (authenticationType == null) {
            throw new ArgumentOutOfRangeException("authenticationType");
        }
        this.c.addItem(new CredentialCacheForHostKey(host, port, authenticationType), credential);
    }

    public void remove(String host, int port, String authenticationType) {
        if (host == null) {
            return;
        }
        if (authenticationType == null) {
            return;
        }
        this.c.removeItem(new CredentialCacheForHostKey(host, port, authenticationType));
    }

    private static class CredentialCacheForHostKey {
        private String a;
        private int b;
        private String c;
        private int d;

        CredentialCacheForHostKey(String host, int port, String authType) {
            this.a = host;
            this.b = port;
            this.c = authType;
            this.d = host.hashCode() + Int32Extensions.getHashCode(port) + authType.hashCode();
        }

        public String a() {
            return this.a;
        }

        public int b() {
            return this.b;
        }

        public String c() {
            return this.c;
        }

        public int hashCode() {
            return this.d;
        }

        public boolean equals(Object obj) {
            CredentialCacheForHostKey credentialCacheForHostKey = Operators.as(obj, CredentialCacheForHostKey.class);
            return credentialCacheForHostKey != null && this.d == credentialCacheForHostKey.d;
        }

        public String toString() {
            return StringExtensions.concat(this.a, " : ", this.c);
        }
    }

    private static class CredentialCacheKey {
        private Uri a;
        private String b;
        private String c;
        private int d;
        private int e;

        CredentialCacheKey(Uri uriPrefix, String authType) {
            this.a = uriPrefix;
            this.b = authType;
            this.c = uriPrefix.getAbsolutePath();
            this.c = StringExtensions.substring(this.c, 0, StringExtensions.lastIndexOf(this.c, '/'));
            this.d = uriPrefix.getAbsoluteUri().length();
            this.e = uriPrefix.hashCode() + authType.hashCode();
        }

        public int a() {
            return this.d;
        }

        public String b() {
            return this.c;
        }

        public Uri c() {
            return this.a;
        }

        public String d() {
            return this.b;
        }

        public int hashCode() {
            return this.e;
        }

        public boolean equals(Object obj) {
            CredentialCacheKey credentialCacheKey = Operators.as(obj, CredentialCacheKey.class);
            return credentialCacheKey != null && this.e == credentialCacheKey.e;
        }

        public String toString() {
            return StringExtensions.concat(this.c, " : ", this.b, " : len=", Int32Extensions.toString(this.d));
        }
    }
}

