/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Net.ChunkStream;
import com.aspose.html.internal.ms.System.Net.HttpListenerContext;
import com.aspose.html.internal.ms.System.Net.HttpListenerException;
import com.aspose.html.internal.ms.System.Net.HttpStreamAsyncResult;
import com.aspose.html.internal.ms.System.Net.RequestStream;
import com.aspose.html.internal.ms.System.Net.WebHeaderCollection;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.OutAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;

class ChunkedInputStream
extends RequestStream {
    private boolean a;
    private ChunkStream b;
    private HttpListenerContext c;
    private boolean d;

    public ChunkedInputStream(HttpListenerContext context, Stream stream, byte[] buffer, int offset, int length) {
        super(stream, buffer, offset, length);
        this.c = context;
        WebHeaderCollection webHeaderCollection = (WebHeaderCollection)context.getRequest().getHeaders();
        this.b = new ChunkStream(webHeaderCollection);
    }

    public ChunkStream a() {
        return this.b;
    }

    public void a(ChunkStream chunkStream) {
        this.b = chunkStream;
    }

    @Override
    public int read(@InAttribute @OutAttribute byte[] buffer, int offset, int count) {
        IAsyncResult iAsyncResult = this.beginRead(buffer, offset, count, null, null);
        return this.endRead(iAsyncResult);
    }

    @Override
    public IAsyncResult beginRead(byte[] buffer, int offset, int count, AsyncCallback cback, Object state) {
        if (this.a) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        int n2 = Array.boxing(buffer).getLength();
        if (offset < 0 || offset > n2) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (count < 0 || offset > n2 - count) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        HttpStreamAsyncResult httpStreamAsyncResult = new HttpStreamAsyncResult();
        httpStreamAsyncResult.d = cback;
        httpStreamAsyncResult.e = state;
        if (this.d) {
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        int n3 = this.b.a(buffer, offset, count);
        offset += n3;
        if ((count -= n3) == 0) {
            httpStreamAsyncResult.c = n3;
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        if (!this.b.b()) {
            this.d = n3 == 0;
            httpStreamAsyncResult.c = n3;
            httpStreamAsyncResult.a();
            return httpStreamAsyncResult;
        }
        httpStreamAsyncResult.a = new byte[8192];
        httpStreamAsyncResult.b = 0;
        httpStreamAsyncResult.c = 8192;
        ReadBufferState readBufferState = new ReadBufferState(buffer, offset, count, httpStreamAsyncResult);
        readBufferState.d += n3;
        super.beginRead(httpStreamAsyncResult.a, httpStreamAsyncResult.b, httpStreamAsyncResult.c, new AsyncCallback(){

            @Override
            public void invoke(IAsyncResult base_ares) {
                ChunkedInputStream.this.a(base_ares);
            }
        }, readBufferState);
        return httpStreamAsyncResult;
    }

    private void a(IAsyncResult iAsyncResult) {
        ReadBufferState readBufferState = (ReadBufferState)iAsyncResult.getAsyncState();
        HttpStreamAsyncResult httpStreamAsyncResult = readBufferState.e;
        try {
            int n2 = super.endRead(iAsyncResult);
            this.b.b(httpStreamAsyncResult.a, httpStreamAsyncResult.b, n2);
            n2 = this.b.a(readBufferState.a, readBufferState.b, readBufferState.c);
            readBufferState.b += n2;
            readBufferState.c -= n2;
            if (readBufferState.c == 0 || !this.b.b() || n2 == 0) {
                this.d = !this.b.b() && n2 == 0;
                httpStreamAsyncResult.c = readBufferState.d - readBufferState.c;
                httpStreamAsyncResult.a();
                return;
            }
            httpStreamAsyncResult.b = 0;
            httpStreamAsyncResult.c = msMath.min(8192, this.b.e() + 6);
            super.beginRead(httpStreamAsyncResult.a, httpStreamAsyncResult.b, httpStreamAsyncResult.c, new AsyncCallback(){

                @Override
                public void invoke(IAsyncResult base_ares) {
                    ChunkedInputStream.this.a(base_ares);
                }
            }, readBufferState);
        }
        catch (Exception exception) {
            this.c.d().a(exception.getMessage(), 400);
            httpStreamAsyncResult.a(exception);
        }
    }

    @Override
    public int endRead(IAsyncResult ares) {
        if (this.a) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        HttpStreamAsyncResult httpStreamAsyncResult = Operators.as(ares, HttpStreamAsyncResult.class);
        if (ares == null) {
            throw new ArgumentException("Invalid IAsyncResult", "ares");
        }
        if (!ares.isCompleted()) {
            ares.getAsyncWaitHandle().waitOne();
        }
        if (httpStreamAsyncResult.g != null) {
            throw new HttpListenerException(400, StringExtensions.concat("I/O operation aborted: ", httpStreamAsyncResult.g.getMessage()));
        }
        return httpStreamAsyncResult.c;
    }

    @Override
    public void close() {
        if (!this.a) {
            this.a = true;
            super.close();
        }
    }

    private static class ReadBufferState {
        public byte[] a;
        public int b;
        public int c;
        public int d;
        public HttpStreamAsyncResult e;

        public ReadBufferState(byte[] buffer, int offset, int count, HttpStreamAsyncResult ares) {
            this.a = buffer;
            this.b = offset;
            this.c = count;
            this.d = count;
            this.e = ares;
        }
    }
}

