/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.core.System.j;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.lang.Extensions;

@Extensions
public final class Int64Extensions {
    public static final long MaxValue = Long.MAX_VALUE;
    public static final long MinValue = Long.MIN_VALUE;

    public static int compareTo(long a2, long b2) {
        if (a2 < b2) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(long a2, Object b2) {
        if (b2 == null) {
            return 1;
        }
        if (b2.getClass() != Long.class) {
            throw new ArgumentException("Object must be of type Int64");
        }
        long l2 = Convert.toInt64(b2);
        if (a2 < l2) {
            return -1;
        }
        if (a2 > l2) {
            return 1;
        }
        return 0;
    }

    public static boolean equals(long a2, long b2) {
        return a2 == b2;
    }

    public static boolean equals(long a2, Object b2) {
        if (b2 == null || b2.getClass() != Long.class) {
            return false;
        }
        return Convert.toInt64(b2) == a2;
    }

    public static int getHashCode(long a2) {
        return (int)a2 ^ (int)(a2 >> 32);
    }

    public static int getTypeCode() {
        return 11;
    }

    public static boolean tryParse(String source, int numberStyles, IFormatProvider culture, long[] referenceToValue) {
        try {
            referenceToValue[0] = Int64Extensions.parse(source, numberStyles, culture);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean tryParse(String source, long[] referenceToValue) {
        return Int64Extensions.tryParse(source, 7, NumberFormatInfo.getCurrentInfo(), referenceToValue);
    }

    public static long parse(String source) {
        return j.a(source);
    }

    public static long parse(String source, IFormatProvider provider) {
        return j.a(source);
    }

    public static long parse(String source, int numberStyles) {
        return j.a(source, numberStyles);
    }

    public static long parse(String source, int numberStyles, IFormatProvider provider) {
        return j.a(source, numberStyles, provider);
    }

    public static String toString(long value) {
        return k.c(null, value, NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(long value, IFormatProvider provider) {
        return k.c(null, value, provider);
    }

    public static String toString(long value, String pattern) {
        return k.c(pattern, value, NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(long value, String pattern, IFormatProvider provider) {
        return k.c(pattern, value, provider);
    }
}

