/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.NullStream;
import com.aspose.html.internal.ms.System.IO.SynchronizedStream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.MulticastDelegate;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.OutAttribute;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.Threading.AutoResetEvent;
import com.aspose.html.internal.ms.core.System.Remoting.DelegateHelper;
import com.aspose.html.internal.ms.core.System.Remoting.DelegatingProxy;
import com.aspose.html.internal.ms.core.mscorlib.c.a;
import com.aspose.html.internal.ms.core.mscorlib.c.b;
import com.aspose.html.internal.ms.helpers.streams.StreamUtil;
import com.aspose.html.internal.ms.lang.Operators;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

@SerializableAttribute
public abstract class Stream
implements IDisposable {
    private AtomicInteger a = new AtomicInteger(0);
    private AutoResetEvent b;
    private ReadDelegate c;
    private WriteDelegate d;
    public static Stream Null = new NullStream();

    protected Stream() {
    }

    public abstract boolean canRead();

    public abstract boolean canSeek();

    public abstract boolean canWrite();

    public boolean canTimeout() {
        return false;
    }

    public abstract long getLength();

    public abstract long getPosition();

    public abstract void setPosition(long var1);

    @Override
    public void dispose() {
        this.close();
    }

    protected void dispose(boolean disposing) {
        if (disposing && this.b != null) {
            this.a(this.a.decrementAndGet());
        }
    }

    public void close() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public int getReadTimeout() {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public void setReadTimeout(int value) {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public int getWriteTimeout() {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public void setWriteTimeout(int value) {
        throw new InvalidOperationException("Timeouts are not supported on this stream.");
    }

    public static Stream _synchronized(Stream stream) {
        return new SynchronizedStream(stream);
    }

    public abstract void flush();

    public abstract int read(@InAttribute @OutAttribute byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncResult beginRead(@InAttribute @OutAttribute byte[] buffer, int offset, int count, AsyncCallback callback, Object state) {
        if (!this.canRead()) {
            throw new NotSupportedException("Stream does not support reading.");
        }
        this.a.incrementAndGet();
        ReadDelegate readDelegate = new ReadDelegate(){

            @Override
            public int a(byte[] byArray, int n2, int n3) {
                return Stream.this.read(byArray, n2, n3);
            }
        };
        if (this.b == null) {
            Stream stream = this;
            synchronized (stream) {
                if (this.b == null) {
                    this.b = new AutoResetEvent(true);
                }
            }
        }
        this.b.waitOne();
        this.c = readDelegate;
        return readDelegate.a(buffer, offset, count, callback, state);
    }

    public int endRead(IAsyncResult asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        if (this.c == null) {
            throw new ArgumentException("Either the IAsyncResult object did not come from the corresponding async method on this type, or EndRead was called multiple times with the same IAsyncResult.");
        }
        int n2 = -1;
        try {
            n2 = this.c.a(asyncResult);
        }
        finally {
            this.c = null;
            this.b.set();
            this.a(this.a.decrementAndGet());
        }
        return n2;
    }

    public int readByte() {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    public abstract long seek(long var1, int var3);

    public abstract void setLength(long var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public void writeByte(byte value) {
        byte[] byArray = new byte[]{value};
        this.write(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncResult beginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, Object state) {
        if (!this.canWrite()) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.a.incrementAndGet();
        WriteDelegate writeDelegate = new WriteDelegate(){

            @Override
            public void a(byte[] byArray, int n2, int n3) {
                Stream.this.write(byArray, n2, n3);
            }
        };
        if (this.b == null) {
            Stream stream = this;
            synchronized (stream) {
                if (this.b == null) {
                    this.b = new AutoResetEvent(true);
                }
            }
        }
        this.b.waitOne();
        this.d = writeDelegate;
        return writeDelegate.a(buffer, offset, count, callback, state);
    }

    public void endWrite(IAsyncResult asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        if (this.d == null) {
            throw new ArgumentException("Either the IAsyncResult object did not come from the corresponding async method on this type, or EndWrite was called multiple times with the same IAsyncResult.");
        }
        try {
            this.d.a(asyncResult);
        }
        finally {
            this.d = null;
            this.b.set();
            this.a(this.a.decrementAndGet());
        }
    }

    private void a(int n2) {
        if (this.b != null && n2 == 0) {
            this.b.close();
            this.b = null;
        }
    }

    public OutputStream toOutputStream() {
        return new b(this);
    }

    public InputStream toInputStream() {
        return new a(this);
    }

    public static Stream fromJava(InputStream stream) {
        if (stream == null) {
            return null;
        }
        return StreamUtil.copyStream(stream);
    }

    public static InputStream toJava(Stream stream) {
        if (stream == null) {
            return null;
        }
        return stream.toInputStream();
    }

    public void copyTo(Stream destination) {
        this.copyTo(destination, 81920);
    }

    public void copyTo(Stream destination, int bufferSize) {
        if (destination == null) {
            throw new ArgumentNullException("destination is null");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("is negative or zero.");
        }
        if (!this.canRead() && !this.canWrite()) {
            throw new ObjectDisposedException("The current stream were closed before the method was called.");
        }
        if (!destination.canRead() && !destination.canWrite()) {
            throw new ObjectDisposedException("destination were closed before the method was called");
        }
        if (!this.canRead()) {
            throw new NotSupportedException("The current stream does not support reading");
        }
        if (!destination.canWrite()) {
            throw new NotSupportedException("The current stream does not support writing.");
        }
        this.a(destination, bufferSize);
    }

    private void a(Stream stream, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        while ((n3 = this.read(byArray, 0, byArray.length)) != 0) {
            stream.write(byArray, 0, n3);
        }
    }

    private abstract class WriteDelegate
    extends MulticastDelegate {
        private WriteDelegate() {
        }

        public abstract void a(byte[] var1, int var2, int var3);

        public final IAsyncResult a(final byte[] byArray, final int n2, final int n3, AsyncCallback asyncCallback, Object object) {
            return DelegateHelper.beginInvoke(new DelegatingProxy(this, asyncCallback, object){

                @Override
                public void beginInvoke() {
                    WriteDelegate.this.a(byArray, n2, n3);
                }
            });
        }

        public final void a(IAsyncResult iAsyncResult) {
            DelegateHelper.endInvoke(this, iAsyncResult);
        }
    }

    private abstract class ReadDelegate
    extends MulticastDelegate {
        private ReadDelegate() {
        }

        public abstract int a(@InAttribute @OutAttribute byte[] var1, int var2, int var3);

        public final IAsyncResult a(final @InAttribute @OutAttribute byte[] byArray, final int n2, final int n3, AsyncCallback asyncCallback, Object object) {
            return DelegateHelper.beginInvoke(new DelegatingProxy(this, asyncCallback, object){

                @Override
                public void beginInvoke() {
                    ReadDelegate.this.pushResult(ReadDelegate.this.a(byArray, n2, n3));
                }
            });
        }

        public final int a(IAsyncResult iAsyncResult) {
            DelegateHelper.endInvoke(this, iAsyncResult);
            return Operators.unboxing(this.peekResult(), Integer.TYPE);
        }
    }
}

