/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.OutAttribute;

public final class BufferedStream
extends Stream {
    private Stream a;
    private byte[] b;
    private int c;
    private int d;
    private boolean e;
    private boolean f = false;

    public BufferedStream(Stream stream) {
        this(stream, 4096);
    }

    public BufferedStream(Stream stream, int bufferSize) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "<= 0");
        }
        if (!stream.canRead() && !stream.canWrite()) {
            throw new ObjectDisposedException("Cannot access a closed Stream.");
        }
        this.a = stream;
        this.b = new byte[bufferSize];
    }

    @Override
    public boolean canRead() {
        return this.a.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.a.canWrite();
    }

    @Override
    public boolean canSeek() {
        return this.a.canSeek();
    }

    @Override
    public long getLength() {
        this.flush();
        return this.a.getLength();
    }

    @Override
    public long getPosition() {
        this.a();
        return this.a.getPosition() - (long)this.d + (long)this.c;
    }

    @Override
    public void setPosition(long value) {
        if (value < this.getPosition() && this.getPosition() - value <= (long)this.c && this.e) {
            this.c -= (int)(this.getPosition() - value);
        } else if (value > this.getPosition() && value - this.getPosition() < (long)(this.d - this.c) && this.e) {
            this.c += (int)(value - this.getPosition());
        } else {
            this.flush();
            this.a.setPosition(value);
        }
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.f) {
            return;
        }
        if (this.b != null) {
            this.flush();
        }
        this.a.close();
        this.b = null;
        this.f = true;
    }

    @Override
    public void flush() {
        this.a();
        if (this.e) {
            if (this.canSeek()) {
                this.a.setPosition(this.getPosition());
            }
        } else if (this.c > 0) {
            this.a.write(this.b, 0, this.c);
        }
        this.d = 0;
        this.c = 0;
    }

    @Override
    public long seek(long offset, int origin) {
        this.a();
        if (!this.canSeek()) {
            throw new NotSupportedException("Non seekable stream.");
        }
        this.flush();
        return this.a.seek(offset, origin);
    }

    @Override
    public void setLength(long value) {
        this.a();
        if (value < 0L) {
            throw new ArgumentOutOfRangeException("value must be positive");
        }
        if (!this.a.canWrite() && !this.a.canSeek()) {
            throw new NotSupportedException("the stream cannot seek nor write.");
        }
        if (this.a == null || !this.a.canRead() && !this.a.canWrite()) {
            throw new IOException("the stream is not open");
        }
        this.a.setLength(value);
        if (this.getPosition() > value) {
            this.setPosition(value);
        }
    }

    @Override
    public int readByte() {
        this.a();
        if (!this.a.canRead()) {
            throw new NotSupportedException("Cannot read from stream");
        }
        if (!this.e) {
            this.flush();
            this.e = true;
        }
        if (1 <= this.d - this.c) {
            return this.b[this.c++] & 0xFF;
        }
        if (this.c >= this.d) {
            this.c = 0;
            this.d = 0;
        }
        this.d = this.a.read(this.b, 0, this.b.length);
        if (1 <= this.d) {
            return this.b[this.c++] & 0xFF;
        }
        return -1;
    }

    @Override
    public void writeByte(byte value) {
        this.a();
        if (!this.a.canWrite()) {
            throw new NotSupportedException("Cannot write to stream");
        }
        if (this.e) {
            this.flush();
            this.e = false;
        } else if (this.c >= this.b.length - 1) {
            this.flush();
        }
        this.b[this.c++] = value;
    }

    @Override
    public int read(@InAttribute @OutAttribute byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        this.a();
        if (!this.a.canRead()) {
            throw new NotSupportedException("Cannot read from stream");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("array.Length - offset < count");
        }
        if (!this.e) {
            this.flush();
            this.e = true;
        }
        if (count <= this.d - this.c) {
            Buffer.blockCopy(Array.boxing(this.b), this.c, Array.boxing(array), offset, count);
            this.c += count;
            if (this.c == this.d) {
                this.c = 0;
                this.d = 0;
            }
            return count;
        }
        int n2 = this.d - this.c;
        Buffer.blockCopy(Array.boxing(this.b), this.c, Array.boxing(array), offset, n2);
        this.c = 0;
        this.d = 0;
        offset += n2;
        if ((count -= n2) >= this.b.length) {
            n2 += this.a.read(array, offset, count);
        } else {
            this.d = this.a.read(this.b, 0, this.b.length);
            if (count < this.d) {
                Buffer.blockCopy(Array.boxing(this.b), 0, Array.boxing(array), offset, count);
                this.c = count;
                n2 += count;
            } else {
                Buffer.blockCopy(Array.boxing(this.b), 0, Array.boxing(array), offset, this.d);
                n2 += this.d;
                this.d = 0;
            }
        }
        return n2;
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        this.a();
        if (!this.a.canWrite()) {
            throw new NotSupportedException("Cannot write to stream");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("array.Length - offset < count");
        }
        if (this.e) {
            this.flush();
            this.e = false;
        }
        if (this.c >= this.b.length - count) {
            this.flush();
            this.a.write(array, offset, count);
        } else {
            Buffer.blockCopy(Array.boxing(array), offset, Array.boxing(this.b), this.c, count);
            this.c += count;
        }
    }

    private void a() {
        if (this.f) {
            throw new ObjectDisposedException("BufferedStream", "Stream is closed");
        }
    }
}

