/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Globalization;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.core.mscorlib.b.a;
import com.aspose.time.TimeSpan;

@SerializableAttribute
public class JulianCalendar
extends msCalendar {
    public static final int JulianEra = 1;
    int a = 9999;

    public JulianCalendar() {
        this.f = 2029;
    }

    @Override
    public int getAlgorithmType() {
        return 1;
    }

    @Override
    public int[] getEras() {
        return new int[]{1};
    }

    @Override
    public DateTime getMaxSupportedDateTime() {
        return DateTime.MaxValue.Clone();
    }

    @Override
    public DateTime getMinSupportedDateTime() {
        return DateTime.MinValue.Clone();
    }

    @Override
    public int getTwoDigitYearMax() {
        return 2029;
    }

    @Override
    public void setTwoDigitYearMax(int value) {
        super.e();
        if (value < 99 || value > this.a) {
            throw new ArgumentOutOfRangeException("year");
        }
        this.f = value;
    }

    @Override
    public DateTime addMonths(DateTime time, int months) {
        if (months < -120000 || months > 120000) {
            throw new ArgumentOutOfRangeException("months");
        }
        int n2 = JulianCalendar.a(time.getTicks(), 0);
        int n3 = JulianCalendar.a(time.getTicks(), 2);
        int n4 = JulianCalendar.a(time.getTicks(), 3);
        int n5 = n3 - 1 + months;
        if (n5 < 0) {
            n3 = 12 + (n5 + 1) % 12;
            n2 += (n5 - 11) / 12;
        } else {
            n3 = n5 % 12 + 1;
            n2 += n5 / 12;
        }
        int[] nArray = n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0) ? com.aspose.html.internal.ms.core.mscorlib.b.a.b : com.aspose.html.internal.ms.core.mscorlib.b.a.a;
        int n6 = nArray[n3] - nArray[n3 - 1];
        if (n4 > n6) {
            n4 = n6;
        }
        long l2 = JulianCalendar.b(n2, n3, n4) + time.getTicks() % 864000000000L;
        com.aspose.html.internal.ms.core.mscorlib.b.a.a(l2, this.getMinSupportedDateTime(), this.getMaxSupportedDateTime());
        return new DateTime(l2);
    }

    @Override
    public DateTime addYears(DateTime time, int years) {
        return this.addMonths(time, years * 12);
    }

    @Override
    public int getDayOfMonth(DateTime time) {
        return JulianCalendar.a(time.getTicks(), 3);
    }

    @Override
    public int getDayOfWeek(DateTime time) {
        return (int)(time.getTicks() / 864000000000L + 1L) % 7;
    }

    @Override
    public int getDayOfYear(DateTime time) {
        return JulianCalendar.a(time.getTicks(), 1);
    }

    @Override
    public int getDaysInMonth(int year, int month, int era) {
        this.b(year, era);
        JulianCalendar.b(month);
        int[] nArray = year % 4 == 0 ? com.aspose.html.internal.ms.core.mscorlib.b.a.b : com.aspose.html.internal.ms.core.mscorlib.b.a.a;
        return nArray[month] - nArray[month - 1];
    }

    @Override
    public int getDaysInYear(int year, int era) {
        if (!this.isLeapYear(year, era)) {
            return 365;
        }
        return 366;
    }

    @Override
    public int getEra(DateTime time) {
        return 1;
    }

    @Override
    public int getLeapMonth(int year, int era) {
        this.b(year, era);
        return 0;
    }

    @Override
    public int getMonth(DateTime time) {
        return JulianCalendar.a(time.getTicks(), 2);
    }

    @Override
    public int getMonthsInYear(int year, int era) {
        this.b(year, era);
        return 12;
    }

    @Override
    public int getYear(DateTime time) {
        return JulianCalendar.a(time.getTicks(), 0);
    }

    @Override
    public boolean isLeapDay(int year, int month, int day, int era) {
        JulianCalendar.b(month);
        JulianCalendar.a(year, month, day);
        return this.isLeapYear(year, era) && month == 2 && day == 29;
    }

    @Override
    public boolean isLeapMonth(int year, int month, int era) {
        this.b(year, era);
        JulianCalendar.b(month);
        return false;
    }

    @Override
    public boolean isLeapYear(int year, int era) {
        this.b(year, era);
        return year % 4 == 0;
    }

    @Override
    public DateTime toDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era) {
        this.b(year, era);
        JulianCalendar.b(month);
        JulianCalendar.a(year, month, day);
        if (millisecond < 0 || millisecond >= 1000) {
            throw new ArgumentOutOfRangeException("millisecond");
        }
        if (hour < 0 || hour >= 24 || minute < 0 || minute >= 60 || second < 0 || second >= 60) {
            throw new ArgumentOutOfRangeException("ArgumentOutOfRange_BadHourMinuteSecond");
        }
        TimeSpan timeSpan = new TimeSpan(0, hour, minute, second, millisecond);
        return new DateTime(JulianCalendar.b(year, month, day) + timeSpan.getTicks());
    }

    @Override
    public int toFourDigitYear(int year) {
        if (year > this.a) {
            throw new ArgumentOutOfRangeException("year");
        }
        return super.toFourDigitYear(year);
    }

    @Override
    public int get_current_era_internal() {
        return 1;
    }

    @Override
    public Object deepClone() {
        JulianCalendar julianCalendar = new JulianCalendar();
        julianCalendar.setTwoDigitYearMax(this.getTwoDigitYearMax());
        return julianCalendar;
    }

    static void a(int n2, int n3, int n4) {
        if (n2 == 1 && n3 == 1 && n4 < 3) {
            throw new ArgumentOutOfRangeException(null);
        }
        int[] nArray = n2 % 4 == 0 ? com.aspose.html.internal.ms.core.mscorlib.b.a.b : com.aspose.html.internal.ms.core.mscorlib.b.a.a;
        int n5 = nArray[n3] - nArray[n3 - 1];
        if (n4 < 1 || n4 > n5) {
            throw new ArgumentOutOfRangeException("day");
        }
    }

    static void a(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
    }

    static void b(int n2) {
        if (n2 < 1 || n2 > 12) {
            throw new ArgumentOutOfRangeException("month");
        }
    }

    void b(int n2, int n3) {
        JulianCalendar.a(n3);
        if (n2 <= 0 || n2 > this.a) {
            throw new ArgumentOutOfRangeException("year");
        }
    }

    static long b(int n2, int n3, int n4) {
        int[] nArray = 0 != n2 % 4 ? com.aspose.html.internal.ms.core.mscorlib.b.a.a : com.aspose.html.internal.ms.core.mscorlib.b.a.b;
        int n5 = n2 - 1;
        int n6 = n5 * 365 + n5 / 4 + nArray[n3 - 1] + n4 - 1;
        return 864000000000L * (long)(n6 - 2);
    }

    static int a(long l2, int n2) {
        int n3;
        int n4;
        long l3 = l2 + 1728000000000L;
        int n5 = (int)(l3 / 864000000000L);
        if ((n4 = (n5 -= (n3 = n5 / 1461) * 1461) / 365) == 4) {
            n4 = 3;
        }
        if (n2 == 0) {
            return n3 * 4 + n4 + 1;
        }
        n5 -= n4 * 365;
        if (n2 == 1) {
            return n5 + 1;
        }
        int[] nArray = n4 == 3 ? com.aspose.html.internal.ms.core.mscorlib.b.a.b : com.aspose.html.internal.ms.core.mscorlib.b.a.a;
        int n6 = n5 >> 6;
        while (n5 >= nArray[n6]) {
            ++n6;
        }
        if (n2 == 2) {
            return n6;
        }
        return n5 - nArray[n6 - 1] + 1;
    }
}

