/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Extensions;

@Extensions
public final class EnumExtensions {
    public static String toString(Class<?> enumType, long value) {
        return Enum.getName(enumType, value);
    }

    public static String toString(Class<?> enumType, long value, String format) {
        if (format == null || format.length() == 0) {
            format = "G";
        }
        if (StringExtensions.compare(format, "G", (short)5) == 0) {
            return EnumExtensions.toString(enumType, value);
        }
        if (StringExtensions.compare(format, "D", (short)5) == 0) {
            return Int64Extensions.toString(value);
        }
        if (StringExtensions.compare(format, "X", (short)5) == 0) {
            return Int64Extensions.toString(value, format);
        }
        if (StringExtensions.compare(format, "F", (short)5) != 0) {
            throw new FormatException("Invalid Enum Format Specification");
        }
        return EnumExtensions.toString(enumType, value);
    }

    @Deprecated
    public String toString(Class<?> enumType, long value, IFormatProvider provider) {
        return EnumExtensions.toString(enumType, value);
    }

    @Deprecated
    public String toString(Class<?> enumType, long value, String format, IFormatProvider provider) {
        return EnumExtensions.toString(enumType, value, format);
    }
}

