/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ComponentModel.BrowsableAttribute;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Struct;

@SerializableAttribute
public class Rectangle
extends Struct<Rectangle> {
    private java.awt.Rectangle b = new java.awt.Rectangle();
    public static Rectangle Empty = new Rectangle();

    public Rectangle() {
    }

    public Rectangle(java.awt.Rectangle area) {
        this.b = area;
    }

    public java.awt.Rectangle getNativeObject() {
        return this.b;
    }

    public static Rectangle ceiling(RectangleF value) {
        int n2 = (int)Math.ceil(value.getX());
        int n3 = (int)Math.ceil(value.getY());
        int n4 = (int)Math.ceil(value.getWidth());
        int n5 = (int)Math.ceil(value.getHeight());
        return new Rectangle(n2, n3, n4, n5);
    }

    public static Rectangle fromLTRB(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public static Rectangle inflate(Rectangle rect, int x2, int y2) {
        Rectangle rectangle = new Rectangle(rect.getLocation().Clone(), rect.getSize().Clone());
        rectangle.inflate(x2, y2);
        return rectangle;
    }

    public void inflate(int width, int height) {
        this.inflate(new Size(width, height));
    }

    public void inflate(Size size) {
        this.b.x -= size.getWidth();
        this.b.y -= size.getHeight();
        this.setWidth(this.getWidth() + size.getWidth() * 2);
        this.setHeight(this.getHeight() + size.getHeight() * 2);
    }

    public static Rectangle intersect(Rectangle a2, Rectangle b2) {
        if (!a2.a(b2.Clone())) {
            return Empty;
        }
        return Rectangle.fromLTRB(Math.max(a2.getLeft(), b2.getLeft()), Math.max(a2.getTop(), b2.getTop()), Math.min(a2.getRight(), b2.getRight()), Math.min(a2.getBottom(), b2.getBottom()));
    }

    public void intersect(Rectangle rect) {
        Rectangle.intersect(this.Clone(), rect.Clone()).CloneTo(this);
    }

    public static Rectangle round(RectangleF value) {
        int n2 = (int)msMath.round(value.getX());
        int n3 = (int)msMath.round(value.getY());
        int n4 = (int)msMath.round(value.getWidth());
        int n5 = (int)msMath.round(value.getHeight());
        return new Rectangle(n2, n3, n4, n5);
    }

    public static Rectangle truncate(RectangleF value) {
        int n2 = (int)value.getX();
        int n3 = (int)value.getY();
        int n4 = (int)value.getWidth();
        int n5 = (int)value.getHeight();
        return new Rectangle(n2, n3, n4, n5);
    }

    public static Rectangle union(Rectangle a2, Rectangle b2) {
        return Rectangle.fromLTRB(Math.min(a2.getLeft(), b2.getLeft()), Math.min(a2.getTop(), b2.getTop()), Math.max(a2.getRight(), b2.getRight()), Math.max(a2.getBottom(), b2.getBottom()));
    }

    public static boolean op_Equality(Rectangle left, Rectangle right) {
        return Point.equals(left.getLocation(), right.getLocation()) && Size.equals(left.getSize(), right.getSize());
    }

    public static boolean op_Inequality(Rectangle left, Rectangle right) {
        return !Point.equals(left.getLocation(), right.getLocation()) || !Size.equals(left.getSize(), right.getSize());
    }

    public Rectangle(Point location, Size size) {
        this.b = new java.awt.Rectangle(location.getX(), location.getY(), size.getWidth(), size.getHeight());
    }

    public Rectangle(int x2, int y2, int width, int height) {
        this.b = new java.awt.Rectangle(x2, y2, width, height);
    }

    @BrowsableAttribute(browsable=false)
    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    public int getHeight() {
        return this.b.height;
    }

    public void setHeight(int value) {
        this.b.height = value;
    }

    @BrowsableAttribute(browsable=false)
    public boolean isEmpty() {
        return this.getX() == 0 && this.getY() == 0 && this.getWidth() == 0 && this.getHeight() == 0;
    }

    @BrowsableAttribute(browsable=false)
    public int getLeft() {
        return this.getX();
    }

    @BrowsableAttribute(browsable=false)
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @BrowsableAttribute(browsable=false)
    public void setLocation(Point value) {
        this.b.x = value.getX();
        this.b.y = value.getY();
    }

    @BrowsableAttribute(browsable=false)
    public int getRight() {
        return this.getX() + this.getWidth();
    }

    @BrowsableAttribute(browsable=false)
    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @BrowsableAttribute(browsable=false)
    public void setSize(Size value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    @BrowsableAttribute(browsable=false)
    public int getTop() {
        return this.getY();
    }

    public int getWidth() {
        return this.b.width;
    }

    public void setWidth(int value) {
        this.b.width = value;
    }

    public int getX() {
        return this.b.x;
    }

    public void setX(int value) {
        this.b.x = value;
    }

    public int getY() {
        return this.b.y;
    }

    public void setY(int value) {
        this.b.y = value;
    }

    public boolean contains(int x2, int y2) {
        return x2 >= this.getLeft() && x2 < this.getRight() && y2 >= this.getTop() && y2 < this.getBottom();
    }

    public boolean contains(Point pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public boolean contains(Rectangle rect) {
        return Rectangle.equals(rect, Rectangle.intersect(this.Clone(), rect.Clone()));
    }

    public int hashCode() {
        return this.getHeight() + this.getWidth() ^ this.getX() + this.getY();
    }

    public boolean intersectsWith(Rectangle rect) {
        return this.getLeft() < rect.getRight() && this.getRight() > rect.getLeft() && this.getTop() < rect.getBottom() && this.getBottom() > rect.getTop();
    }

    private boolean a(Rectangle rectangle) {
        return this.getLeft() <= rectangle.getRight() && this.getRight() >= rectangle.getLeft() && this.getTop() <= rectangle.getBottom() && this.getBottom() >= rectangle.getTop();
    }

    public void offset(int x2, int y2) {
        this.b.x += x2;
        this.b.y += y2;
    }

    public void offset(Point pos) {
        this.b.x += pos.getX();
        this.b.y += pos.getY();
    }

    public String toString() {
        return StringExtensions.format("{{X={0},Y={1},Width={2},Height={3}}}", this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public void CloneTo(Rectangle that) {
        that.setX(this.getX());
        that.setY(this.getY());
        that.setWidth(this.getWidth());
        that.setHeight(this.getHeight());
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean b(Rectangle rectangle) {
        return rectangle.getX() == this.getX() && rectangle.getY() == this.getY() && rectangle.getWidth() == this.getWidth() && rectangle.getHeight() == this.getHeight();
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        return this.b((Rectangle)obj);
    }

    public static boolean equals(Rectangle obj1, Rectangle obj2) {
        return obj1.equals(obj2);
    }

    public static Rectangle fromJava(java.awt.Rectangle area) {
        if (area == null) {
            return new Rectangle();
        }
        return new Rectangle(area);
    }

    public static java.awt.Rectangle toJava(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        return rect.b;
    }
}

