/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Drawing2D;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.MatrixUtil;
import com.aspose.html.internal.ms.lang.Operators;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public final class Matrix
implements IDisposable {
    public static final Matrix IdentityTransform = new Matrix();
    final AffineTransform a;

    Matrix(AffineTransform ptr) {
        this.a = ptr;
    }

    public Matrix() {
        this(new AffineTransform());
    }

    public Matrix(Rectangle rect, Point[] plgpts) {
        if (plgpts == null) {
            throw new ArgumentNullException("Value of 'plgpts' cannot be null");
        }
        if (plgpts.length != 3) {
            throw new ArgumentException("Value of 'plgpts' is invalid");
        }
        double d2 = plgpts[1].getX() - plgpts[0].getX();
        double d3 = plgpts[1].getY() - plgpts[0].getY();
        double d4 = plgpts[2].getX() - plgpts[0].getX();
        double d5 = plgpts[2].getY() - plgpts[0].getY();
        this.a = new AffineTransform(d2 / (double)rect.getWidth(), d3 / (double)rect.getWidth(), d4 / (double)rect.getHeight(), d5 / (double)rect.getHeight(), (double)plgpts[0].getX(), (double)plgpts[0].getY());
        this.a.translate(-rect.getX(), -rect.getY());
    }

    public Matrix(RectangleF rect, PointF[] plgpts) {
        if (plgpts == null) {
            throw new ArgumentNullException("Value of 'plgpts' cannot be null");
        }
        if (plgpts.length != 3) {
            throw new ArgumentException("Value of 'plgpts' is invalid");
        }
        double d2 = plgpts[1].getX() - plgpts[0].getX();
        double d3 = plgpts[1].getY() - plgpts[0].getY();
        double d4 = plgpts[2].getX() - plgpts[0].getX();
        double d5 = plgpts[2].getY() - plgpts[0].getY();
        this.a = new AffineTransform(d2 / (double)rect.getWidth(), d3 / (double)rect.getWidth(), d4 / (double)rect.getHeight(), d5 / (double)rect.getHeight(), (double)plgpts[0].getX(), (double)plgpts[0].getY());
        this.a.translate(-rect.getX(), -rect.getY());
    }

    public Matrix(float m11, float m12, float m21, float m22, float dx2, float dy2) {
        this(new AffineTransform(m11, m12, m21, m22, dx2, dy2));
    }

    public float[] getElements() {
        float[] fArray = new float[]{(float)this.getNativeObject().getScaleX(), (float)this.getNativeObject().getShearY(), (float)this.getNativeObject().getShearX(), (float)this.getNativeObject().getScaleY(), (float)this.getNativeObject().getTranslateX(), (float)this.getNativeObject().getTranslateY()};
        return fArray;
    }

    public boolean isIdentity() {
        return MatrixUtil.isMatrixEmpty(this);
    }

    public boolean isInvertible() {
        return this.getNativeObject().getDeterminant() != 0.0;
    }

    public float getOffsetX() {
        return (float)this.getNativeObject().getTranslateX();
    }

    public float getOffsetY() {
        return (float)this.getNativeObject().getTranslateY();
    }

    public Matrix deepClone() {
        return new Matrix((AffineTransform)this.getNativeObject().clone());
    }

    @Override
    public void dispose() {
    }

    public void copyTo(Matrix matrix) {
        matrix.getNativeObject().setTransform(this.getNativeObject());
    }

    public boolean equals(Object obj) {
        Matrix matrix = Operators.as(obj, Matrix.class);
        if (matrix == null) {
            return false;
        }
        float[] fArray = matrix.getElements();
        float[] fArray2 = this.getElements();
        boolean bl2 = true;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            bl2 &= fArray[i2] == fArray2[i2];
        }
        return bl2;
    }

    public int hashCode() {
        return this.getNativeObject().hashCode();
    }

    public void invert() {
        try {
            this.a.setTransform(this.a.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ArgumentException(noninvertibleTransformException.getMessage(), noninvertibleTransformException);
        }
    }

    public void multiply(Matrix matrix) {
        this.multiply(matrix, 0);
    }

    public void multiply(Matrix matrix, int order) {
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'matrix' cannot be null");
        }
        this.a(matrix.getNativeObject(), order);
    }

    public void reset() {
        this.getNativeObject().setToIdentity();
    }

    public void rotate(float angle) {
        this.getNativeObject().rotate(Math.toRadians(angle));
    }

    public void rotate(float angle, int order) {
        this.a(AffineTransform.getRotateInstance(Math.toRadians(angle)), order);
    }

    public void rotateAt(float angle, PointF point) {
        this.getNativeObject().rotate(Math.toRadians(angle), point.getX(), point.getY());
    }

    public void rotateAt(float angle, PointF point, int order) {
        this.a(AffineTransform.getRotateInstance(Math.toRadians(angle), point.getX(), point.getY()), order);
    }

    public void scale(float scaleX, float scaleY) {
        this.scale(scaleX, scaleY, 0);
    }

    public void scale(float scaleX, float scaleY, int order) {
        this.a(AffineTransform.getScaleInstance(scaleX, scaleY), order);
    }

    public void shear(float shearX, float shearY) {
        this.getNativeObject().shear(shearX, shearY);
    }

    public void shear(float shearX, float shearY, int order) {
        this.a(AffineTransform.getShearInstance(shearX, shearY), order);
    }

    public void transformPoints(Point[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pts.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pts.length; ++i2) {
            float_.setLocation(pts[i2].getX(), pts[i2].getY());
            this.getNativeObject().transform(float_, float_);
            pts[i2].setX((int)Math.round(float_.getX()));
            pts[i2].setY((int)Math.round(float_.getY()));
        }
    }

    public void transformPoints(PointF[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pts.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pts.length; ++i2) {
            float_.setLocation(pts[i2].getX(), pts[i2].getY());
            this.getNativeObject().transform(float_, float_);
            pts[i2].setX((float)float_.getX());
            pts[i2].setY((float)float_.getY());
        }
    }

    public void transformVectors(Point[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pts.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pts.length; ++i2) {
            float_.setLocation(pts[i2].getX(), pts[i2].getY());
            this.getNativeObject().deltaTransform(float_, float_);
            pts[i2].setX((int)float_.getX());
            pts[i2].setY((int)float_.getY());
        }
    }

    public void transformVectors(PointF[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pts.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pts.length; ++i2) {
            float_.setLocation(pts[i2].getX(), pts[i2].getY());
            this.getNativeObject().deltaTransform(float_, float_);
            pts[i2].setX((float)float_.getX());
            pts[i2].setY((float)float_.getY());
        }
    }

    public void translate(float offsetX, float offsetY) {
        this.getNativeObject().translate(offsetX, offsetY);
    }

    public void translate(float offsetX, float offsetY, int order) {
        this.a(AffineTransform.getTranslateInstance(offsetX, offsetY), order);
    }

    public void vectorTransformPoints(Point[] pts) {
        this.transformVectors(pts);
    }

    public AffineTransform getNativeObject() {
        return this.a;
    }

    private void a(AffineTransform affineTransform, int n2) {
        Matrix.multiply(this.getNativeObject(), affineTransform, n2);
    }

    public static void multiply(AffineTransform to, AffineTransform add, int order) {
        switch (order) {
            case 0: {
                to.concatenate(add);
                break;
            }
            case 1: {
                to.preConcatenate(add);
                break;
            }
            default: {
                throw new ArgumentException("Value of 'order' is invalid");
            }
        }
    }

    public static AffineTransform toJava(Matrix m2) {
        if (m2 == null) {
            return null;
        }
        return m2.getNativeObject();
    }

    public static Matrix fromJava(AffineTransform transform) {
        if (transform == null) {
            return null;
        }
        return new Matrix(transform);
    }
}

