/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.ComponentModel;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.ComponentModel.MemberDescriptor;
import com.aspose.html.internal.ms.System.Delegate;
import com.aspose.html.internal.ms.System.EventArgs;
import com.aspose.html.internal.ms.System.EventHandler;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;
import java.lang.annotation.Annotation;

public abstract class PropertyDescriptor
extends MemberDescriptor {
    private Hashtable a;
    private Object[] b;
    private Type[] c;
    private int d;

    protected PropertyDescriptor(String name, Annotation[] attrs) {
        super(name, attrs);
    }

    protected PropertyDescriptor(MemberDescriptor descr) {
        super(descr);
    }

    protected PropertyDescriptor(MemberDescriptor descr, Annotation[] attrs) {
        super(descr, attrs);
    }

    public abstract Type getComponentType();

    public abstract boolean isReadOnly();

    public abstract Type getPropertyType();

    public void addValueChanged(Object component, EventHandler handler) {
        if (component == null) {
            throw new ArgumentNullException("component");
        }
        if (handler == null) {
            throw new ArgumentNullException("handler");
        }
        if (this.a == null) {
            this.a = new Hashtable();
        }
        EventHandler eventHandler = (EventHandler)this.a.get_Item(component);
        this.a.set_Item(component, Delegate.combine((Delegate)eventHandler, (Delegate)handler));
    }

    public abstract boolean canResetValue(Object var1);

    @Override
    public boolean equals(Object obj) {
        try {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            PropertyDescriptor propertyDescriptor = Operators.as(obj, PropertyDescriptor.class);
            if (propertyDescriptor != null && propertyDescriptor.getNameHashCode() == this.getNameHashCode() && propertyDescriptor.getPropertyType() == this.getPropertyType() && StringExtensions.equals(propertyDescriptor.getName(), this.getName())) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getNameHashCode() ^ this.getPropertyType().hashCode();
    }

    protected Type getTypeFromName(String typeName) {
        Type type;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        Type type2 = Type.getType(typeName);
        Type type3 = null;
        if (this.getComponentType() != null && (type2 == null || StringExtensions.equals(this.getComponentType().getAssembly().getFullName(), type2.getAssembly().getFullName()))) {
            int n2 = StringExtensions.indexOf(typeName, ',');
            if (n2 != -1) {
                typeName = StringExtensions.substring(typeName, 0, n2);
            }
            type3 = this.getComponentType().getAssembly().getType(typeName);
        }
        if ((type = type3) == null) {
            type = type2;
        }
        return type;
    }

    public abstract Object getValue(Object var1);

    protected void onValueChanged(Object component, EventArgs e2) {
        EventHandler eventHandler;
        if (component != null && this.a != null && (eventHandler = (EventHandler)this.a.get_Item(component)) != null) {
            eventHandler.invoke(component, e2);
        }
    }

    public void removeValueChanged(Object component, EventHandler handler) {
        if (component == null) {
            throw new ArgumentNullException("component");
        }
        if (handler == null) {
            throw new ArgumentNullException("handler");
        }
        if (this.a != null) {
            EventHandler eventHandler = (EventHandler)this.a.get_Item(component);
            if ((eventHandler = (EventHandler)Delegate.remove(eventHandler, handler)) != null) {
                this.a.set_Item(component, eventHandler);
            } else {
                this.a.removeItem(component);
            }
        }
    }

    protected EventHandler getValueChangedHandler(Object component) {
        if (component != null && this.a != null) {
            return (EventHandler)this.a.get_Item(component);
        }
        return null;
    }

    public abstract void resetValue(Object var1);

    public abstract void setValue(Object var1, Object var2);

    public abstract boolean shouldSerializeValue(Object var1);

    public boolean getSupportsChangeEvents() {
        return false;
    }

    public static PropertyDescriptor fromJava(java.beans.PropertyDescriptor pd) {
        return new JavaPropertyDescriptor(pd);
    }

    static class JavaPropertyDescriptor
    extends PropertyDescriptor {
        java.beans.PropertyDescriptor a;

        protected JavaPropertyDescriptor(java.beans.PropertyDescriptor pd) {
            super(pd.getName(), pd.getPropertyType().getDeclaredAnnotations());
            this.a = pd;
        }

        @Override
        public Type getComponentType() {
            return Operators.typeOf(this.a.getPropertyType());
        }

        @Override
        public boolean isReadOnly() {
            return this.a.getReadMethod() != null;
        }

        @Override
        public Type getPropertyType() {
            return Operators.typeOf(this.a.getPropertyType());
        }

        @Override
        public boolean canResetValue(Object component) {
            return false;
        }

        @Override
        public Object getValue(Object component) {
            throw new NotSupportedException();
        }

        @Override
        public void resetValue(Object component) {
            throw new NotSupportedException();
        }

        @Override
        public void setValue(Object component, Object value) {
            throw new NotSupportedException();
        }

        @Override
        public boolean shouldSerializeValue(Object component) {
            return false;
        }
    }
}

