/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Comparer;
import com.aspose.html.internal.ms.System.Collections.DictionaryEntry;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IDictionary;
import com.aspose.html.internal.ms.System.Collections.IDictionaryEnumerator;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IList;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.Comparator;

@SerializableAttribute
public class SortedList
implements IDictionary,
ICloneable {
    private static final int a = 16;
    private Slot[] b;
    private Comparator c;
    private int d;
    private int e;
    private int f;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.f = capacity == 0 ? 0 : 16;
        this.c = comparer;
        this.b(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.c = comparer;
        this.b(16, true);
    }

    public SortedList(IDictionary d2) {
        this(d2, null);
    }

    public SortedList(IDictionary d2, Comparator comparer) {
        if (d2 == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.b(d2.size(), true);
        this.c = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d2.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.d;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.a(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.b(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.a(key, value, true);
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int value) {
        int n2 = this.b.length;
        if (this.d > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.a(this.f);
            SortedList.a(this.b, 0, slotArray, 0, this.d);
            this.b = slotArray;
        } else if (value > this.d) {
            Slot[] slotArray = SortedList.a(value);
            SortedList.a(this.b, 0, slotArray, 0, this.d);
            this.b = slotArray;
        } else if (value > n2) {
            Slot[] slotArray = SortedList.a(value);
            SortedList.a(this.b, 0, slotArray, 0, n2);
            this.b = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.a(key, value, false);
    }

    @Override
    public void clear() {
        this.f = 16;
        this.b = SortedList.a(this.f);
        this.d = 0;
        ++this.e;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.b(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n2 = this.indexOfKey(key);
        if (n2 >= 0) {
            this.removeAt(n2);
        }
    }

    @Override
    public void copyTo(Array array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.getRank() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.getLength()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.getLength() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n2 = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.setValue((Object)iDictionaryEnumerator.getEntry().Clone(), n2++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.c);
        sortedList.e = this.e;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.b;
        int n2 = this.size();
        if (index >= 0 && index < n2) {
            if (index != n2 - 1) {
                SortedList.a(slotArray, index + 1, slotArray, index, n2 - 1 - index);
            } else {
                slotArray[index].a = null;
                slotArray[index].b = null;
            }
            --this.d;
            ++this.e;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n2 = 0;
        try {
            n2 = this.b(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n2 | n2 >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.d == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < this.d; ++i2) {
            Slot slot = this.b[i2].Clone();
            if (!ObjectExtensions.equals(value, slot.b)) continue;
            return i2;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.b[index].b;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.b[index].b = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.b[index].a;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.a(this.f, false);
        } else {
            this.a(this.size(), true);
        }
    }

    private void a(int n2, boolean bl2) {
        Slot[] slotArray = this.b;
        Slot[] slotArray2 = SortedList.a(n2);
        if (bl2) {
            SortedList.a(slotArray, 0, slotArray2, 0, n2);
        }
        this.b = slotArray2;
    }

    private void a(int n2, int n3) {
        boolean bl2;
        Slot[] slotArray = this.b;
        Slot[] slotArray2 = null;
        int n4 = this.getCapacity();
        boolean bl3 = bl2 = n3 >= 0 && n3 < this.size();
        if (n2 > n4) {
            slotArray2 = SortedList.a(n2 << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n5 = n3;
                if (n5 > 0) {
                    SortedList.a(slotArray, 0, slotArray2, 0, n5);
                }
                if ((n5 = this.size() - n3) > 0) {
                    SortedList.a(slotArray, n3, slotArray2, n3 + 1, n5);
                }
            } else {
                SortedList.a(slotArray, 0, slotArray2, 0, this.size());
            }
            this.b = slotArray2;
        } else if (bl2) {
            SortedList.a(slotArray, n3, slotArray, n3 + 1, this.size() - n3);
        }
    }

    private void a(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.b;
        int n2 = -1;
        try {
            n2 = this.b(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n2 >= 0) {
            if (!bl2) {
                String string = StringExtensions.format("Key '{0}' already exists in list.", object);
                throw new ArgumentException(string);
            }
            slotArray[n2].b = object2;
            ++this.e;
            return;
        }
        if ((n2 ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(StringExtensions.concat("SortedList::internal error (", object, ", ", object2, ") at [", n2, "]"));
        }
        this.a(this.size() + 1, n2);
        slotArray = this.b;
        slotArray[n2].a = object;
        slotArray[n2].b = object2;
        ++this.d;
        ++this.e;
    }

    private Object a(Object object) {
        int n2 = this.b(object);
        if (n2 >= 0) {
            return this.b[n2].b;
        }
        return null;
    }

    private void b(int n2, boolean bl2) {
        if (!bl2 && n2 < this.f) {
            n2 = this.f;
        }
        this.b = SortedList.a(n2);
        this.d = 0;
        this.e = 0;
    }

    private void a(Array array, int n2, int n3) {
        if (array == null) {
            throw new ArgumentNullException("arr");
        }
        if (n2 < 0 || n2 + this.size() > array.getLength()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n3);
        while (enumerator.hasNext()) {
            array.setValue(enumerator.next(), n2++);
        }
    }

    private int b(Object object) {
        Slot[] slotArray = this.b;
        int n2 = this.size();
        if (n2 == 0) {
            return -1;
        }
        Comparator comparator = this.c == null ? Comparer.Default : this.c;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            int n6 = comparator.compare(slotArray[n5].a, object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return ~n3;
    }

    static Slot[] a(int n2) {
        Slot[] slotArray = new Slot[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            slotArray[i2] = new Slot();
        }
        return slotArray;
    }

    private static boolean a(int n2, int n3, int n4) {
        return n2 < n3 && n2 + n4 > n3 || n3 < n2 && n3 + n4 > n2;
    }

    static void a(Slot[] slotArray, int n2, Slot[] slotArray2, int n3, int n4) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.a(n2, n3, n4)) {
            slotArray3 = new Slot[n4];
            System.arraycopy(slotArray, n2, slotArray3, 0, n4);
            n2 = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            slotArray2[n3 + i2] = slotArray3[n2 + i2].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList a;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.a = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                iCollection = this.a.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                iCollection = this.a.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.a(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.a(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int arrayIndex) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.a(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.b(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.trimToSize();
            }
        }
    }

    @SerializableAttribute
    private static class ListValues
    implements IList {
        private SortedList a;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.a = host;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            this.a.a(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.a.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.a, 1);
        }
    }

    @SerializableAttribute
    private static class ListKeys
    implements IList {
        private SortedList a;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.a = host;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            this.a.a(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.a.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.a.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.a, 0);
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    ICloneable {
        private SortedList a;
        private Object b;
        private Object c;
        private int d;
        private int e;
        private int f;
        private int g;
        private boolean h = false;
        private static String i = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.a = host;
            this.d = host.e;
            this.f = host.size();
            this.g = mode;
            this.reset();
        }

        public Enumerator(SortedList host) {
            this(host, 2);
        }

        @Override
        public void reset() {
            if (this.a.e != this.d || this.h) {
                throw new IllegalStateException(i);
            }
            this.e = -1;
            this.b = null;
            this.c = null;
        }

        @Override
        public boolean hasNext() {
            if (this.a.e != this.d || this.h) {
                throw new InvalidOperationException(i);
            }
            Slot[] slotArray = this.a.b;
            if (++this.e < this.f) {
                Slot slot = slotArray[this.e].Clone();
                this.b = slot.a;
                this.c = slot.b;
                return true;
            }
            this.b = null;
            this.c = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            return new DictionaryEntry(this.b, this.c);
        }

        @Override
        public Object getKey() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            return this.b;
        }

        @Override
        public Object getValue() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            return this.c;
        }

        @Override
        public Object next() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            switch (this.g) {
                case 0: {
                    return this.b;
                }
                case 1: {
                    return this.c;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(StringExtensions.concat(Enum.getName(EnumeratorMode.class, this.g), " is not a supported mode."));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.a, this.g);
            enumerator.d = this.d;
            enumerator.e = this.e;
            enumerator.f = this.f;
            enumerator.b = this.b;
            enumerator.c = this.c;
            enumerator.h = this.h;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends Enum {
        public static final int a = 0;
        public static final int b = 1;
        public static final int c = 2;

        private EnumeratorMode() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @SerializableAttribute
    public static class Slot
    extends Struct<Slot> {
        Object a;
        Object b;

        @Override
        public void CloneTo(Slot that) {
            that.a = this.a;
            that.b = this.b;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Slot slot) {
            return ObjectExtensions.equals(slot.a, this.a) && ObjectExtensions.equals(slot.b, this.b);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (ObjectExtensions.referenceEquals(null, obj)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.a((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n2 = this.a != null ? this.a.hashCode() : 0;
            n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
            return n2;
        }
    }
}

