/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.Generic;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ArrayTypeMismatchException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericCollection;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.Arrays;

@SerializableAttribute
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] a;
    private int b;
    private int c;
    private static final int d = 16;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.a = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t2 : collection) {
            this.push(t2);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.b = collection.size();
            this.a = new Object[this.b];
            collection.copyToTArray(this.a, 0);
        }
    }

    public void clear() {
        if (this.a != null) {
            msArray.clear(this.a, 0, this.a.length);
        }
        this.b = 0;
        ++this.c;
    }

    public boolean contains(T item) {
        return this.a != null && msArray.indexOf(this.a, item, 0, this.b) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.b - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.a != null) {
            Array.copy(Array.boxing(this.a), 0, Array.boxing(array), arrayIndex, this.b);
            msArray.reverse(array, arrayIndex, this.b);
        }
    }

    public T peek() {
        if (this.b == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.a[this.b - 1];
    }

    public T pop() {
        if (this.b == 0) {
            throw new InvalidOperationException();
        }
        ++this.c;
        Object object = this.a[--this.b];
        this.a[this.b] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.a == null || this.b == this.a.length) {
            if (this.a == null) {
                this.a = new Object[16];
            }
            this.a = Arrays.copyOf(this.a, this.b == 0 ? 16 : 2 * this.b);
        }
        ++this.c;
        this.a[this.b++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.b) {
            this.copyTo(Array.boxing(array), 0);
            return array;
        }
        Array array2 = Array.createInstance(Operators.typeOf(array.getClass().getComponentType()), this.b);
        this.copyTo(array2, 0);
        return (Object[])Array.unboxing(array2);
    }

    public void trimExcess() {
        if (this.a != null && (double)this.b < (double)this.a.length * 0.9) {
            this.a = Arrays.copyOf(this.a, this.b);
        }
        ++this.c;
    }

    @Override
    public int size() {
        return this.b;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(Array dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.a != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.b) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.b - idx > dest.getLength()) {
                    throw new ArgumentException("idx");
                }
                Array.copy(Array.boxing(this.a), 0, dest, idx, this.b);
                Array.reverse(dest, idx, this.b);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @SerializableAttribute
    public static class Enumerator<T>
    extends Struct<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private static final int b = -2;
        private static final int c = -1;
        private Stack<T> d;
        private int e;
        private int f;

        public Enumerator() {
        }

        Enumerator(Stack<T> t2) {
            this.d = t2;
            this.e = -2;
            this.f = ((Stack)t2).c;
        }

        @Override
        public void dispose() {
            this.e = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.f != ((Stack)this.d).c) {
                throw new IllegalStateException();
            }
            if (this.e == -2) {
                this.e = ((Stack)this.d).b;
            }
            return this.e != -1 && --this.e != -1;
        }

        @Override
        public T next() {
            if (this.e < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.d).a[this.e];
        }

        @Override
        public void reset() {
            if (this.f != ((Stack)this.d).c) {
                throw new IllegalStateException();
            }
            this.e = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.d = this.d;
            that.e = this.e;
            that.f = this.f;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Enumerator enumerator) {
            return ObjectExtensions.equals(enumerator.d, this.d) && enumerator.e == this.e && enumerator.f == this.f;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (ObjectExtensions.referenceEquals(null, obj)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.a((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n2 = this.d != null ? this.d.hashCode() : 0;
            n2 = 31 * n2 + this.e;
            n2 = 31 * n2 + this.f;
            return n2;
        }
    }
}

