/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IList;
import com.aspose.html.internal.ms.System.SerializableAttribute;

@SerializableAttribute
public abstract class CollectionBase
implements ICollection,
IEnumerable,
IList {
    private ArrayList a;

    @Override
    public int size() {
        return this.getInnerList().size();
    }

    @Override
    public IEnumerator iterator() {
        return this.getInnerList().iterator();
    }

    @Override
    public void clear() {
        this.onClear();
        this.getInnerList().clear();
        this.onClearComplete();
    }

    @Override
    public void removeAt(int index) {
        Object object = this.getInnerList().get_Item(index);
        this.onValidate(object);
        this.onRemove(index, object);
        this.getInnerList().removeAt(index);
        this.onRemoveComplete(index, object);
    }

    protected CollectionBase() {
    }

    protected CollectionBase(int capacity) {
        this.a = new ArrayList(capacity);
    }

    public int getCapacity() {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        return this.a.getCapacity();
    }

    public void setCapacity(int value) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.setCapacity(value);
    }

    protected ArrayList getInnerList() {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        return this.a;
    }

    protected IList getList() {
        return this;
    }

    protected void onClear() {
    }

    protected void onClearComplete() {
    }

    protected void onInsert(int index, Object value) {
    }

    protected void onInsertComplete(int index, Object value) {
    }

    protected void onRemove(int index, Object value) {
    }

    protected void onRemoveComplete(int index, Object value) {
    }

    protected void onSet(int index, Object oldValue, Object newValue) {
    }

    protected void onSetComplete(int index, Object oldValue, Object newValue) {
    }

    protected void onValidate(Object value) {
        if (null == value) {
            throw new ArgumentNullException("CollectionBase.OnValidate: Invalid parameter value passed to method: null");
        }
    }

    @Override
    public void copyTo(Array array, int index) {
        this.getInnerList().copyTo(array, index);
    }

    @Override
    public Object getSyncRoot() {
        return this.getInnerList().getSyncRoot();
    }

    @Override
    public boolean isSynchronized() {
        return this.getInnerList().isSynchronized();
    }

    @Override
    public int addItem(Object value) {
        this.onValidate(value);
        int n2 = this.getInnerList().size();
        this.onInsert(n2, value);
        this.getInnerList().addItem(value);
        try {
            this.onInsertComplete(n2, value);
        }
        catch (RuntimeException runtimeException) {
            this.getInnerList().removeAt(n2);
            throw runtimeException;
        }
        return n2;
    }

    @Override
    public boolean contains(Object value) {
        return this.getInnerList().contains(value);
    }

    @Override
    public int indexOf(Object value) {
        return this.getInnerList().indexOf(value);
    }

    @Override
    public void insertItem(int index, Object value) {
        this.onValidate(value);
        this.onInsert(index, value);
        this.getInnerList().insertItem(index, value);
        try {
            this.onInsertComplete(index, value);
        }
        catch (RuntimeException runtimeException) {
            this.getInnerList().removeAt(index);
            throw runtimeException;
        }
    }

    @Override
    public void removeItem(Object value) {
        this.onValidate(value);
        int n2 = this.getInnerList().indexOf(value);
        if (n2 == -1) {
            throw new ArgumentException("The element cannot be found.", "value");
        }
        this.onRemove(n2, value);
        this.getInnerList().removeItem(value);
        this.onRemoveComplete(n2, value);
    }

    @Override
    public boolean isFixedSize() {
        return this.getInnerList().isFixedSize();
    }

    @Override
    public boolean isReadOnly() {
        return this.getInnerList().isReadOnly();
    }

    @Override
    public Object get_Item(int index) {
        return this.getInnerList().get_Item(index);
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index");
        }
        this.onValidate(value);
        Object object = this.getInnerList().get_Item(index);
        this.onSet(index, object, value);
        this.getInnerList().set_Item(index, value);
        try {
            this.onSetComplete(index, object, value);
        }
        catch (RuntimeException runtimeException) {
            this.getInnerList().set_Item(index, object);
            throw runtimeException;
        }
    }
}

