/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLButtonElement;
import com.aspose.html.forms.FormElement;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public class ButtonElement
extends FormElement<HTMLButtonElement> {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("submit", "reset", "button");

    public ButtonElement(HTMLButtonElement element) {
        super(element, 5);
    }

    @Override
    public String getName() {
        return ((HTMLButtonElement)this.getHtmlElement()).getName();
    }

    @Override
    public void setName(String value) {
        ((HTMLButtonElement)this.getHtmlElement()).setName(value);
    }

    @Override
    public String getId() {
        return ((HTMLButtonElement)this.getHtmlElement()).getId_Rename_Namesake();
    }

    @Override
    public void setId(String value) {
        ((HTMLButtonElement)this.getHtmlElement()).setId_Rename_Namesake(value);
    }

    @Override
    public String getValue() {
        return ((HTMLButtonElement)this.getHtmlElement()).getValue();
    }

    @Override
    public void setValue(String value) {
        ((HTMLButtonElement)this.getHtmlElement()).setValue(value);
    }

    public int getType() {
        return this.buttonElementTypeToEnum(((HTMLButtonElement)this.getHtmlElement()).getType());
    }

    public void setType(int value) {
        ((HTMLButtonElement)this.getHtmlElement()).setType(this.buttonElementTypeToString(value));
    }

    private String buttonElementTypeToString(int elementType) {
        switch (elementType) {
            case 1: {
                return "submit";
            }
            case 2: {
                return "reset";
            }
            case 3: {
                return "button";
            }
        }
        return StringExtensions.Empty;
    }

    private int buttonElementTypeToEnum(String elementType) {
        switch (gStringSwitchMap.of(elementType)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }
}

