/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg.datatypes;

import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.datatypes.SVGValueType;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.p11.z11;
import com.aspose.html.internal.p4.z30;
import com.aspose.html.internal.p68.z1;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGTransform")
public class SVGTransform
extends SVGValueType {
    @DOMNameAttribute(name="SVG_TRANSFORM_UNKNOWN")
    public static final int SVG_TRANSFORM_UNKNOWN = 0;
    @DOMNameAttribute(name="SVG_TRANSFORM_MATRIX")
    public static final int SVG_TRANSFORM_MATRIX = 1;
    @DOMNameAttribute(name="SVG_TRANSFORM_TRANSLATE")
    public static final int SVG_TRANSFORM_TRANSLATE = 2;
    @DOMNameAttribute(name="SVG_TRANSFORM_SCALE")
    public static final int SVG_TRANSFORM_SCALE = 3;
    @DOMNameAttribute(name="SVG_TRANSFORM_ROTATE")
    public static final int SVG_TRANSFORM_ROTATE = 4;
    @DOMNameAttribute(name="SVG_TRANSFORM_SKEWX")
    public static final int SVG_TRANSFORM_SKEWX = 5;
    @DOMNameAttribute(name="SVG_TRANSFORM_SKEWY")
    public static final int SVG_TRANSFORM_SKEWY = 6;
    private final SVGMatrix transformMatrix = new SVGMatrix();
    private int type;
    private IGenericList<Float> arguments;

    @DOMNameAttribute(name="type")
    public int getType() {
        return this.type;
    }

    @DOMNameAttribute(name="matrix")
    public SVGMatrix getMatrix() {
        return this.transformMatrix;
    }

    @DOMNameAttribute(name="setMatrix")
    public void setMatrix(SVGMatrix matrix) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        this.type = 1;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF()})));
        this.transformMatrix.Matrix = matrix.Matrix.m256();
        this.fireNotifyPropertyChanged("Matrix");
    }

    @DOMNameAttribute(name="angle")
    public float getAngle() {
        if (this.type == 4 || this.type == 5 || this.type == 6) {
            return this.arguments.get_Item(0).floatValue();
        }
        return 0.0f;
    }

    @DOMNameAttribute(name="setTranslate")
    public void setTranslate(float tx, float ty) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        this.type = 2;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{tx, ty})));
        this.getMatrix().Matrix = new z11(1.0f, 0.0f, 0.0f, 1.0f, tx, ty);
        this.fireNotifyPropertyChanged("Matrix");
    }

    @DOMNameAttribute(name="setScale")
    public void setScale(float sx, float sy) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        this.type = 3;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{sx, sy})));
        this.getMatrix().Matrix = new z11(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
        this.fireNotifyPropertyChanged("Matrix");
    }

    @DOMNameAttribute(name="setRotate")
    public void setRotate(float angle, float cx2, float cy2) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        this.type = 4;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{angle, cx2, cy2})));
        z11 z1110 = new z11(1.0f, 0.0f, 0.0f, 1.0f, cx2, cy2);
        z1110.rotate(angle);
        z1110.translate(-cx2, -cy2);
        this.getMatrix().Matrix = z1110;
        this.fireNotifyPropertyChanged("Matrix");
    }

    @DOMNameAttribute(name="setSkewX")
    public void setSkewX(float angle) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        this.type = 5;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{angle})));
        this.getMatrix().Matrix = new z11(1.0f, 0.0f, (float)msMath.tan(z30.degreesToRadians(angle)), 1.0f, 0.0f, 0.0f);
        this.fireNotifyPropertyChanged("Matrix");
    }

    @DOMNameAttribute(name="setSkewY")
    public void setSkewY(float angle) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        this.type = 6;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{angle})));
        this.getMatrix().Matrix = new z11(1.0f, (float)msMath.tan(z30.degreesToRadians(angle)), 0.0f, 1.0f, 0.0f, 0.0f);
        this.fireNotifyPropertyChanged("Matrix");
    }

    @Override
    public Object deepClone() {
        SVGTransform sVGTransform = new SVGTransform();
        switch (this.getType()) {
            case 4: {
                sVGTransform.setRotate(this.getArguments().get_Item(0).floatValue(), this.getArguments().get_Item(1).floatValue(), this.getArguments().get_Item(2).floatValue());
                break;
            }
            case 1: {
                sVGTransform.setMatrix((SVGMatrix)this.getMatrix().deepClone());
                break;
            }
            case 2: {
                sVGTransform.setTranslate(this.getArguments().get_Item(0).floatValue(), this.getArguments().get_Item(1).floatValue());
                break;
            }
            case 3: {
                sVGTransform.setScale(this.getArguments().get_Item(0).floatValue(), this.getArguments().get_Item(1).floatValue());
                break;
            }
            case 5: {
                sVGTransform.setSkewX(this.getArguments().get_Item(0).floatValue());
                break;
            }
            case 6: {
                sVGTransform.setSkewY(this.getArguments().get_Item(0).floatValue());
                break;
            }
            default: {
                return StringExtensions.Empty;
            }
        }
        return sVGTransform;
    }

    public IGenericList<Float> getArguments() {
        return this.arguments;
    }

    private void setArguments(IGenericList<Float> value) {
        this.arguments = value;
    }
}

