/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg.datatypes;

import com.aspose.html.dom.IBrowsingContext;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.svg.datatypes.SVGValueType;
import com.aspose.html.dom.z2;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.p68.z1;
import com.aspose.html.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGAngle")
public class SVGAngle
extends SVGValueType {
    @DOMNameAttribute(name="SVG_ANGLETYPE_UNKNOWN")
    public static final int SVG_ANGLETYPE_UNKNOWN = 0;
    @DOMNameAttribute(name="SVG_ANGLETYPE_UNSPECIFIED")
    public static final int SVG_ANGLETYPE_UNSPECIFIED = 1;
    @DOMNameAttribute(name="SVG_ANGLETYPE_DEG")
    public static final int SVG_ANGLETYPE_DEG = 2;
    @DOMNameAttribute(name="SVG_ANGLETYPE_RAD")
    public static final int SVG_ANGLETYPE_RAD = 3;
    @DOMNameAttribute(name="SVG_ANGLETYPE_GRAD")
    public static final int SVG_ANGLETYPE_GRAD = 4;
    private static final String[] Units = new String[]{StringExtensions.Empty, StringExtensions.Empty, "deg", "rad", "grad"};
    private IBrowsingContext context;
    private float value;
    private int unitType;

    public SVGAngle(z3 context) {
        this(context, 0.0f, 1);
    }

    public SVGAngle(IBrowsingContext context, float value, int unitType) {
        this.context = context;
        this.value = value;
        this.unitType = unitType;
    }

    @DOMNameAttribute(name="unitType")
    public int getUnitType() {
        return this.unitType;
    }

    @DOMNameAttribute(name="value")
    public float getValue() {
        return this.value;
    }

    @DOMNameAttribute(name="value")
    public void setValue(float value) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        if (!ObjectExtensions.equals(Float.valueOf(this.value), Float.valueOf(value))) {
            this.value = value;
            this.setField("Value");
        }
    }

    @DOMNameAttribute(name="valueInSpecifiedUnits")
    public float getValueInSpecifiedUnits() {
        return this.value;
    }

    @DOMNameAttribute(name="valueInSpecifiedUnits")
    public void setValueInSpecifiedUnits(float value) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        if (!ObjectExtensions.equals(Float.valueOf(this.value), Float.valueOf(value))) {
            this.value = value;
            this.setField("Value");
        }
    }

    @DOMNameAttribute(name="valueAsString")
    public String getValueAsString() {
        return StringExtensions.concat(SingleExtensions.toString(this.value, z2.DEFAULT_CULTURE), Units[this.unitType & 0xFFFF]);
    }

    @DOMNameAttribute(name="valueAsString")
    public void setValueAsString(String value) {
        if (this.isReadOnly()) {
            throw z1.m1235();
        }
        SVGAngle sVGAngle = (SVGAngle)this.context.getService(com.aspose.html.internal.p104.z2.class).m2(com.aspose.html.internal.p104.z3.m13(SVGAngle.class)).m1(this.context, value);
        int n2 = sVGAngle.getUnitType();
        if (!ObjectExtensions.equals(this.unitType, n2)) {
            this.unitType = n2;
            this.setField("UnitType");
        }
        float f2 = sVGAngle.getValue();
        if (!ObjectExtensions.equals(Float.valueOf(this.value), Float.valueOf(f2))) {
            this.value = f2;
            this.setField("Value");
        }
    }

    @DOMNameAttribute(name="newValueSpecifiedUnits")
    public void newValueSpecifiedUnits(int newUnitType, float valueInSpecifiedUnits) {
        switch (newUnitType) {
            case 2: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.value = valueInSpecifiedUnits;
                this.unitType = newUnitType;
                break;
            }
            case 4: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.value = valueInSpecifiedUnits * 10.0f / 9.0f;
                this.unitType = newUnitType;
                break;
            }
            case 3: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.unitType = newUnitType;
                break;
            }
            case 1: {
                this.setValueInSpecifiedUnits(valueInSpecifiedUnits);
                this.value = (float)((double)valueInSpecifiedUnits * Math.PI);
                this.unitType = newUnitType;
                break;
            }
            default: {
                throw z1.m1237();
            }
        }
    }

    @DOMNameAttribute(name="convertToSpecifiedUnits")
    public void convertToSpecifiedUnits(int unitType) {
    }

    @Override
    public Object deepClone() {
        return new SVGAngle(this.context, this.value, this.unitType);
    }
}

