/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.Text;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.svg.SVGElement;
import com.aspose.html.dom.svg.SVGGraphicsElement;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedEnumeration;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedLength;
import com.aspose.html.dom.svg.datatypes.SVGPoint;
import com.aspose.html.dom.svg.datatypes.SVGRect;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p77.z14;
import com.aspose.html.internal.p78.z7;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGTextContentElement")
public class SVGTextContentElement
extends SVGGraphicsElement {
    @DOMNameAttribute(name="LENGTHADJUST_UNKNOWN")
    public static final int LENGTHADJUST_UNKNOWN = 0;
    @DOMNameAttribute(name="LENGTHADJUST_SPACING")
    public static final int LENGTHADJUST_SPACING = 1;
    @DOMNameAttribute(name="LENGTHADJUST_SPACINGANDGLYPHS")
    public static final int LENGTHADJUST_SPACINGANDGLYPHS = 2;
    private final z7 textLength = new z7(this, "textLength");
    private final z14 lengthAdjust = new z14(this);

    public SVGTextContentElement(z8 name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="textLength")
    public SVGAnimatedLength getTextLength() {
        return (SVGAnimatedLength)this.textLength.getValue();
    }

    @DOMNameAttribute(name="lengthAdjust")
    public SVGAnimatedEnumeration getLengthAdjust() {
        return (SVGAnimatedEnumeration)this.lengthAdjust.getValue();
    }

    @DOMNameAttribute(name="getNumberOfChars")
    public long getNumberOfChars() {
        return this.calculateNumberOfChars(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long calculateNumberOfChars(Node root) {
        switch (root.getNodeType()) {
            case 3: {
                return ((Text)root).getData().length();
            }
            case 1: {
                SVGElement sVGElement = Operators.as(root, SVGElement.class);
                if (sVGElement == null || !sVGElement.isRendered()) return 0L;
                long l2 = 0L;
                IEnumerator iEnumerator = root.getChildNodes().iterator();
                try {
                    while (iEnumerator.hasNext()) {
                        Node node = (Node)iEnumerator.next();
                        l2 += this.calculateNumberOfChars(node);
                    }
                    return l2;
                }
                finally {
                    if (Operators.is(iEnumerator, IDisposable.class)) {
                        ((IDisposable)((Object)iEnumerator)).dispose();
                    }
                }
            }
        }
        return 0L;
    }

    @DOMNameAttribute(name="getComputedTextLength")
    public float getComputedTextLength() {
        return this.getSubStringLength(Operators.castToUInt64(0, 9), Operators.castToUInt64(this.getNumberOfChars(), 11));
    }

    @DOMNameAttribute(name="getSubStringLength")
    public float getSubStringLength(long charnum, long nchars) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="getStartPositionOfChar")
    public SVGPoint getStartPositionOfChar(long charnum) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="getEndPositionOfChar")
    public SVGPoint getEndPositionOfChar(long charnum) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="getExtentOfChar")
    public SVGRect getExtentOfChar(long charnum) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="getRotationOfChar")
    public float getRotationOfChar(long charnum) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="getCharNumAtPosition")
    public long getCharNumAtPosition(SVGPoint point) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="selectSubString")
    public void selectSubString(long charnum, long nchars) {
        throw new NotImplementedException();
    }
}

