/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg;

import com.aspose.html.collections.NodeList;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.events.Event;
import com.aspose.html.dom.events.IDocumentEvent;
import com.aspose.html.dom.svg.ISVGFitToViewBox;
import com.aspose.html.dom.svg.ISVGZoomAndPan;
import com.aspose.html.dom.svg.SVGElement;
import com.aspose.html.dom.svg.SVGGraphicsElement;
import com.aspose.html.dom.svg.datatypes.SVGAngle;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedLength;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedPreserveAspectRatio;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedRect;
import com.aspose.html.dom.svg.datatypes.SVGLength;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.datatypes.SVGNumber;
import com.aspose.html.dom.svg.datatypes.SVGPoint;
import com.aspose.html.dom.svg.datatypes.SVGRect;
import com.aspose.html.dom.svg.datatypes.SVGTransform;
import com.aspose.html.dom.svg.z3;
import com.aspose.html.dom.traversal.ITreeWalker;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p77.z28;
import com.aspose.html.internal.p78.z13;
import com.aspose.html.internal.p78.z14;
import com.aspose.html.internal.p78.z7;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGSVGElement")
public class SVGSVGElement
extends SVGGraphicsElement
implements IDocumentEvent,
ISVGFitToViewBox,
ISVGZoomAndPan {
    private final z3 svgContext;
    private final z28 zoomAndPan;
    private final z7 x;
    private final z7 y;
    private final z7 width;
    private final z7 height;
    private final z14 viewBox;
    private final z13 preserveAspectRatio;
    private float currentScale = 1.0f;
    private boolean auto_UseCurrentView;
    private SVGPoint auto_CurrentTranslate;
    private float auto_PixelUnitToMillimeterX;
    private float auto_PixelUnitToMillimeterY;
    private float auto_ScreenPixelToMillimeterX;
    private float auto_ScreenPixelToMillimeterY;

    public SVGSVGElement(z8 name, Document doc) {
        super(name, doc);
        this.svgContext = new z3(doc.getBrowsingContext());
        this.zoomAndPan = new z28(this);
        this.x = new z7((SVGElement)this, "x", 1);
        this.y = new z7((SVGElement)this, "y", 1);
        this.width = new z7((SVGElement)this, "width", "100%", true, 1);
        this.height = new z7((SVGElement)this, "height", "100%", true, 1);
        this.viewBox = new z14(this, "viewBox");
        this.preserveAspectRatio = new z13(this);
        this.setCurrentTranslate(new SVGPoint(0.0f, 0.0f));
        this.flags.set(Node.z2.m4332, true);
    }

    @Override
    public z3 getSVGContext() {
        SVGElement sVGElement = this.getFarthestViewportElement();
        return sVGElement == null ? this.svgContext : sVGElement.getSVGContext();
    }

    @DOMNameAttribute(name="x")
    public SVGAnimatedLength getX() {
        return (SVGAnimatedLength)this.x.getValue();
    }

    @DOMNameAttribute(name="y")
    public SVGAnimatedLength getY() {
        return (SVGAnimatedLength)this.y.getValue();
    }

    @DOMNameAttribute(name="width")
    public SVGAnimatedLength getWidth() {
        return (SVGAnimatedLength)this.width.getValue();
    }

    @DOMNameAttribute(name="height")
    public SVGAnimatedLength getHeight() {
        return (SVGAnimatedLength)this.height.getValue();
    }

    @DOMNameAttribute(name="useCurrentView")
    public boolean getUseCurrentView() {
        return this.auto_UseCurrentView;
    }

    @DOMNameAttribute(name="useCurrentView")
    private void setUseCurrentView(boolean value) {
        this.auto_UseCurrentView = value;
    }

    @DOMNameAttribute(name="currentScale")
    public float getCurrentScale() {
        if (this.getOwnerSVGElement() != null) {
            return 1.0f;
        }
        return this.currentScale;
    }

    @DOMNameAttribute(name="currentScale")
    public void setCurrentScale(float value) {
        if (this.getOwnerSVGElement() != null) {
            return;
        }
        this.currentScale = value;
    }

    @DOMNameAttribute(name="currentTranslate")
    public SVGPoint getCurrentTranslate() {
        return this.auto_CurrentTranslate;
    }

    @DOMNameAttribute(name="currentTranslate")
    private void setCurrentTranslate(SVGPoint value) {
        this.auto_CurrentTranslate = value;
    }

    @DOMNameAttribute(name="pixelUnitToMillimeterX")
    public float getPixelUnitToMillimeterX() {
        return this.auto_PixelUnitToMillimeterX;
    }

    @DOMNameAttribute(name="pixelUnitToMillimeterX")
    private void setPixelUnitToMillimeterX(float value) {
        this.auto_PixelUnitToMillimeterX = value;
    }

    @DOMNameAttribute(name="pixelUnitToMillimeterY")
    public float getPixelUnitToMillimeterY() {
        return this.auto_PixelUnitToMillimeterY;
    }

    @DOMNameAttribute(name="pixelUnitToMillimeterY")
    private void setPixelUnitToMillimeterY(float value) {
        this.auto_PixelUnitToMillimeterY = value;
    }

    @DOMNameAttribute(name="screenPixelToMillimeterX")
    public float getScreenPixelToMillimeterX() {
        return this.auto_ScreenPixelToMillimeterX;
    }

    @DOMNameAttribute(name="screenPixelToMillimeterX")
    private void setScreenPixelToMillimeterX(float value) {
        this.auto_ScreenPixelToMillimeterX = value;
    }

    @DOMNameAttribute(name="screenPixelToMillimeterY")
    public float getScreenPixelToMillimeterY() {
        return this.auto_ScreenPixelToMillimeterY;
    }

    @DOMNameAttribute(name="screenPixelToMillimeterY")
    private void setScreenPixelToMillimeterY(float value) {
        this.auto_ScreenPixelToMillimeterY = value;
    }

    @DOMNameAttribute(name="suspendRedraw")
    public long suspendRedraw(long maxWaitMilliseconds) {
        return 1L;
    }

    @DOMNameAttribute(name="unsuspendRedraw")
    public void unsuspendRedraw(long suspendHandleID) {
    }

    @DOMNameAttribute(name="unsuspendRedrawAll")
    public void unsuspendRedrawAll() {
    }

    @DOMNameAttribute(name="forceRedraw")
    public void forceRedraw() {
    }

    @DOMNameAttribute(name="pauseAnimations")
    public void pauseAnimations() {
        if (this.getOwnerSVGElement() == null) {
            this.svgContext.m72(true);
        }
    }

    @DOMNameAttribute(name="unpauseAnimations")
    public void unpauseAnimations() {
        if (this.getOwnerSVGElement() == null) {
            this.svgContext.m72(false);
        }
    }

    @DOMNameAttribute(name="animationsPaused")
    public boolean animationsPaused() {
        return this.getSVGContext().m1824();
    }

    @DOMNameAttribute(name="getCurrentTime")
    public float getCurrentTime() {
        return this.getSVGContext().getCurrentTime();
    }

    @DOMNameAttribute(name="setCurrentTime")
    public void setCurrentTime(float seconds) {
        if (this.getOwnerSVGElement() == null) {
            this.svgContext.setCurrentTime(seconds);
        }
    }

    @DOMNameAttribute(name="getIntersectionList")
    public NodeList getIntersectionList(SVGRect rect, SVGElement referenceElement) {
        return null;
    }

    @DOMNameAttribute(name="getEnclosureList")
    public NodeList getEnclosureList(SVGRect rect, SVGElement referenceElement) {
        return null;
    }

    @DOMNameAttribute(name="checkIntersection")
    public boolean checkIntersection(SVGElement element, SVGRect rect) {
        return false;
    }

    @DOMNameAttribute(name="checkEnclosure")
    public boolean checkEnclosure(SVGElement element, SVGRect rect) {
        return false;
    }

    @DOMNameAttribute(name="deselectAll")
    public void deselectAll() {
    }

    @DOMNameAttribute(name="createSVGNumber")
    public SVGNumber createSVGNumber() {
        return new SVGNumber();
    }

    @DOMNameAttribute(name="createSVGLength")
    public SVGLength createSVGLength() {
        return new SVGLength(this.getOwnerDocument().getBrowsingContext());
    }

    @DOMNameAttribute(name="createSVGAngle")
    public SVGAngle createSVGAngle() {
        return new SVGAngle(this.getOwnerDocument().getBrowsingContext());
    }

    @DOMNameAttribute(name="createSVGPoint")
    public SVGPoint createSVGPoint() {
        return new SVGPoint();
    }

    @DOMNameAttribute(name="createSVGMatrix")
    public SVGMatrix createSVGMatrix() {
        return new SVGMatrix();
    }

    @DOMNameAttribute(name="createSVGRect")
    public SVGRect createSVGRect() {
        return new SVGRect();
    }

    @DOMNameAttribute(name="createSVGTransform")
    public SVGTransform createSVGTransform() {
        return this.createSVGTransformFromMatrix(this.createSVGMatrix());
    }

    @DOMNameAttribute(name="createSVGTransformFromMatrix")
    public SVGTransform createSVGTransformFromMatrix(SVGMatrix matrix) {
        SVGTransform sVGTransform = new SVGTransform();
        sVGTransform.setMatrix((SVGMatrix)matrix.deepClone());
        return sVGTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="getElementById")
    public Element getElementById(String elementId) {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, new com.aspose.html.dom.traversal.filters.z3(elementId));
        try {
            Element element = Operators.as(iTreeWalker.nextNode(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public SVGAnimatedRect getViewBox() {
        return (SVGAnimatedRect)this.viewBox.getValue();
    }

    @Override
    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return (SVGAnimatedPreserveAspectRatio)this.preserveAspectRatio.getValue();
    }

    @Override
    public int getZoomAndPan() {
        return (Integer)this.zoomAndPan.getValue();
    }

    @Override
    public void setZoomAndPan(int value) {
        this.zoomAndPan.setValue(value);
    }

    @Override
    public Event createEvent(String eventType) {
        return this.getOwnerDocument().createEvent(eventType);
    }
}

