/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.canvas;

import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.attributes.DOMConstructorAttribute;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.attributes.DOMParameterAttribute;
import com.aspose.html.dom.canvas.ICanvasPathMethods;
import com.aspose.html.dom.canvas.z15;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.paths.SVGPathSegList;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.GraphicsPath;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.p106.z4;
import com.aspose.html.internal.p15.z13;
import com.aspose.html.internal.p82.z12;
import com.aspose.html.rendering.z10;

@DOMObjectAttribute
@DOMNameAttribute(name="Path2D")
public class Path2D
extends DOMObject
implements ICanvasPathMethods,
IDisposable {
    private z10 _pathBuilder = new z10();

    @DOMConstructorAttribute
    public Path2D() {
    }

    @DOMConstructorAttribute
    public Path2D(Path2D path) {
        this._pathBuilder = (z10)path._pathBuilder.deepClone();
    }

    @DOMConstructorAttribute
    public Path2D(String d2) {
        z12 z1210 = new z12();
        SVGPathSegList sVGPathSegList = new SVGPathSegList((IGenericEnumerable)z1210.m1(null, d2));
        z15 z1510 = new z15(this);
        z1510.m9(sVGPathSegList);
    }

    public GraphicsPath getPath() {
        return (GraphicsPath)this._pathBuilder.m265().deepClone();
    }

    @DOMNameAttribute(name="addPath")
    public void addPath(Path2D path, @DOMParameterAttribute(name="transformation", optional=true) SVGMatrix transformation) {
        if (path._pathBuilder.isEmpty()) {
            return;
        }
        GraphicsPath graphicsPath = (GraphicsPath)this._pathBuilder.m265().deepClone();
        if (transformation != null) {
            graphicsPath.transform(z13.m4(transformation.Matrix));
        }
        PointF pointF = graphicsPath.getLastPoint().Clone();
        this._pathBuilder.m265().addPath(graphicsPath, false);
        this._pathBuilder.moveTo(pointF.Clone());
    }

    @Override
    public void closePath() {
        this._pathBuilder.closePath();
    }

    @Override
    public void moveTo(double x2, double y2) {
        this._pathBuilder.moveTo(new PointF((float)x2, (float)y2));
    }

    @Override
    public void lineTo(double x2, double y2) {
        this._pathBuilder.lineTo(new PointF((float)x2, (float)y2));
    }

    @Override
    public void quadraticCurveTo(double cpx, double cpy, double x2, double y2) {
        PointF pointF = new PointF((float)cpx, (float)cpy);
        PointF pointF2 = new PointF((float)x2, (float)y2);
        PointF[] pointFArray = z4.m1(this._pathBuilder.getLastPoint().Clone(), pointF.Clone(), pointF2.Clone());
        this._pathBuilder.cubicBezierTo(pointFArray[0].Clone(), pointFArray[1].Clone(), pointF2.Clone());
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        this._pathBuilder.cubicBezierTo(new PointF((float)cp1x, (float)cp1y), new PointF((float)cp2x, (float)cp2y), new PointF((float)x2, (float)y2));
    }

    @Override
    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        this._pathBuilder.m1((float)x1, (float)y1, (float)x2, (float)y2, (float)radius);
    }

    @Override
    public void rect(double x2, double y2, double w2, double h2) {
        this._pathBuilder.addRect(new RectangleF((float)x2, (float)y2, (float)w2, (float)h2));
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle) {
        this._pathBuilder.m1((float)x2, (float)y2, (float)radius, (float)startAngle, (float)endAngle, false);
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, @DOMParameterAttribute(name="counterclockwise", optional=true) boolean counterclockwise) {
        this._pathBuilder.m1((float)x2, (float)y2, (float)radius, (float)startAngle, (float)endAngle, counterclockwise);
    }

    @Override
    public void ellipse(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle) {
        this._pathBuilder.m1((float)x2, (float)y2, (float)radiusX, (float)radiusY, (float)rotation, (float)startAngle, (float)endAngle, false);
    }

    @Override
    public void ellipse(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        this._pathBuilder.m1((float)x2, (float)y2, (float)radiusX, (float)radiusY, (float)rotation, (float)startAngle, (float)endAngle, anticlockwise);
    }

    @Override
    public void dispose() {
    }
}

