/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom;

import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.collections.NamedNodeMap;
import com.aspose.html.collections.NodeList;
import com.aspose.html.dom.Attr;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.IChildNode;
import com.aspose.html.dom.IParentNode;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.ShadowRoot;
import com.aspose.html.dom.Text;
import com.aspose.html.dom.TypeInfo;
import com.aspose.html.dom.attributes.DOMInitDictParameterAttribute;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.traversal.ITreeWalker;
import com.aspose.html.dom.traversal.filters.z1;
import com.aspose.html.dom.traversal.filters.z4;
import com.aspose.html.dom.traversal.filters.z5;
import com.aspose.html.dom.traversal.filters.z6;
import com.aspose.html.dom.traversal.filters.z8;
import com.aspose.html.dom.z2;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p108.z2;
import com.aspose.html.internal.p46.z18;
import com.aspose.html.internal.p46.z19;
import com.aspose.html.services.z10;
import com.aspose.html.z20;
import com.aspose.html.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="Element")
public class Element
extends Node
implements IChildNode,
IParentNode {
    private static final List<z20> ShadowSupportedElements = new List();
    private final String tagName;
    public z20 _Tag;
    private ShadowRoot shadowRoot;
    private NamedNodeMap attributes;
    private z18 styleContainer;
    private String localName;
    private String namespaceURI;
    private String prefix;
    private Dictionary<String, Object> store = new Dictionary();

    public Element(com.aspose.html.dom.z8 name, Document doc) {
        super(doc);
        this.localName = name.getLocalName();
        this.namespaceURI = name.getNamespaceURI();
        this.prefix = name.getPrefix();
        this.tagName = name.getTagName();
        this._Tag = z20.m27(name.getLocalName());
        this.attributes = new NamedNodeMap(this);
        this.styleContainer = new z18(this);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @DOMNameAttribute(name="tagName")
    public String getTagName() {
        return this.tagName;
    }

    @DOMNameAttribute(name="id")
    public String getId() {
        String string = this.getAttribute("id");
        if (string == null) {
            string = StringExtensions.Empty;
        }
        return string;
    }

    @DOMNameAttribute(name="id")
    public void setId(String value) {
        this.setAttribute("id", value);
    }

    @DOMNameAttribute(name="className")
    public String getClassName() {
        String string = this.getAttribute("class");
        if (string == null) {
            string = StringExtensions.Empty;
        }
        return string;
    }

    @DOMNameAttribute(name="className")
    public void setClassName(String value) {
        this.setAttribute("class", value);
    }

    @Override
    public String getTextContent() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        while (iTreeWalker.nextNode() != null) {
            msStringBuilder2.append(iTreeWalker.getCurrentNode());
        }
        return msStringBuilder2.toString();
    }

    @Override
    public void setTextContent(String value) {
        Text text = null;
        if (!StringExtensions.isNullOrEmpty(value)) {
            text = new Text(value, this.nodeDocument);
        }
        Element.replaceAll(text, this);
    }

    @DOMNameAttribute(name="getAttribute")
    @DOMNullableAttribute
    public String getAttribute(String name) {
        Attr attr = NamedNodeMap.getAttribute(name, this);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @DOMNameAttribute(name="getAttributeNS")
    @DOMNullableAttribute
    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = NamedNodeMap.getAttribute(namespaceURI, localName, this);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    @DOMNameAttribute(name="setAttribute")
    public void setAttribute(String name, String value) {
        Attr attr;
        if (!z2.m300(name)) {
            throw com.aspose.html.internal.p68.z1.m1234();
        }
        if (StringExtensions.equals(z2.z8.m3862, this.getNamespaceURI())) {
            name = StringExtensions.toLowerInvariant(name);
        }
        if ((attr = NamedNodeMap.getAttribute(name, this)) == null) {
            attr = new Attr(com.aspose.html.dom.z8.m1(name, this.prefix, null, this.nodeDocument), this.nodeDocument);
            Attr.setValue(this, attr, value);
            NamedNodeMap.append(attr, this);
            return;
        }
        Attr.change(attr, this, value);
    }

    @DOMNameAttribute(name="setAttributeNS")
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String string = null;
        String string2 = null;
        String[] stringArray = new String[]{namespaceURI};
        String[] stringArray2 = new String[]{string2};
        String[] stringArray3 = new String[]{string};
        com.aspose.html.dom.z8.m1(qualifiedName, stringArray, stringArray2, stringArray3, this.nodeDocument);
        namespaceURI = stringArray[0];
        string2 = stringArray2[0];
        string = stringArray3[0];
        NamedNodeMap.setAttribute(this, string, value, string2, namespaceURI);
    }

    @DOMNameAttribute(name="removeAttribute")
    public void removeAttribute(String name) {
        NamedNodeMap.removeAttribute(name, this);
    }

    @DOMNameAttribute(name="removeAttributeNS")
    public void removeAttributeNS(String namespaceURI, String localName) {
        NamedNodeMap.removeAttribute(namespaceURI, localName, this);
    }

    @DOMNameAttribute(name="hasAttribute")
    public boolean hasAttribute(String name) {
        return NamedNodeMap.getAttribute(name, this) != null;
    }

    @DOMNameAttribute(name="hasAttributeNS")
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return NamedNodeMap.getAttribute(namespaceURI, localName, this) != null;
    }

    @DOMNameAttribute(name="getAttributeNode")
    public Attr getAttributeNode(String name) {
        return NamedNodeMap.getAttribute(name, this);
    }

    @DOMNameAttribute(name="setAttributeNode")
    public Attr setAttributeNode(Attr newAttr) {
        return NamedNodeMap.setAttribute(newAttr, this);
    }

    @DOMNameAttribute(name="removeAttributeNode")
    public Attr removeAttributeNode(Attr oldAttr) {
        if (!NamedNodeMap.contains(this, oldAttr)) {
            throw com.aspose.html.internal.p68.z1.m1236();
        }
        NamedNodeMap.remove(oldAttr, this);
        return oldAttr;
    }

    @DOMNameAttribute(name="getAttributeNodeNS")
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return NamedNodeMap.getAttribute(namespaceURI, localName, this);
    }

    @DOMNameAttribute(name="setAttributeNodeNS")
    public Attr setAttributeNodeNS(Attr newAttr) {
        return NamedNodeMap.setAttribute(newAttr, this);
    }

    @DOMNameAttribute(name="getElementsByTagName")
    public HTMLCollection getElementsByTagName(String name) {
        return new com.aspose.html.collections.z4(this, new z6(name));
    }

    @DOMNameAttribute(name="getElementsByTagNameNS")
    public HTMLCollection getElementsByTagNameNS(String namespaceURI, String localName) {
        return new com.aspose.html.collections.z4(this, new z5(namespaceURI, localName, this.nodeDocument.getNameTable().add("*")));
    }

    @Override
    public void remove() {
        if (this.getParentNode() != null) {
            this.getParentNode().removeChild(this);
        }
    }

    @Override
    public Element getFirstElementChild() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 1L, null);
        try {
            Element element = Operators.as(iTreeWalker.firstChild(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getLastElementChild() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 1L, null);
        try {
            Element element = Operators.as(iTreeWalker.lastChild(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getPreviousElementSibling() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public int getChildElementCount() {
        return this.getChildren().getLength();
    }

    @Override
    public HTMLCollection getChildren() {
        return new com.aspose.html.collections.z4(this, new z1(this));
    }

    @Override
    public NodeList querySelectorAll(String selector) {
        return this.nodeDocument.getBrowsingContext().m6().m1(selector, (Node)this);
    }

    @Override
    public Element querySelector(String selector) {
        return this.nodeDocument.getBrowsingContext().m6().m2(selector, (Node)this);
    }

    @DOMNameAttribute(name="schemaTypeInfo")
    public TypeInfo getSchemaTypeInfo() {
        return new TypeInfo(this);
    }

    @DOMNameAttribute(name="setIdAttribute")
    public void setIdAttribute(String name, boolean isId) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="setIdAttributeNS")
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="setIdAttributeNode")
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        Attr attr = this.getAttributeNode(idAttr.getName());
        if (attr != null) {
            attr.setId(isId);
        }
    }

    @DOMNameAttribute(name="innerHTML")
    public String getInnerHTML() {
        return this.nodeDocument.getContext().getService(z10.class).m4456().m1((Node)this, new z8(this), true);
    }

    @DOMNameAttribute(name="innerHTML")
    public void setInnerHTML(String value) {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
        ((z3)this.nodeDocument.getContext()).m1(this, value);
    }

    @DOMNameAttribute(name="outerHTML")
    public String getOuterHTML() {
        return this.nodeDocument.getContext().getService(z10.class).m4456().m2(this, true);
    }

    @DOMNameAttribute(name="outerHTML")
    public void setOuterHTML(String value) {
    }

    @DOMNameAttribute(name="attachShadow")
    @DOMInitDictParameterAttribute(name="mode", optional=false)
    public ShadowRoot attachShadow(int mode) {
        if (!StringExtensions.equals(this.getNamespaceURI(), z2.z8.m3862)) {
            throw com.aspose.html.internal.p68.z1.m1237();
        }
        if (!ShadowSupportedElements.containsItem(this._Tag)) {
            throw com.aspose.html.internal.p68.z1.m1237();
        }
        if (this.shadowRoot != null) {
            throw com.aspose.html.internal.p68.z1.m1239();
        }
        this.shadowRoot = new ShadowRoot(this.nodeDocument, mode, this);
        return this.shadowRoot;
    }

    @DOMNameAttribute(name="shadowRoot")
    public ShadowRoot getShadowRoot() {
        if (this.shadowRoot == null || this.shadowRoot.getMode() == 1) {
            return null;
        }
        return this.shadowRoot;
    }

    @DOMNameAttribute(name="getElementsByClassName")
    public HTMLCollection getElementsByClassName(String classNames) {
        return new com.aspose.html.collections.z4(this, new z4(classNames));
    }

    public z18 getStyleContainer() {
        return this.styleContainer;
    }

    public z19 getComputedStyle() {
        return this.styleContainer.getComputedStyle();
    }

    public z19 getComputedStyle(String pseudoElement) {
        return this.styleContainer.getComputedStyle(pseudoElement);
    }

    public void setData(String slotName, Object data) {
        this.store.set_Item(slotName, data);
    }

    public Object getData(String slotName) {
        if (this.store.containsKey(slotName)) {
            return this.store.get_Item(slotName);
        }
        return null;
    }

    public boolean equals(z20 other) {
        if (ObjectExtensions.referenceEquals(null, other)) {
            return false;
        }
        return ObjectExtensions.referenceEquals(this._Tag, other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean disposing) {
        super.dispose(disposing);
        if (disposing) {
            this.attributes.dispose();
            IGenericEnumerator iGenericEnumerator = ((Dictionary.ValueCollection)this.store.getValues()).iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    Object e2 = iGenericEnumerator.next();
                    IDisposable iDisposable = Operators.as(e2, IDisposable.class);
                    if (iDisposable == null) continue;
                    iDisposable.dispose();
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            this.store.clear();
        }
    }

    public z20 getTag() {
        return this._Tag;
    }

    static {
        ShadowSupportedElements.addItem(z2.z9.m3876);
        ShadowSupportedElements.addItem(z2.z9.m3879);
        ShadowSupportedElements.addItem(z2.z9.m3892);
        ShadowSupportedElements.addItem(z2.z9.m3875);
        ShadowSupportedElements.addItem(z2.z9.m3901);
        ShadowSupportedElements.addItem(z2.z9.m3887);
        ShadowSupportedElements.addItem(z2.z9.m3880);
        ShadowSupportedElements.addItem(z2.z9.m3881);
        ShadowSupportedElements.addItem(z2.z9.m3882);
        ShadowSupportedElements.addItem(z2.z9.m3883);
        ShadowSupportedElements.addItem(z2.z9.m3884);
        ShadowSupportedElements.addItem(z2.z9.m3885);
        ShadowSupportedElements.addItem(z2.z9.m3886);
        ShadowSupportedElements.addItem(z2.z9.m3902);
        ShadowSupportedElements.addItem(z2.z9.m3878);
        ShadowSupportedElements.addItem(z2.z9.m3889);
        ShadowSupportedElements.addItem(z2.z9.m3877);
        ShadowSupportedElements.addItem(z2.z9.m3931);
    }
}

