/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;

@DOMObjectAttribute
@DOMNameAttribute(name="DocumentType")
public class DocumentType
extends Node {
    private final String name;
    private final String publicId;
    private final String systemId;
    private final String internalSubset;

    public DocumentType(String name, String publicId, String systemId, String internalSubset, Document doc) {
        super(doc);
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
    }

    @DOMNameAttribute(name="name")
    public String getName() {
        return this.name;
    }

    @DOMNameAttribute(name="publicId")
    public String getPublicId() {
        return this.publicId;
    }

    @DOMNameAttribute(name="systemId")
    public String getSystemId() {
        return this.systemId;
    }

    @DOMNameAttribute(name="internalSubset")
    public String getInternalSubset() {
        return this.internalSubset;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public int getNodeType() {
        return 10;
    }

    @Override
    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.appendFormat("<!DOCTYPE {0}", this.name);
        if (!StringExtensions.isNullOrEmpty(this.publicId)) {
            msStringBuilder2.appendFormat(" PUBLIC \"{0}\"", this.publicId);
        }
        if (!StringExtensions.isNullOrEmpty(this.systemId)) {
            msStringBuilder2.appendFormat(" SYSTEM \"{0}\"", this.systemId);
        }
        msStringBuilder2.append(">");
        return msStringBuilder2.toString();
    }
}

