/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.Url;
import com.aspose.html.collections.z10;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.css.ICSSStyleSheet;
import com.aspose.html.dom.css.ILinkStyle;
import com.aspose.html.dom.css.IStyleSheet;
import com.aspose.html.dom.events.Event;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Action;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.StreamReader;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p46.z21;
import com.aspose.html.internal.p73.z4;
import com.aspose.html.internal.p73.z5;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.services.INetworkService;
import com.aspose.html.z21;
import com.aspose.html.z3;
import java.util.concurrent.atomic.AtomicReference;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLLinkElement")
public class HTMLLinkElement
extends HTMLElement
implements ILinkStyle {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("alternate", "author", "bookmark", "external", "help", "icon", "license", "next", "nofollow", "noopener", "noreferrer", "prev", "search", "tag", "stylesheet");
    private z1 link;

    public HTMLLinkElement(z8 name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="disabled")
    public boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    @DOMNameAttribute(name="disabled")
    public void setDisabled(boolean value) {
        this.toggleAttribute("disabled", value);
    }

    @DOMNameAttribute(name="charset")
    public String getCharset() {
        return this.getAttributeOrDefault("charset", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="charset")
    public void setCharset(String value) {
        this.setAttribute("charset", value);
    }

    @DOMNameAttribute(name="href")
    public String getHref() {
        String string = this.getAttributeOrDefault("href", StringExtensions.Empty);
        if (string != null && StringExtensions.indexOf(string, "&amp;") != -1) {
            string = StringExtensions.replace(string, "&amp;", "&");
        }
        return string;
    }

    @DOMNameAttribute(name="href")
    public void setHref(String value) {
        this.setAttribute("href", value);
    }

    @DOMNameAttribute(name="hreflang")
    public String getHreflang() {
        return this.getAttributeOrDefault("hreflang", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="hreflang")
    public void setHreflang(String value) {
        this.setAttribute("hreflang", value);
    }

    @DOMNameAttribute(name="media")
    public String getMedia() {
        return this.getAttributeOrDefault("media", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="media")
    public void setMedia(String value) {
        this.setAttribute("media", value);
    }

    @DOMNameAttribute(name="rel")
    public String getRel() {
        return this.getAttributeOrDefault("rel", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="rel")
    public void setRel(String value) {
        this.setAttribute("rel", value);
    }

    @DOMNameAttribute(name="rev")
    public String getRev() {
        return this.getAttributeOrDefault("rev", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="rev")
    public void setRev(String value) {
        this.setAttribute("rev", value);
    }

    @DOMNameAttribute(name="target")
    public String getTarget() {
        return this.getAttributeOrDefault("target", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="target")
    public void setTarget(String value) {
        this.setAttribute("target", value);
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.getAttributeOrDefault("type", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="type")
    public void setType(String value) {
        this.setAttribute("type", value);
    }

    @Override
    public IStyleSheet getSheet() {
        if (this.link == null) {
            return null;
        }
        if (this.link.m83() == 14) {
            return ((z2)this.link).getStyleSheet();
        }
        return null;
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.link != null) {
            this.link.dispose();
        }
        super.dispose(disposing);
    }

    public void updateLink(String type) {
        if (this.link != null) {
            this.link.dispose();
        }
        if (type == null) {
            return;
        }
        switch (gStringSwitchMap.of(StringExtensions.toLowerInvariant(type))) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                this.link = new z2(this);
            }
        }
    }

    private static class z2
    extends z1 {
        private com.aspose.html.internal.p46.z21 styleSheet;
        private z4 m170;
        private AtomicReference<Action> m171 = new AtomicReference();

        public z2(final HTMLLinkElement hTMLLinkElement) {
            super(hTMLLinkElement, (byte)14);
            if (StringExtensions.isNullOrEmpty(hTMLLinkElement.getHref())) {
                return;
            }
            final z3[] z3Array = new z3[]{(z3)hTMLLinkElement.getOwnerDocument().getContext()};
            final z5[] z5Array = new z5[]{z3Array[0].m12()};
            this.styleSheet = (com.aspose.html.internal.p46.z21)z3Array[0].m6().m25(hTMLLinkElement);
            ((z10)hTMLLinkElement.getOwnerDocument().getStyleSheets()).m5(this.styleSheet);
            final Url[] urlArray = new Url[]{z3Array[0].getService(INetworkService.class).getUrlResolver().resolve(hTMLLinkElement.getOwnerDocument().getBaseURI(), hTMLLinkElement.getHref())};
            this.styleSheet.setHref(urlArray[0].getHref());
            this.m170 = z5Array[0].m4(new Action(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void invoke(Object arg1) {
                    block12: {
                        RequestMessage requestMessage = new RequestMessage(urlArray[0]);
                        try {
                            ResponseMessage responseMessage = z3Array[0].getNetwork().send(requestMessage);
                            try {
                                if (!responseMessage.isSuccess()) break block12;
                                StreamReader streamReader = new StreamReader(responseMessage.getContent().readAsStream(), z21.m31(responseMessage.getHeaders().getContentType().getCharSet()));
                                try {
                                    z3Array[0].m6().m1((ICSSStyleSheet)styleSheet, streamReader.readToEnd());
                                }
                                finally {
                                    if (streamReader != null) {
                                        streamReader.dispose();
                                    }
                                }
                            }
                            finally {
                                if (responseMessage != null) {
                                    responseMessage.dispose();
                                }
                            }
                        }
                        finally {
                            if (requestMessage != null) {
                                requestMessage.dispose();
                            }
                        }
                    }
                }
            });
            final boolean[] blArray = new boolean[]{false};
            this.m170 = com.aspose.html.internal.p75.z1.m1(this.m170, new Action(){

                public void invoke(Object arg1) {
                    ((z2)this).styleSheet.m6217.set(z21.z1.m6230);
                    if (!blArray[0]) {
                        z5Array[0].m1(new Action(){

                            public void invoke(Object arg1) {
                                hTMLLinkElement.dispatchEvent(Event.createEvent("load", new Event.z1()));
                            }
                        }, 1);
                    }
                    Action action = null;
                    action = m171.getAndSet(null);
                    if (action != null) {
                        action.invoke(this);
                    }
                }
            }, new Action<Exception>(){

                public void m2(Exception exception) {
                    blArray[0] = true;
                    z5Array[0].m1(new Action(){

                        public void invoke(Object arg1) {
                            hTMLLinkElement.dispatchEvent(Event.createEvent("error"));
                        }
                    }, 1);
                }

                @Override
                public /* synthetic */ void invoke(Object object) {
                    this.m2((Exception)object);
                }
            });
            this.m171.set(new Action(){

                public void invoke(Object arg1) {
                    hTMLLinkElement.nodeDocument.flags.m363(Node.z2.m4336);
                }
            });
            hTMLLinkElement.nodeDocument.flags.m362(Node.z2.m4336);
            z5Array[0].m5(this.m170);
        }

        public ICSSStyleSheet getStyleSheet() {
            return this.styleSheet;
        }

        @Override
        protected void dispose(boolean disposing) {
            if (disposing) {
                if (this.m170 != null) {
                    this.m170.cancel();
                }
                if (this.styleSheet != null) {
                    ((z10)this.m82().getOwnerDocument().getStyleSheets()).m4(this.styleSheet);
                }
                Action action = null;
                action = this.m171.getAndSet(null);
                if (action != null) {
                    action.invoke(this);
                }
            }
            super.dispose(disposing);
        }
    }

    private static class z1
    implements IDisposable {
        public static final byte m153 = 1;
        public static final byte m154 = 2;
        public static final byte m155 = 3;
        public static final byte m156 = 4;
        public static final byte m157 = 5;
        public static final byte m158 = 6;
        public static final byte m159 = 7;
        public static final byte m160 = 8;
        public static final byte m161 = 9;
        public static final byte m162 = 10;
        public static final byte m163 = 11;
        public static final byte m164 = 12;
        public static final byte m165 = 13;
        public static final byte m166 = 14;
        public static final byte m167 = 15;
        private HTMLLinkElement m168;
        private byte m169;

        protected z1(HTMLLinkElement hTMLLinkElement, byte by2) {
            this.m1(hTMLLinkElement);
            this.m2(by2);
        }

        public HTMLLinkElement m82() {
            return this.m168;
        }

        private void m1(HTMLLinkElement hTMLLinkElement) {
            this.m168 = hTMLLinkElement;
        }

        public byte m83() {
            return this.m169;
        }

        private void m2(byte by2) {
            this.m169 = by2;
        }

        protected void dispose(boolean disposing) {
            if (disposing) {
                this.m1(null);
            }
        }

        @Override
        public void dispose() {
            this.dispose(true);
            GC.suppressFinalize(this);
        }
    }
}

