/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLElement;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.events.z5;
import com.aspose.html.dom.traversal.filters.z6;
import com.aspose.html.dom.traversal.filters.z7;
import com.aspose.html.dom.z2;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.p148.z1;
import com.aspose.html.internal.p250.z2;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.z4;
import com.aspose.html.rendering.HtmlRenderer;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.saving.HTMLSaveOptions;
import com.aspose.html.saving.MHTMLSaveOptions;
import com.aspose.html.saving.MarkdownSaveOptions;
import com.aspose.html.services.z10;
import com.aspose.html.z20;
import com.aspose.html.z3;
import java.io.InputStream;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLDocument")
public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String cookie;
    private IViewCSS defaultView;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(z1.m19(url), configuration, 3);
    }

    public HTMLDocument(String address) {
        this(new Url(address, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public HTMLDocument(String address, Configuration configuration) {
        this(new Url(address, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public HTMLDocument(String content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public HTMLDocument(String content, String baseUri, Configuration configuration) {
        this(z1.m49(content, baseUri), configuration, 3);
    }

    public HTMLDocument(InputStream content, String baseUri) {
        this(Stream.fromJava(content), baseUri, new Configuration());
    }

    public HTMLDocument(Stream content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public HTMLDocument(InputStream content, String baseUri, Configuration configuration) {
        this(new z4(Stream.fromJava(content), new Url(baseUri, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))).getHref()), configuration);
    }

    public HTMLDocument(Stream content, String baseUri, Configuration configuration) {
        this(z1.m4(content, baseUri), configuration, 3);
    }

    public HTMLDocument(RequestMessage request) {
        this(request, new Configuration());
    }

    public HTMLDocument(RequestMessage request, Configuration configuration) {
        this(request, configuration, 1);
    }

    private HTMLDocument(final RequestMessage request, Configuration configuration, final byte flags) {
        super(new z3(configuration), new Document.z1(){
            {
                this.m1(z5.m7393);
                this.m1(request);
                this.setFlags(flags);
            }
        });
    }

    public HTMLDocument(z3 context) {
        super(context);
    }

    @DOMNameAttribute(name="title")
    public String getTitle() {
        Element element = com.aspose.html.internal.p111.z1.m3(this.getElementsByTagName(z2.z9.m3870.getTagName()));
        if (element != null) {
            return element.getTextContent();
        }
        return StringExtensions.Empty;
    }

    @DOMNameAttribute(name="title")
    public void setTitle(String value) {
        if (this.getDocumentElement() != null && StringExtensions.equals(this.getDocumentElement().getNamespaceURI(), z2.z8.m3862)) {
            Element element = com.aspose.html.internal.p111.z1.m3(this.getElementsByTagName(z20.m1(z2.z9.m3870)));
            if (element != null) {
                element.setTextContent(value);
                return;
            }
            Element element2 = com.aspose.html.internal.p111.z1.m3(this.getElementsByTagName(z20.m1(z2.z9.m3869)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(z2.z9.m3870.getTagName());
            element.setTextContent(value);
            element2.appendChild(element);
        }
    }

    @DOMNameAttribute(name="referrer")
    public String getReferrer() {
        return StringExtensions.Empty;
    }

    @DOMNameAttribute(name="domain")
    @DOMNullableAttribute
    public String getDomain() {
        return this.getLocation().getHost();
    }

    @DOMNameAttribute(name="body")
    public HTMLElement getBody() {
        com.aspose.html.collections.z4 z4100 = new com.aspose.html.collections.z4(this, new z7("BODY", "FRAMESET"));
        return (HTMLElement)com.aspose.html.internal.p111.z1.m3(z4100);
    }

    @DOMNameAttribute(name="body")
    public void setBody(HTMLElement value) {
        com.aspose.html.internal.p35.z1.m3(value, "value");
        HTMLElement hTMLElement = this.getBody();
        if (hTMLElement != null) {
            this.getDocumentElement().replaceChild(hTMLElement, value);
        } else {
            this.getDocumentElement().appendChild(value);
        }
    }

    @DOMNameAttribute(name="images")
    public HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    @DOMNameAttribute(name="applets")
    public HTMLCollection getApplets() {
        Dictionary dictionary = new Dictionary(2);
        dictionary.addItem("APPLET", null);
        List<KeyValuePair<String, String>> list = new List<KeyValuePair<String, String>>(2);
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:CAFEEFAC-00"));
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        dictionary.addItem("OBJECT", list);
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>(3);
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-applet"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-bean"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-vm"));
        dictionary.addItem("EMBED", list2);
        return new com.aspose.html.collections.z4(this, new z7("APPLET", "OBJECT", "EMBED"));
    }

    @DOMNameAttribute(name="links")
    public HTMLCollection getLinks() {
        return new com.aspose.html.collections.z4(this, new z7("A", "AREA"));
    }

    @DOMNameAttribute(name="forms")
    public HTMLCollection getForms() {
        return new com.aspose.html.collections.z4(this, new z6("FORM"));
    }

    @DOMNameAttribute(name="anchors")
    public HTMLCollection getAnchors() {
        return new com.aspose.html.collections.z4(this, new z7("A"));
    }

    @DOMNameAttribute(name="cookie")
    public String getCookie() {
        return this.cookie;
    }

    @DOMNameAttribute(name="cookie")
    public void setCookie(String value) {
        this.cookie = value;
    }

    @Override
    public ICSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return this.getBrowsingContext().m6().getOverrideStyle(elt, pseudoElt);
    }

    public void save(Url url) {
        this.save(url, 0);
    }

    public void save(String path) {
        this.save(new Url(path, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public void save(String path, int saveFormat) {
        this.save(new Url(path, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), saveFormat);
    }

    public void save(Url url, int saveFormat) {
        switch (saveFormat) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    public void save(String path, HTMLSaveOptions saveOptions) {
        this.save(new Url(path, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, HTMLSaveOptions saveOptions) {
        z2 z2100 = this.getContext().getService(z10.class).m11(this.getBrowsingContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), saveOptions);
        try {
            z2100.m4440().m23(url);
            z2100.m32(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public void save(String path, MarkdownSaveOptions saveOptions) {
        this.save(new Url(path, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, MarkdownSaveOptions saveOptions) {
        z2 z2100 = this.getContext().getService(z10.class).m11(this.getBrowsingContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), saveOptions);
        try {
            z2100.m4440().m23(url);
            z2100.m1(new com.aspose.html.internal.p250.z3<HTMLElement>(this.getBody(), this.getLocation().getHref()), Node.class);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public void save(String path, MHTMLSaveOptions saveOptions) {
        this.save(new Url(path, StringExtensions.concat(com.aspose.html.internal.p269.z2.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, MHTMLSaveOptions saveOptions) {
        z2 z2100 = this.getContext().getService(z10.class).m11(this.getBrowsingContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), saveOptions);
        try {
            z2100.m4440().m22(url);
            z2100.m4440().m23(url);
            z2100.m32(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    @Override
    public void renderTo(IDevice device) {
        HtmlRenderer htmlRenderer = new HtmlRenderer();
        try {
            htmlRenderer.render(device, this);
        }
        finally {
            if (htmlRenderer != null) {
                htmlRenderer.dispose();
            }
        }
    }
}

