/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.attributes.DOMParameterAttribute;
import com.aspose.html.dom.canvas.z5;
import com.aspose.html.dom.canvas.z9;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Imaging.Encoder;
import com.aspose.html.internal.ms.System.Drawing.Imaging.EncoderParameter;
import com.aspose.html.internal.ms.System.Drawing.Imaging.EncoderParameters;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageCodecInfo;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.io.z1;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLCanvasElement")
public class HTMLCanvasElement
extends HTMLElement {
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 150;
    private z9 _context = null;

    public HTMLCanvasElement(z8 name, Document doc) {
        super(name, doc);
    }

    private static ImageCodecInfo getEncoder(ImageFormat format) {
        ImageCodecInfo[] imageCodecInfoArray;
        for (ImageCodecInfo imageCodecInfo : imageCodecInfoArray = ImageCodecInfo.getImageDecoders()) {
            if (!Guid.op_Equality(imageCodecInfo.getFormatID(), format.getGuid())) continue;
            return imageCodecInfo;
        }
        return null;
    }

    @DOMNameAttribute(name="width")
    public long getWidth() {
        return this.getAttributeOrDefault("width", Operators.castToUInt64(300, 9), "\\d+(.\\d+)?");
    }

    @DOMNameAttribute(name="width")
    public void setWidth(long value) {
        this.setAttribute("width", Operators.castToFloat(value, 12));
    }

    @DOMNameAttribute(name="height")
    public long getHeight() {
        return this.getAttributeOrDefault("height", Operators.castToUInt64(150, 9), "\\d+(.\\d+)?");
    }

    @DOMNameAttribute(name="height")
    public void setHeight(long value) {
        this.setAttribute("height", Operators.castToFloat(value, 12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="toDataURL")
    public String toDataURL(@DOMParameterAttribute(name="type", optional=true) String type, @DOMParameterAttribute(name="type", optional=true) double encoderOptions) {
        block18: {
            z5 z5100 = new z5(this);
            try {
                MemoryStream memoryStream = new MemoryStream();
                Bitmap bitmap = z5100.m1008();
                if (StringExtensions.isNullOrEmpty(type) || StringExtensions.equals("image/png", type)) {
                    bitmap.save(memoryStream, ImageFormat.getPng());
                    String string = StringExtensions.concat("data:image/png;base64,", Convert.toBase64String(memoryStream.getBuffer()));
                    return string;
                }
                if (!StringExtensions.equals("image/jpeg", type)) break block18;
                EncoderParameters encoderParameters = new EncoderParameters(1);
                encoderParameters.getParam()[0] = new EncoderParameter(Encoder.Quality, Operators.castToInt32(encoderOptions * 100.0, 14));
                bitmap.save(memoryStream, HTMLCanvasElement.getEncoder(ImageFormat.getJpeg()), encoderParameters);
                String string = StringExtensions.concat("data:image/jpeg;base64,", Convert.toBase64String(memoryStream.getBuffer()));
                return string;
                {
                    finally {
                        if (bitmap != null) {
                            bitmap.dispose();
                        }
                    }
                }
                finally {
                    if (memoryStream != null) {
                        memoryStream.dispose();
                    }
                }
            }
            finally {
                if (z5100 != null) {
                    z5100.dispose();
                }
            }
        }
        return "";
    }

    @DOMNameAttribute(name="toBlob")
    private void toBlob() {
    }

    @DOMNameAttribute(name="toBlob")
    private void toBlob(String type) {
    }

    @DOMNameAttribute(name="toBlob")
    public void toBlob(@DOMParameterAttribute(name="type", optional=true) String mimeType, @DOMParameterAttribute(name="type", optional=true) double qualityArgument) {
    }

    public z1 getBlob() {
        return this.getBlob("image/png", 0.25);
    }

    public z1 getBlob(String type) {
        return this.getBlob(type, 0.25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public z1 getBlob(String type, double encoderOptions) {
        block19: {
            if (encoderOptions < 0.0 || encoderOptions > 1.0) {
                encoderOptions = 0.25;
            }
            z5 z5100 = new z5(this);
            try {
                MemoryStream memoryStream = new MemoryStream();
                Bitmap bitmap = z5100.m1008();
                if (StringExtensions.equals("image/jpeg", type)) {
                    EncoderParameters encoderParameters = new EncoderParameters(1);
                    encoderParameters.getParam()[0] = new EncoderParameter(Encoder.Quality, Operators.castToInt32(encoderOptions * 100.0, 14));
                    bitmap.save(memoryStream, HTMLCanvasElement.getEncoder(ImageFormat.getJpeg()), encoderParameters);
                    z1 z1100 = new z1(memoryStream.getBuffer(), "image/jpeg");
                    return z1100;
                }
                if (!StringExtensions.isNullOrEmpty(type) && !StringExtensions.equals("image/png", type)) break block19;
                bitmap.save(memoryStream, ImageFormat.getPng());
                z1 z1101 = new z1(memoryStream.getBuffer(), "image/png");
                return z1101;
                {
                    finally {
                        if (bitmap != null) {
                            bitmap.dispose();
                        }
                    }
                }
                finally {
                    if (memoryStream != null) {
                        memoryStream.dispose();
                    }
                }
            }
            finally {
                if (z5100 != null) {
                    z5100.dispose();
                }
            }
        }
        return new z1();
    }

    @DOMNameAttribute(name="getContext")
    public Object getContext(String contextId, Object ... args) {
        if (StringExtensions.equals(contextId, "2d") && this._context == null) {
            this._context = new z9(this);
        }
        return this._context;
    }
}

